/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutNotifaction;
import com.jrockit.mc.components.ui.design.LayoutToolkit;
import com.jrockit.mc.components.ui.design.OperationType;
import com.jrockit.mc.components.ui.design.actions.DesignElementAction;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.view.components.ComponentDescriptorWizardPage;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.ui.misc.ImageImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public final class AssignComponentAction
extends DesignElementAction {
    private final IServiceLocator m_serviceLocator;
    private final ComponentTypeDescriptor m_type;

    public AssignComponentAction(IServiceLocator locator, IDesignElement element, ComponentTypeDescriptor componentTypeDescriptor) {
        super(componentTypeDescriptor.getName(), element);
        this.m_serviceLocator = locator;
        this.m_type = componentTypeDescriptor;
        this.setImageDescriptor((ImageDescriptor)new ImageImageDescriptor(componentTypeDescriptor.getIcon()));
    }

    public void run() {
        LayoutItem li = this.getLayoutItem();
        String oldName = LayoutToolkit.getDisplayName(li);
        ComponentDescriptor componentDescriptor = ComponentDescriptorWizardPage.openNew(this.m_serviceLocator, this.m_type);
        if (componentDescriptor != null) {
            li.setComponentDescripor(componentDescriptor);
            if (this.m_type.isContainer()) {
                if (li.getChildren().isEmpty()) {
                    li.add(new LayoutItem());
                    li.add(new LayoutItem());
                }
            } else {
                li.getChildren().clear();
            }
            li.setChanged();
            ComponentTypeDescriptor ctd = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptor(componentDescriptor.getTypeIdentifier());
            Image image = ctd != null ? ctd.getIcon() : null;
            OperationType type = new OperationType(true, image);
            li.notifyObservers(LayoutNotifaction.create(type, NLS.bind((String)Messages.DESIGN_ACTION_ASSIGN_TO_TEXT, (Object)LayoutToolkit.getDisplayName(li), (Object)oldName), li));
        }
    }
}

