/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class WindowOverlayPane {
    private final Pane pane = new Pane();

    public WindowOverlayPane() {
        this.pane.pickOnBoundsProperty().set(false);
    }

    public void addOverlay(Node node, ObservableDoubleValue x, ObservableDoubleValue y) {
        this.addOverlay(node, x, y, false);
    }

    public void addOverlay(Node node, ObservableDoubleValue x, ObservableDoubleValue y, boolean moveLeftIfNeeded) {
        this.pane.getChildren().add((Object)node);
        if (moveLeftIfNeeded) {
            node.layoutXProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)x, (ObservableNumberValue)this.pane.widthProperty().subtract((ObservableNumberValue)((Region)node).widthProperty())));
        } else {
            node.layoutXProperty().bind((ObservableValue)x);
        }
        node.layoutYProperty().bind((ObservableValue)y);
    }

    public void removeOverlay(Node node) {
        this.pane.getChildren().remove((Object)node);
    }

    public double sceneXToWindowOverlayX(double sceneX) {
        return this.pane.sceneToLocal(sceneX, 0.0).getX();
    }

    public double sceneYToWindowOverlayY(double sceneY) {
        return this.pane.sceneToLocal(0.0, sceneY).getY();
    }

    public Node getNode() {
        return this.pane;
    }
}

