/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.TextEditor;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameEditorTab;
import bluej.parser.AssistContent;
import bluej.parser.CodeSuggestions;
import bluej.parser.ParseUtils;
import bluej.parser.PrefixCompletionWrapper;
import bluej.parser.SourceLocation;
import bluej.parser.entity.EntityResolver;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.ClassTarget;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.TopLevelCodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.LocalCompletion;
import bluej.stride.framedjava.frames.LocalTypeCompletion;
import bluej.stride.framedjava.frames.PrimitiveDebugVarInfo;
import bluej.stride.framedjava.frames.ReferenceDebugVarInfo;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.JavaReflective;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Tab;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import nu.xom.Element;
import nu.xom.Serializer;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class FrameEditor
implements Editor {
    private boolean isCompiled;
    private boolean changedSinceLastSave = true;
    private File frameFilename;
    private File javaFilename;
    private final FXTabbedEditor fXTabbedEditor;
    private final EntityResolver resolver;
    private final EditorWatcher watcher;
    private final JavadocResolver javadocResolver;
    private final SimpleObjectProperty<JavaSource> javaSource;
    private Package pkg;
    private FrameEditorTab panel;
    private final AtomicBoolean panelOpen;
    private final DebugInfo debugInfo = new DebugInfo();
    private HighlightedBreakpoint curBreakpoint;
    private TopLevelCodeElement lastSource;
    private final List<QueuedError> queuedErrors = new ArrayList<QueuedError>();

    @OnThread(value=Tag.FX)
    public FrameEditor(FXTabbedEditor fXTabbedEditor, File frameFilename, File javaFilename, EditorWatcher watcher, EntityResolver resolver, JavadocResolver javadocResolver, Package pkg) {
        this.frameFilename = frameFilename;
        this.javaFilename = javaFilename;
        this.watcher = watcher;
        this.fXTabbedEditor = fXTabbedEditor;
        this.resolver = resolver;
        this.javadocResolver = javadocResolver;
        this.pkg = pkg;
        this.javaSource = new SimpleObjectProperty();
        this.lastSource = Loader.loadTopLevelElement((File)frameFilename, (EntityResolver)resolver);
        this.panelOpen = new AtomicBoolean();
        ObservableList<Tab> tabs = fXTabbedEditor.tabsProperty();
        tabs.addListener(c -> this.panelOpen.set(tabs.contains((Object)this.panel)));
    }

    @OnThread(value=Tag.FX)
    private void createPanel(boolean visible, boolean toFront) {
        this.panel = new FrameEditorTab(this.fXTabbedEditor, this.resolver, this, this.lastSource);
        this.fXTabbedEditor.addFrameEditor(this.panel, this.panel::getMenus, visible, toFront);
        this.panel.initialisedProperty().addListener((a, b, newVal) -> {
            if (newVal.booleanValue()) {
                Platform.runLater(() -> {
                    this._saveFX();
                    this.findLateErrors();
                });
            }
        });
    }

    @Override
    public void close() {
        Platform.runLater(() -> {
            if (this.panel != null) {
                this.lastSource = this.panel.getSource();
                this.panel.setWindowVisible(false, false);
            }
        });
    }

    @Override
    @OnThread(value=Tag.Swing)
    public void save() throws IOException {
        CompletableFuture q = new CompletableFuture();
        Platform.runLater(() -> q.complete(Optional.ofNullable(this._saveFX())));
        Optional e = null;
        try {
            e = (Optional)q.get();
        }
        catch (InterruptedException | ExecutionException e1) {
            Debug.reportError((Throwable)e1);
        }
        if (e.isPresent()) {
            throw new IOException((Throwable)e.get());
        }
        this.setSaved();
    }

    private void setSaved() {
        if (this.watcher != null) {
            this.watcher.saveEvent(this);
        }
    }

    @OnThread(value=Tag.FX)
    private IOException _saveFX() {
        if (!this.changedSinceLastSave) {
            return null;
        }
        try {
            if (this.panel == null || this.panel.getSource() == null) {
                this.saveJava(this.lastSource, true);
                return null;
            }
            this.panel.regenerateAndReparse(null);
            TopLevelCodeElement source = this.panel.getSource();
            if (source == null) {
                return null;
            }
            FileOutputStream os = new FileOutputStream(this.frameFilename);
            Serializer s = new Serializer((OutputStream)os);
            s.setLineSeparator("\n");
            s.setIndent(4);
            Element saveEl = source.toXML();
            saveEl.addNamespaceDeclaration("xml", "http://www.w3.org/XML/1998/namespace");
            s.write(new nu.xom.Document(saveEl));
            s.flush();
            os.close();
            this.saveJava(this.panel.getSource(), true);
            this.changedSinceLastSave = false;
            this.panel.saved();
            return null;
        }
        catch (IOException e) {
            return e;
        }
    }

    @Override
    @OnThread(value=Tag.Swing)
    public void saveJavaWithoutWarning() throws IOException {
        CompletableFuture q = new CompletableFuture();
        Platform.runLater(() -> {
            try {
                this.saveJava(this.lastSource, false);
                q.complete(Optional.empty());
            }
            catch (IOException e) {
                q.complete(Optional.of(e));
            }
        });
        Optional e = null;
        try {
            e = (Optional)q.get();
        }
        catch (InterruptedException | ExecutionException e1) {
            Debug.reportError((Throwable)e1);
        }
        if (e.isPresent()) {
            throw new IOException((Throwable)e.get());
        }
    }

    @OnThread(value=Tag.FX)
    private void saveJava(TopLevelCodeElement source, boolean warning) throws IOException {
        if (source == null) {
            return;
        }
        FileWriter w = new FileWriter(this.javaFilename);
        JavaSource js = source.toJavaSource(warning);
        String javaString = js.toDiskJavaCodeString();
        w.write(javaString);
        w.close();
        this.javaSource.set((Object)js);
    }

    @Override
    public TextEditor assumeText() {
        return new TextEditor(){

            @Override
            @OnThread(value=Tag.Swing)
            public void writeMessage(String msg) {
                FrameEditor.this.writeMessage(msg);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void showInterface(boolean interfaceStatus) {
                FrameEditor.this.showInterface(interfaceStatus);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setVisible(boolean vis) {
                FrameEditor.this.setVisible(vis);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setReadOnly(boolean readOnly) {
                FrameEditor.this.setReadOnly(readOnly);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setProperty(String propertyKey, Object value) {
                FrameEditor.this.setProperty(propertyKey, value);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setCompiled(boolean compiled) {
                FrameEditor.this.setCompiled(compiled);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void save() throws IOException {
                FrameEditor.this.save();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void removeStepMark() {
                FrameEditor.this.removeStepMark();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void removeBreakpoints() {
                FrameEditor.this.removeBreakpoints();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void reloadFile() {
                FrameEditor.this.reloadFile();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void refresh() {
                FrameEditor.this.refresh();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void reInitBreakpoints() {
                FrameEditor.this.reInitBreakpoints();
            }

            @Override
            @OnThread(value=Tag.Any)
            public void printTo(PrinterJob printerJob, boolean printLineNumbers, boolean printBackground) {
                FrameEditor.this.printTo(printerJob, printLineNumbers, printBackground);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public boolean isShowingInterface() {
                return FrameEditor.this.isShowingInterface();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public boolean isOpen() {
                return FrameEditor.this.isOpen();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public boolean isReadOnly() {
                return FrameEditor.this.isReadOnly();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public boolean isModified() {
                return FrameEditor.this.isModified();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public Object getProperty(String propertyKey) {
                return FrameEditor.this.getProperty(propertyKey);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void displayMessage(String message, int lineNumber, int column, boolean beep, boolean setStepMark, String help) {
                FrameEditor.this.displayMessage(message, lineNumber, column, beep, setStepMark, help);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public boolean displayDiagnostic(Diagnostic diagnostic, int errorIndex) {
                return FrameEditor.this.displayDiagnostic(diagnostic, errorIndex);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void close() {
                FrameEditor.this.close();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void changeName(String title, String filename, String javaFilename, String docFileName) {
                FrameEditor.this.changeName(title, filename, javaFilename, docFileName);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public TextEditor assumeText() {
                return this;
            }

            @Override
            @OnThread(value=Tag.Swing)
            public boolean showFile(String filename, Charset charset, boolean compiled, String docFilename) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setText(SourceLocation begin, SourceLocation end, String newText) throws BadLocationException {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setSelection(int firstlineNumber, int firstColumn, int secondLineNumber, int SecondColumn) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setSelection(SourceLocation begin, SourceLocation end) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setSelection(int lineNumber, int column, int len) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void setCaretLocation(SourceLocation location) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public int numberOfLines() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void insertText(String text, boolean caretBack) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public int getTextLength() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public String getText(SourceLocation begin, SourceLocation end) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public Document getSourceDocument() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public SourceLocation getSelectionEnd() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public SourceLocation getSelectionBegin() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public ParsedCUNode getParsedNode() {
                return null;
            }

            @Override
            @OnThread(value=Tag.Swing)
            public int getOffsetFromLineColumn(SourceLocation location) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public int getLineLength(int line) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public SourceLocation getLineColumnFromOffset(int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public SourceLocation getCaretLocation() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void compileFinished(boolean successful) {
                throw new UnsupportedOperationException();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void insertAppendMethod(bluej.extensions.editor.Editor e, NormalMethodElement method, Consumer<Boolean> after) {
                FrameEditor.this.insertAppendMethod(e, method, after);
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void insertMethodCallInConstructor(bluej.extensions.editor.Editor e, String className, CallElement methodName, Consumer<Boolean> after) {
                FrameEditor.this.insertMethodCallInConstructor(e, className, methodName, after);
            }

            @Override
            @OnThread(value=Tag.FX)
            public FrameEditor assumeFrame() {
                return FrameEditor.this;
            }

            @Override
            @OnThread(value=Tag.Swing)
            public boolean compileStarted() {
                return FrameEditor.this.compileStarted();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void showNextError() {
                FrameEditor.this.showNextError();
            }

            @Override
            @OnThread(value=Tag.Swing)
            public void cancelFreshState() {
                FrameEditor.this.cancelFreshState();
            }
        };
    }

    @Override
    public void reloadFile() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void displayMessage(String message, int lineNumber, int column, boolean beep, boolean setStepMark, String help) {
        if (setStepMark) {
            Platform.runLater(() -> {
                this.setVisibleFX(true, true);
                SwingUtilities.invokeLater(() -> {
                    DebuggerObject currentObject;
                    Debug.message((String)"Hit breakpoint in EditorFrame");
                    DebuggerThread t = this.getSimulationThread();
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    if (t != null && (currentObject = t.getCurrentObject(0)) != null && !currentObject.isNullObject()) {
                        Map restrictedClasses = this.pkg.getProject().getExecControls().getRestrictedClasses();
                        List fields = currentObject.getFields();
                        for (DebuggerField field : fields) {
                            String declaringClass;
                            Set whiteList;
                            if (Modifier.isStatic(field.getModifiers()) || (whiteList = (Set)restrictedClasses.get(declaringClass = field.getDeclaringClassName())) != null && !whiteList.contains(field.getName())) continue;
                            if (field.isReferenceType()) {
                                vars.put(field.getName(), new ReferenceDebugVarInfo(this.pkg, null, field));
                                continue;
                            }
                            vars.put(field.getName(), new PrimitiveDebugVarInfo(field.getValueString()));
                        }
                    }
                    this.debugInfo.addVarState(vars);
                    Platform.runLater(() -> {
                        if (this.curBreakpoint != null) {
                            this.curBreakpoint.removeHighlight();
                        }
                        this.curBreakpoint = ((JavaSource)this.javaSource.get()).handleStop(lineNumber, this.debugInfo);
                    });
                });
            });
        } else {
            Debug.message((String)("Will select: " + lineNumber));
            Platform.runLater(() -> JavaFXUtil.onceNotNull(this.javaSource, js -> js.handleException(lineNumber)));
        }
    }

    private DebuggerThread findThread(DebuggerThreadTreeModel model, Object t, String targetName) {
        DebuggerThread thread = model.getNodeAsDebuggerThread(t);
        if (thread != null && targetName.equals(thread.getName())) {
            return thread;
        }
        for (int i = 0; i < model.getChildCount(t); ++i) {
            DebuggerThread child = this.findThread(model, model.getChild(t, i), targetName);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private void printAndChildren(DebuggerThreadTreeModel model, Object t) {
        Debug.message((String)("Thread: " + t.toString()));
        for (int i = 0; i < model.getChildCount(t); ++i) {
            this.printAndChildren(model, model.getChild(t, i));
        }
    }

    @Override
    public boolean displayDiagnostic(Diagnostic diagnostic, int errorIndex) {
        Platform.runLater(() -> {
            if (this.panel != null && this.panel.getSource() != null) {
                this.panel.setWindowVisible(true, false);
                JavaFXUtil.onceNotNull(this.javaSource, js -> js.handleError((int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn(), (int)diagnostic.getEndLine(), (int)diagnostic.getEndColumn(), diagnostic.getMessage(), true));
            } else {
                this.queuedErrors.add(new QueuedError(diagnostic.getStartLine(), diagnostic.getStartColumn(), diagnostic.getEndLine(), diagnostic.getEndColumn(), diagnostic.getMessage()));
            }
        });
        return true;
    }

    @Override
    public void writeMessage(String msg) {
    }

    @Override
    public void removeStepMark() {
    }

    @Override
    public void changeName(String title, String filename, String javaFilename, String docFileName) {
        this.frameFilename = new File(filename);
        this.javaFilename = new File(javaFilename);
    }

    @Override
    public void setCompiled(boolean compiled) {
        this.isCompiled = compiled;
    }

    @Override
    public void removeBreakpoints() {
    }

    @Override
    public void reInitBreakpoints() {
        this.watcher.clearAllBreakpoints();
        if (this.javaSource == null) {
            try {
                this.save();
            }
            catch (IOException e) {
                Debug.reportError((Throwable)e);
            }
        }
        if (this.javaSource.get() != null) {
            ((JavaSource)this.javaSource.get()).registerBreakpoints((Editor)this, this.watcher);
        }
    }

    @Override
    public boolean isModified() {
        return !this.isCompiled;
    }

    @Override
    @OnThread(value=Tag.Any)
    public void printTo(PrinterJob printerJob, boolean printLineNumbers, boolean printBackground) {
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void showInterface(boolean interfaceStatus) {
    }

    @Override
    public boolean isShowingInterface() {
        return false;
    }

    @Override
    public Object getProperty(String propertyKey) {
        return null;
    }

    @Override
    public void setProperty(String propertyKey, Object value) {
    }

    @Override
    public void setVisible(boolean vis) {
        Platform.runLater(() -> this.setVisibleFX(vis, true));
    }

    @OnThread(value=Tag.FX)
    private void setVisibleFX(boolean show, boolean bringToFront) {
        if (this.panel == null && show) {
            this.createPanel(show, bringToFront);
        }
        if (this.panel != null) {
            this.panel.setWindowVisible(show, bringToFront);
        }
        if (show) {
            Platform.runLater(() -> {
                if (!this.queuedErrors.isEmpty()) {
                    ArrayList<QueuedError> queueCopy = new ArrayList<QueuedError>(this.queuedErrors);
                    this.queuedErrors.clear();
                    JavaFXUtil.onceNotNull(this.javaSource, js -> {
                        for (QueuedError e : queueCopy) {
                            if (js.handleError((int)e.startLine, (int)e.startColumn, (int)e.endLine, (int)e.endColumn, e.message, false)) continue;
                            Debug.message((String)"Retrying showing error after saving");
                            Platform.runLater(() -> {
                                if (this._saveFX() == null) {
                                    boolean result = ((JavaSource)this.javaSource.get()).handleError((int)e.startLine, (int)e.startColumn, (int)e.endLine, (int)e.endColumn, e.message, true);
                                    Debug.message((String)("Retrying: " + (result ? "success" : "failure")));
                                }
                            });
                        }
                        Platform.runLater(() -> Platform.runLater(() -> this.panel.updateErrorOverviewBar(false)));
                    });
                }
            });
        }
    }

    @OnThread(value=Tag.FX)
    public void codeModified() {
        this.isCompiled = false;
        this.changedSinceLastSave = true;
        SwingUtilities.invokeLater(() -> this.watcher.modificationEvent(this));
    }

    @Override
    @OnThread(value=Tag.FX)
    public FrameEditor assumeFrame() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.panelOpen.get();
    }

    public void step() {
        DebuggerThread t = this.getSimulationThread();
        t.step();
    }

    private DebuggerThread getSimulationThread() {
        DebuggerThreadTreeModel model = this.pkg.getDebugger().getThreadTreeModel();
        DebuggerThread t = this.findThread(model, model.getRoot(), "SimulationThread");
        return t;
    }

    public void cont() {
        DebuggerThread t = this.getSimulationThread();
        t.cont();
    }

    @Override
    public void compileFinished(boolean successful) {
        if (this.panelOpen.get()) {
            this.findLateErrors();
            Platform.runLater(() -> this.panel.compiled());
            this.reInitBreakpoints();
        }
    }

    @OnThread(value=Tag.Any)
    private void findLateErrors() {
        Platform.runLater(() -> {
            this.panel.removeOldErrors();
            TopLevelCodeElement el = this.panel.getSource();
            Stream<CodeElement> allElements = Stream.concat(Stream.of((CodeElement)el), el.streamContained());
            List futures = allElements.flatMap(e -> e.findDirectLateErrors((InteractionManager)this.panel)).collect(Collectors.toList());
            new Thread(() -> {
                try {
                    for (Future f : futures) {
                        f.get();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    Debug.reportError((Throwable)e);
                }
                Platform.runLater(() -> this.panel.updateErrorOverviewBar(false));
            }).start();
        });
    }

    @Override
    public boolean compileStarted() {
        if (this.panelOpen.get()) {
            Platform.runLater(() -> this.panel.flagErrorsAsOld());
            TopLevelCodeElement el = this.panel.getSource();
            if (el != null) {
                return el.findEarlyErrors().count() > 0L;
            }
            return true;
        }
        this.queuedErrors.clear();
        return this.lastSource.findEarlyErrors().count() > 0L;
    }

    public boolean readyToCompile() {
        return this.pkg.getDebugger() != null;
    }

    public AssistContent[] getCompletions(TopLevelCodeElement allCode, JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, CodeElement codeEl) {
        AssistContent[] assists;
        CodeSuggestions suggests = allCode.getCodeSuggestions(pos, completing);
        ArrayList<AssistContent> joined = new ArrayList<AssistContent>();
        if (suggests != null && (assists = ParseUtils.getPossibleCompletions((CodeSuggestions)suggests, (JavadocResolver)this.javadocResolver, null)) != null) {
            joined.addAll(Arrays.asList(assists));
        }
        if (suggests != null && suggests.isPlain()) {
            JavaReflective greenfootClassRef = new JavaReflective(this.pkg.loadClass("greenfoot.Greenfoot"));
            CodeSuggestions greenfootClass = new CodeSuggestions((JavaType)new GenTypeClass((Reflective)greenfootClassRef), null, null, true, false);
            AssistContent[] greenfootStatic = ParseUtils.getPossibleCompletions((CodeSuggestions)greenfootClass, (JavadocResolver)this.javadocResolver, null);
            Arrays.stream(greenfootStatic).filter(ac -> ac.getKind() == AssistContent.CompletionKind.METHOD).forEach(ac -> joined.add((AssistContent)new PrefixCompletionWrapper(ac, "Greenfoot.")));
            for (CodeElement.LocalParamInfo v : ASTUtility.findLocalsAndParamsInScopeAt((CodeElement)codeEl, (boolean)false)) {
                AssistContent c = LocalCompletion.getCompletion((String)v.getType(), (String)v.getName(), (boolean)v.isParam());
                if (c == null) continue;
                joined.add(c);
            }
        }
        return joined.toArray(new AssistContent[0]);
    }

    public List<AssistContent> getAvailableMembers(TopLevelCodeElement allCode, JavaFragment.PosInSourceDoc pos, Set<AssistContent.CompletionKind> kinds, boolean includeOverridden) {
        List<Object> members;
        CodeSuggestions suggests = allCode.getCodeSuggestions(pos, null);
        if (suggests == null) {
            return Collections.emptyList();
        }
        if (includeOverridden) {
            members = new ArrayList();
            ParseUtils.getPossibleCompletions((CodeSuggestions)suggests, (JavadocResolver)this.javadocResolver, (ac, isOverridden) -> members.add(ac));
        } else {
            AssistContent[] result = ParseUtils.getPossibleCompletions((CodeSuggestions)suggests, (JavadocResolver)this.javadocResolver, null);
            members = result == null ? Collections.emptyList() : Arrays.asList(result);
        }
        return members.stream().filter(ac -> kinds == null || kinds.contains(ac.getKind())).collect(Collectors.toList());
    }

    @Override
    public void insertAppendMethod(bluej.extensions.editor.Editor e, NormalMethodElement method, Consumer<Boolean> after) {
        Platform.runLater(() -> {
            if (this.panel == null) {
                this.createPanel(false, false);
            }
            after.accept(this.panel.insertAppendMethod(method));
        });
    }

    @Override
    public void insertMethodCallInConstructor(bluej.extensions.editor.Editor e, String className, CallElement methodName, Consumer<Boolean> after) {
        Platform.runLater(() -> {
            if (this.panel == null) {
                this.createPanel(false, false);
            }
            after.accept(this.panel.insertMethodCallInConstructor(className, methodName));
        });
    }

    @OnThread(value=Tag.FX)
    public TopLevelCodeElement getSource() {
        return this.panel.getSource();
    }

    @OnThread(value=Tag.Swing)
    public List<AssistContentThreadSafe> getLocalTypes(Class<?> superType, boolean includeSelf, Set<InteractionManager.Kind> kinds) {
        return this.pkg.getClassTargets().stream().filter(ct -> {
            if (superType != null) {
                ClassInfo info = ct.getSourceInfo().getInfoIfAvailable();
                if (info == null) {
                    return false;
                }
                boolean hasSuperType = false;
                hasSuperType |= superType.getName().equals(info.getSuperclass());
                if (!(hasSuperType |= info.getImplements().stream().anyMatch(s -> superType.getName().equals(s)))) {
                    return false;
                }
            }
            if (ct.isInterface()) {
                return kinds.contains(InteractionManager.Kind.INTERFACE);
            }
            if (ct.isEnum()) {
                return kinds.contains(InteractionManager.Kind.ENUM);
            }
            return kinds.contains(InteractionManager.Kind.CLASS_FINAL) || kinds.contains(InteractionManager.Kind.CLASS_NON_FINAL);
        }).map(ct -> new AssistContentThreadSafe(LocalTypeCompletion.getCompletion((ClassTarget)ct))).collect(Collectors.toList());
    }

    @Override
    public void showNextError() {
        Platform.runLater(() -> this.panel.nextError());
    }

    @Override
    @OnThread(value=Tag.Swing)
    public void cancelFreshState() {
        if (this.panelOpen.get()) {
            Platform.runLater(() -> this.panel.cancelFreshState());
        }
    }

    public JavadocResolver getJavadocResolver() {
        return this.javadocResolver;
    }

    @OnThread(value=Tag.Any)
    private static class QueuedError {
        private final long startLine;
        private final long startColumn;
        private final long endLine;
        private final long endColumn;
        private final String message;

        private QueuedError(long startLine, long startColumn, long endLine, long endColumn, String message) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.message = message;
        }
    }
}

