/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.WindowOverlayPane;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class FXTabbedEditor {
    private final SimpleBooleanProperty showingCatalogue = new SimpleBooleanProperty(true);
    private final Project project;
    private final IdentityHashMap<Tab, Callable<List<Menu>>> tabMenus = new IdentityHashMap();
    private final ArrayList<Frame> dragSourceFrames = new ArrayList();
    private final SimpleDoubleProperty mouseDragXProperty = new SimpleDoubleProperty();
    private final SimpleDoubleProperty mouseDragYProperty = new SimpleDoubleProperty();
    private Stage stage;
    private Scene scene;
    private TabPane tabPane;
    private Pane dragPane;
    private Pane dragCursorPane;
    private WindowOverlayPane overlayPane;
    private FrameCatalogue cataloguePane;
    private MenuBar menuBar;
    private ObservableList<Tab> tabs;
    private Tab hoverTab;
    private ScheduledFuture<?> hoverTabTask;
    private ImageView dragIcon = null;
    private IdentityHashMap<Tab, ReadOnlyStringProperty> tabAddresses = new IdentityHashMap();

    @OnThread(value=Tag.Any)
    public FXTabbedEditor(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Swing)
    public void initialise() {
        if (Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Unexpected call of initialise from FX thread");
        }
        Object o = new Object();
        String windowTitle = this.project.getProjectName() + " - Stride";
        Object object = o;
        synchronized (object) {
            Platform.runLater(() -> {
                this.stage = new Stage();
                this.stage.setTitle(windowTitle);
                this.stage.getIcons().add((Object)BlueJTheme.getApplicationFxIcon((String)"greenfoot", (boolean)true));
                this.initialiseFX();
                Object object = o;
                synchronized (object) {
                    o.notify();
                }
            });
            try {
                o.wait();
            }
            catch (InterruptedException e) {
                Debug.reportError((Throwable)e);
            }
        }
    }

    private void initialiseFX() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(Main.getStoredContextClassLoader());
        }
        Config.loadFXFonts();
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.tabs = this.tabPane.getTabs();
        this.menuBar = new MenuBar();
        JavaFXUtil.addStyleClass((Styleable)this.menuBar, (String[])new String[]{"editor-menubar"});
        this.menuBar.setUseSystemMenuBar(true);
        this.dragPane = new Pane();
        this.dragPane.setMouseTransparent(true);
        this.dragCursorPane = new Pane();
        this.dragCursorPane.setMouseTransparent(true);
        this.cataloguePane = new FrameCatalogue();
        BorderPane menuAndTabPane = new BorderPane();
        menuAndTabPane.setTop((Node)this.menuBar);
        this.overlayPane = new WindowOverlayPane();
        menuAndTabPane.setCenter((Node)new StackPane(new Node[]{this.tabPane, this.dragPane, this.dragCursorPane}));
        ScrollPane catalogueScrollPane = new ScrollPane((Node)this.cataloguePane){

            public void requestFocus() {
            }
        };
        catalogueScrollPane.setMaxWidth(200.0);
        catalogueScrollPane.setMinWidth(0.0);
        catalogueScrollPane.setFitToWidth(true);
        catalogueScrollPane.setFocusTraversable(false);
        catalogueScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        catalogueScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        JavaFXUtil.addStyleClass((Styleable)catalogueScrollPane, (String[])new String[]{"catalogue-scroll"});
        BorderPane catalogueBackground = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)catalogueBackground, (String[])new String[]{"catalogue-background"});
        Label title = new Label(Config.getString((String)"frame.catalogue.title"));
        BorderPane.setAlignment((Node)title, (Pos)Pos.BOTTOM_RIGHT);
        catalogueBackground.setBottom((Node)title);
        StackPane catalogueScrollPaneStacked = new StackPane(new Node[]{catalogueBackground, catalogueScrollPane});
        BorderPane collapsibleCatalogueScrollPane = new BorderPane();
        collapsibleCatalogueScrollPane.setCenter((Node)catalogueScrollPaneStacked);
        catalogueScrollPaneStacked.setMinWidth(0.0);
        CollapseControl collapseControl = new CollapseControl((Region)catalogueScrollPaneStacked, (FXConsumer<Boolean>)((FXConsumer)showing -> catalogueScrollPane.setVbarPolicy(showing != false ? ScrollPane.ScrollBarPolicy.AS_NEEDED : ScrollPane.ScrollBarPolicy.NEVER)));
        JavaFXUtil.addChangeListener((ObservableValue)this.showingCatalogue, expanded -> PrefMgr.setFlag((String)"bluej.editor.stride.sidebarShowing", (boolean)expanded));
        Platform.runLater(() -> this.showingCatalogue.set(PrefMgr.getFlag((String)"bluej.editor.stride.sidebarShowing")));
        collapsibleCatalogueScrollPane.setLeft((Node)collapseControl);
        JavaFXUtil.addStyleClass((Styleable)collapsibleCatalogueScrollPane, (String[])new String[]{"catalogue-scroll-collapsible"});
        menuAndTabPane.setRight((Node)collapsibleCatalogueScrollPane);
        this.scene = new Scene((Parent)new StackPane(new Node[]{menuAndTabPane, this.overlayPane.getNode()}), 800.0, 700.0);
        this.stage.setScene(this.scene);
        Config.addEditorStylesheets((Scene)this.scene);
        this.tabPane.getStyleClass().add((Object)"tabbed-editor");
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((a, b, selTab) -> {
            if (this.tabMenus.containsKey(selTab)) {
                try {
                    List<Menu> menus = this.tabMenus.get(selTab).call();
                    this.menuBar.getMenus().setAll(menus);
                }
                catch (Exception e) {
                    Debug.reportError((Throwable)e);
                }
            }
            if (this.isWindowVisible() && !(selTab instanceof FrameEditorTab)) {
                this.scheduleUpdateCatalogue(null, null, CodeCompletionState.NOT_POSSIBLE, false, Frame.View.NORMAL, Collections.emptyList());
            }
        });
        this.tabPane.getTabs().addListener(e -> {
            List<Tab> tabAddressKeysToRemove = this.tabAddresses.entrySet().stream().map(ta -> (Tab)ta.getKey()).collect(Collectors.toList());
            tabAddressKeysToRemove.removeIf(arg_0 -> this.tabPane.getTabs().contains(arg_0));
            tabAddressKeysToRemove.forEach(this.tabAddresses::remove);
            if (this.tabPane.getTabs().isEmpty()) {
                this.stage.close();
            }
        });
        this.tabPane.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (!e.isControlDown()) {
                return;
            }
            int tab = this.tabPane.getSelectionModel().getSelectedIndex();
            switch (e.getCode()) {
                case DIGIT1: {
                    tab = 0;
                    break;
                }
                case DIGIT2: {
                    tab = 1;
                    break;
                }
                case DIGIT3: {
                    tab = 2;
                    break;
                }
                case DIGIT4: {
                    tab = 3;
                    break;
                }
                case DIGIT5: {
                    tab = 4;
                    break;
                }
                case DIGIT6: {
                    tab = 5;
                    break;
                }
                case DIGIT7: {
                    tab = 6;
                    break;
                }
                case DIGIT8: {
                    tab = 7;
                    break;
                }
                case DIGIT9: {
                    tab = 8;
                    break;
                }
                case TAB: {
                    if (e.isShiftDown()) {
                        if (--tab >= 0) break;
                        tab = this.tabPane.getTabs().size() - 1;
                        break;
                    }
                    tab = (tab + 1) % this.tabPane.getTabs().size();
                    break;
                }
                default: {
                    return;
                }
            }
            if (tab < this.tabPane.getTabs().size()) {
                this.tabPane.getSelectionModel().select(this.tabPane.getTabs().get(tab));
            }
            e.consume();
        });
        Config.loadFXFonts();
    }

    public void showCatalogue() {
        this.showingCatalogue.set(true);
    }

    public BooleanProperty catalogueShowingProperty() {
        return this.showingCatalogue;
    }

    @OnThread(value=Tag.FX)
    public void addFrameEditor(FrameEditorTab panel, Callable<List<Menu>> getMenus, boolean visible, boolean toFront) {
        this.tabMenus.put(panel, getMenus);
        panel.initialiseFX(this.scene);
        if (!this.tabPane.getTabs().contains((Object)panel)) {
            this.tabPane.getTabs().add((Object)panel);
            if (toFront) {
                this.setWindowVisible(visible, panel);
                this.bringToFront(panel);
                Platform.runLater(panel::focusWhenShown);
            }
        }
    }

    public void openJavaCoreDocTab(String qualifiedClassName) {
        this.openJavaCoreDocTab(qualifiedClassName, "");
    }

    public void openJavaCoreDocTab(String qualifiedClassName, String suffix) {
        String target = Utility.getDocURL((String)qualifiedClassName, (String)suffix);
        this.openWebViewTab(target);
    }

    public void openGreenfootDocTab(String qualifiedClassName) {
        this.openGreenfootDocTab(qualifiedClassName, "");
    }

    public void openGreenfootDocTab(String qualifiedClassName, String suffix) {
        try {
            String target = Utility.getGreenfootApiDocURL((String)(qualifiedClassName.replace('.', '/') + ".html"));
            this.openWebViewTab(target + suffix);
        }
        catch (IOException e) {
            Debug.reportError((Throwable)e);
        }
    }

    public void setWindowVisible(boolean visible, Tab tab) {
        if (visible) {
            if (!this.stage.isShowing()) {
                this.stage.show();
            }
            if (!this.tabPane.getTabs().contains((Object)tab)) {
                this.tabPane.getTabs().add((Object)tab);
            }
        } else {
            this.tabPane.getTabs().remove((Object)tab);
        }
    }

    public boolean isWindowVisible() {
        return this.stage.isShowing();
    }

    public Rectangle windowBoundsProperty() {
        return new Rectangle((int)this.stage.getX(), (int)this.stage.getY(), (int)this.stage.getWidth(), (int)this.stage.getHeight());
    }

    public void bringToFront(Tab tab) {
        this.stage.setIconified(false);
        Utility.bringToFrontFX((Stage)this.stage);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    @OnThread(value=Tag.Any)
    public Project getProject() {
        return this.project;
    }

    @OnThread(value=Tag.Any)
    public void scheduleCompilation() {
        this.project.scheduleCompilation(false);
    }

    public void close(Tab tab) {
        this.tabPane.getTabs().remove((Object)tab);
        this.tabMenus.remove(tab);
        this.tabAddresses.remove(tab);
    }

    public Node getJavaIcon() {
        Label j = new Label("J");
        JavaFXUtil.addStyleClass((Styleable)j, (String[])new String[]{"icon-label"});
        return j;
    }

    private Node getWebIcon() {
        Label j = new Label("W");
        JavaFXUtil.addStyleClass((Styleable)j, (String[])new String[]{"icon-label"});
        return j;
    }

    public void openWebViewTab(String url) {
        try {
            URI target = new URI(url);
            for (Map.Entry<Tab, ReadOnlyStringProperty> e : this.tabAddresses.entrySet()) {
                URI tabURI = new URI((String)e.getValue().get());
                if (!tabURI.equals(target)) continue;
                this.bringToFront(e.getKey());
                return;
            }
        }
        catch (URISyntaxException e) {
            Debug.reportError((String)("Error in URI when opening web view tab: \"" + url + "\""));
        }
        WebView browser = new WebView();
        Debug.message((String)("Loading webpage: " + url));
        browser.getEngine().load(url);
        Tab tab = new Tab();
        tab.setGraphic(this.getWebIcon());
        tab.setContent((Node)browser);
        tab.textProperty().bind((ObservableValue)browser.getEngine().titleProperty());
        this.tabAddresses.put(tab, browser.getEngine().locationProperty());
        this.tabMenus.put(tab, () -> Arrays.asList(new Menu("Documentation", null, new MenuItem[]{JavaFXUtil.makeMenuItem((String)"Close", () -> this.close(tab), (KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}))})));
        this.tabPane.getTabs().add((Object)tab);
        this.tabPane.getSelectionModel().select((Object)tab);
        if (!this.stage.isShowing()) {
            this.stage.show();
        }
        this.bringToFront(tab);
    }

    public ObservableList<Tab> tabsProperty() {
        return this.tabs;
    }

    public Pane getDragPane() {
        return this.dragPane;
    }

    public Pane getDragCursorPane() {
        return this.dragCursorPane;
    }

    public void frameDragBegin(List<Frame> srcFrames, double mouseSceneX, double mouseSceneY) {
        if (this.dragIcon != null || !this.dragSourceFrames.isEmpty()) {
            throw new IllegalStateException("Drag begun while drag in progress");
        }
        this.dragSourceFrames.clear();
        this.dragSourceFrames.addAll(srcFrames);
        Image img = Frame.takeShot(this.dragSourceFrames, null);
        if (this.dragSourceFrames.stream().allMatch(Frame::canDrag) && img != null) {
            ImageView icon = new ImageView(img);
            icon.setEffect((Effect)new DropShadow(7.0, 2.0, 2.0, Color.BLACK));
            for (Frame src : this.dragSourceFrames) {
                src.setDragSourceEffect(true);
            }
            double srcSceneX = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getX();
            double srcSceneY = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getY();
            icon.layoutXProperty().bind((ObservableValue)this.mouseDragXProperty.subtract(mouseSceneX - srcSceneX));
            icon.layoutYProperty().bind((ObservableValue)this.mouseDragYProperty.subtract(mouseSceneY - srcSceneY));
            this.getDragPane().getChildren().add((Object)icon);
            this.dragIcon = icon;
            this.scene.setCursor(Cursor.CLOSED_HAND);
        } else {
            this.dragSourceFrames.clear();
        }
    }

    public void draggedTo(double sceneX, double sceneY, boolean copying) {
        if (!this.dragSourceFrames.isEmpty()) {
            Point2D p = this.dragPane.sceneToLocal(sceneX, sceneY);
            this.mouseDragXProperty.set(p.getX());
            this.mouseDragYProperty.set(p.getY());
            this.checkHoverDuringDrag(sceneX, sceneY, copying);
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)((Object)this.tabPane.getSelectionModel().getSelectedItem())).draggedToTab(this.dragSourceFrames, sceneX, sceneY, copying);
            }
        }
    }

    public boolean isDragging() {
        return !this.dragSourceFrames.isEmpty();
    }

    private void checkHoverDuringDrag(double sceneX, double sceneY, boolean copying) {
        for (Tab t : this.tabPane.getTabs()) {
            Bounds b = t.getGraphic().localToScene(t.getGraphic().getBoundsInLocal());
            if (!b.contains(sceneX, sceneY) || this.hoverTab == t || !(t instanceof FrameEditorTab)) continue;
            this.hoverTab = t;
            if (this.hoverTabTask != null) {
                this.hoverTabTask.cancel(false);
            }
            this.hoverTabTask = Utility.getBackground().schedule(() -> Platform.runLater(() -> {
                ((FrameEditorTab)((Object)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem())))).draggedToAnotherTab();
                this.tabPane.getSelectionModel().select((Object)t);
                ((FrameEditorTab)t).draggedTo(sceneX, sceneY, copying);
            }), 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void frameDragEnd(boolean copying) {
        if (this.hoverTabTask != null) {
            this.hoverTabTask.cancel(false);
        }
        this.hoverTab = null;
        if (!this.dragSourceFrames.isEmpty()) {
            this.getDragPane().getChildren().remove((Object)this.dragIcon);
            this.dragIcon = null;
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)((Object)this.tabPane.getSelectionModel().getSelectedItem())).dragEndTab(this.dragSourceFrames, copying);
            }
            this.dragSourceFrames.clear();
            this.scene.setCursor(Cursor.DEFAULT);
        }
    }

    public void scheduleUpdateCatalogue(FrameEditorTab editor, FrameCursor c, CodeCompletionState codeCompletion, boolean selection, Frame.View viewMode, List<FrameCatalogue.Hint> hints) {
        this.cataloguePane.scheduleUpdateCatalogue(editor, (FrameCursor)(viewMode == Frame.View.NORMAL ? c : null), codeCompletion, selection, viewMode, hints);
    }

    public WindowOverlayPane getOverlayPane() {
        return this.overlayPane;
    }

    private class CollapseControl
    extends BorderPane {
        private final Duration EXPAND_COLLAPSE_DURATION = Duration.millis((double)200.0);
        private final Scale scale;
        private FXRunnable cancelHover;

        public CollapseControl(Region collapse, final FXConsumer<Boolean> listener) {
            JavaFXUtil.addStyleClass((Styleable)this, (String[])new String[]{"catalogue-collapse"});
            Canvas control = new Canvas(8.0, 12.0);
            GraphicsContext gc = control.getGraphicsContext2D();
            gc.setFill((Paint)Color.DARKGRAY);
            gc.fillPolygon(new double[]{1.0, control.getWidth() - 1.0, 1.0, 1.0}, new double[]{1.0, 6.0, 11.0, 1.0}, 4);
            this.setCenter((Node)control);
            this.setFocusTraversable(false);
            this.setMinWidth(10.0);
            this.scale = new Scale(1.0, 1.0, control.getWidth() / 2.0, control.getHeight() / 2.0);
            control.getTransforms().add((Object)this.scale);
            SimpleDoubleProperty shrinkExpand = new SimpleDoubleProperty(1.0);
            collapse.maxWidthProperty().bind((ObservableValue)shrinkExpand.multiply(collapse.getMaxWidth()));
            collapse.prefWidthProperty().bind((ObservableValue)collapse.maxWidthProperty());
            this.setOnMouseClicked(e -> FXTabbedEditor.this.showingCatalogue.set(!FXTabbedEditor.this.showingCatalogue.get()));
            JavaFXUtil.addChangeListener((ObservableValue)FXTabbedEditor.this.showingCatalogue, (FXConsumer)new FXConsumer<Boolean>((DoubleProperty)shrinkExpand){
                private Timeline animation = null;
                final /* synthetic */ DoubleProperty val$shrinkExpand;
                {
                    this.val$shrinkExpand = doubleProperty;
                }

                public void accept(Boolean nowExpanded) {
                    listener.accept((Object)nowExpanded);
                    this.animate(nowExpanded);
                }

                private void animate(boolean expand) {
                    if (this.animation != null) {
                        this.animation.stop();
                        this.animation = null;
                    }
                    this.animation = new Timeline(new KeyFrame[]{new KeyFrame(CollapseControl.this.EXPAND_COLLAPSE_DURATION, new KeyValue[]{new KeyValue((WritableValue)this.val$shrinkExpand, (Object)(expand ? 1.0 : 0.0), Interpolator.EASE_OUT), new KeyValue((WritableValue)CollapseControl.this.scale.xProperty(), (Object)(expand ? 1.0 : -1.0))})});
                    this.animation.play();
                }
            });
            this.setOnMouseEntered(e -> {
                if (this.cancelHover != null) {
                    this.cancelHover.run();
                }
                this.cancelHover = JavaFXUtil.runAfter((Duration)Duration.millis((double)200.0), () -> JavaFXUtil.setPseudoclass((String)"bj-hover-long", (boolean)true, (Node[])new Node[]{this}));
            });
            this.setOnMouseExited(e -> {
                if (this.cancelHover != null) {
                    this.cancelHover.run();
                    this.cancelHover = null;
                }
                JavaFXUtil.setPseudoclass((String)"bj-hover-long", (boolean)false, (Node[])new Node[]{this});
            });
        }
    }

    public static enum CodeCompletionState {
        NOT_POSSIBLE,
        SHOWING,
        POSSIBLE;

    }
}

