/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import threadchecker.OnThread;
import threadchecker.Tag;

public class PrintDialog
extends EscapeDialog {
    private boolean ok;
    private JCheckBox printLineNumbers;
    private JCheckBox printHighlighting;
    private boolean printLineNumbersSelected;
    private boolean printHighlightingSelected;

    public PrintDialog(Frame parent) {
        super(parent, Config.getString((String)"editor.printDialog.title"), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                PrintDialog.this.ok = false;
                PrintDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.add(Box.createVerticalStrut(17));
        this.printLineNumbers = new JCheckBox(Config.getString((String)"editor.printDialog.printLineNumbers"));
        this.printLineNumbers.setSelected(true);
        mainPanel.add(this.printLineNumbers);
        this.printHighlighting = new JCheckBox(Config.getString((String)"editor.printDialog.printHighlighting"));
        mainPanel.add(this.printHighlighting);
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDialog.this.doCancel();
            }
        });
        DialogManager.addOKCancelButtons((JPanel)buttonPanel, (JButton)okButton, (JButton)cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog((JDialog)((Object)this));
    }

    public boolean display() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    public void doOK() {
        this.ok = true;
        this.storeValues();
        this.setVisible(false);
    }

    public void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    @OnThread(value=Tag.Any)
    public boolean printLineNumbers() {
        return this.printLineNumbersSelected;
    }

    @OnThread(value=Tag.Any)
    public boolean printHighlighting() {
        return this.printHighlightingSelected;
    }

    private void storeValues() {
        this.printLineNumbersSelected = this.printLineNumbers.isSelected();
        this.printHighlightingSelected = this.printHighlighting.isSelected();
    }
}

