/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeErrorManager;
import bluej.editor.moe.NaviView;
import bluej.editor.moe.NaviviewEditorKit;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JEditorPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.Document;
import javax.swing.text.View;

public class NVDrawPane
extends JEditorPane {
    private NaviView nview;
    private int repaintTop;
    private int repaintEnd;

    public NVDrawPane(NaviView nview, MoeErrorManager errorMgr) {
        this.nview = nview;
        Font smallFont = new Font("Monospaced", 1, 1);
        this.setFont(smallFont);
        this.setEditorKit(new NaviviewEditorKit(nview, errorMgr));
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        this.setBorder(null);
        this.fakeRepaint();
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.fakeRepaint();
    }

    private void fakeRepaint() {
        BufferedImage bi = new BufferedImage(1, 1, 2);
        Graphics g = bi.getGraphics();
        g.setClip(0, 0, 1, 1);
        this.getUI().paint(g, this);
    }

    @Override
    public void repaint() {
        if (this.nview != null) {
            Rectangle r = this.getBounds();
            this.repaint(0L, r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (this.nview != null) {
            this.repaintTop = y;
            this.repaintEnd = y + height;
            this.nview.repaintModel(this.repaintTop, this.repaintEnd);
        }
    }

    @Override
    public Rectangle getBounds() {
        View view = this.getUI().getRootView(this);
        Rectangle r = new Rectangle(1, (int)view.getPreferredSpan(1));
        return r;
    }
}

