/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class MoeSyntaxEvent
implements DocumentEvent,
NodeStructureListener {
    private MoeSyntaxDocument document;
    private DocumentEvent srcEvent;
    private List<NodeTree.NodeAndPosition<ParsedNode>> removedNodes = new LinkedList<NodeTree.NodeAndPosition<ParsedNode>>();
    private Map<ParsedNode, NodeChangeRecord> changedNodes = new HashMap<ParsedNode, NodeChangeRecord>();
    private DocumentEvent.EventType eventType;

    public MoeSyntaxEvent(MoeSyntaxDocument document, DocumentEvent srcEvent) {
        this.document = document;
        this.srcEvent = srcEvent;
        this.eventType = srcEvent.getType();
    }

    public MoeSyntaxEvent(MoeSyntaxDocument document) {
        this.document = document;
        this.eventType = DocumentEvent.EventType.CHANGE;
    }

    public List<NodeTree.NodeAndPosition<ParsedNode>> getRemovedNodes() {
        return this.removedNodes;
    }

    public Collection<NodeChangeRecord> getChangedNodes() {
        return this.changedNodes.values();
    }

    @Override
    public DocumentEvent.ElementChange getChange(Element elem) {
        return this.srcEvent != null ? this.srcEvent.getChange(elem) : null;
    }

    public MoeSyntaxDocument getDocument() {
        return this.document;
    }

    @Override
    public int getLength() {
        return this.srcEvent != null ? this.srcEvent.getLength() : 0;
    }

    @Override
    public int getOffset() {
        return this.srcEvent != null ? this.srcEvent.getOffset() : 0;
    }

    @Override
    public DocumentEvent.EventType getType() {
        return this.eventType;
    }

    public void nodeRemoved(NodeTree.NodeAndPosition<ParsedNode> node) {
        this.removedNodes.add(node);
        this.changedNodes.remove(node.getNode());
    }

    public void nodeChangedLength(NodeTree.NodeAndPosition<ParsedNode> nap, int oldPos, int oldSize) {
        NodeChangeRecord r = this.changedNodes.get(nap.getNode());
        if (r == null) {
            if (nap.getPosition() != oldPos || nap.getSize() != oldSize) {
                r = new NodeChangeRecord();
                r.nap = nap;
                r.originalPos = oldPos;
                r.originalSize = oldSize;
                this.changedNodes.put((ParsedNode)nap.getNode(), r);
            }
        } else if (nap.getPosition() == r.originalPos && nap.getSize() == r.originalSize) {
            this.changedNodes.remove(nap.getNode());
        } else {
            r.nap = nap;
        }
    }

    @OnThread(value=Tag.Any)
    public class NodeChangeRecord {
        public int originalPos;
        public int originalSize;
        public NodeTree.NodeAndPosition<ParsedNode> nap;
    }
}

