/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeDocumentListener;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeHighlighter;
import bluej.editor.moe.MoeSquigglyUnderlineHighlighterPainter;
import bluej.parser.SourceLocation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import threadchecker.OnThread;
import threadchecker.Tag;

public class MoeErrorManager
implements MoeDocumentListener {
    private static final Color ERROR_HIGHLIGHT_GRADIENT1 = new Color(240, 128, 128);
    private static final Color ERROR_HIGHLIGHT_GRADIENT2 = new Color(240, 190, 190);
    private static final Color ERROR_HIGHLIGHT_SELECTED1 = ERROR_HIGHLIGHT_GRADIENT1;
    private static final Color ERROR_HIGHLIGHT_SELECTED2 = ERROR_HIGHLIGHT_GRADIENT2;
    private final List<ErrorDetails> errorInfos = new ArrayList<ErrorDetails>();
    private MoeEditor editor;
    private Consumer<Boolean> setNextErrorEnabled;

    public MoeErrorManager(MoeEditor editor, Consumer<Boolean> setNextErrorEnabled) {
        this.editor = editor;
        this.setNextErrorEnabled = setNextErrorEnabled;
    }

    public void addErrorHighlight(int startPos, int endPos, String message) {
        if (endPos < startPos) {
            throw new IllegalArgumentException("Error ends before it begins: " + startPos + " to " + endPos);
        }
        JEditorPane sourcePane = this.editor.getSourcePane();
        try {
            MoeHighlighter highlighter = (MoeHighlighter)sourcePane.getHighlighter();
            MoeSquigglyUnderlineHighlighterPainter painter = new MoeSquigglyUnderlineHighlighterPainter(Color.RED, offs -> this.editor.getLineColumnFromOffset((int)offs).getLine());
            Object errorHighlightTag = highlighter.addHighlight(startPos, endPos, painter);
            this.errorInfos.add(new ErrorDetails(errorHighlightTag, startPos, endPos, message));
            this.setNextErrorEnabled.accept(true);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    public void removeAllErrorHighlights() {
        JEditorPane sourcePane = this.editor.getSourcePane();
        for (ErrorDetails err : this.errorInfos) {
            sourcePane.getHighlighter().removeHighlight(err.highlightTag);
        }
        this.errorInfos.clear();
        this.setNextErrorEnabled.accept(false);
    }

    public int getNextErrorPos(int from) {
        int lowestDist = Integer.MIN_VALUE;
        ErrorDetails next = null;
        for (ErrorDetails err : this.errorInfos) {
            int dist = err.startPos - from;
            if (next != null && (lowestDist > 0 || dist <= 0 && dist > lowestDist) && (lowestDist <= 0 || dist <= 0 || dist > lowestDist)) continue;
            next = err;
            lowestDist = dist;
        }
        if (next == null) {
            return -1;
        }
        return next.startPos;
    }

    public void insertUpdate(DocumentEvent e) {
        this.setNextErrorEnabled.accept(false);
    }

    public void removeUpdate(DocumentEvent e) {
        this.setNextErrorEnabled.accept(false);
    }

    public ErrorDetails getErrorAtPosition(int pos) {
        return this.errorInfos.stream().filter(e -> e.startPos <= pos && pos <= e.endPos).findFirst().orElse(null);
    }

    @Override
    @OnThread(value=Tag.Any)
    public void parseError(int position, int size, String message) {
    }

    @Override
    @OnThread(value=Tag.Any)
    public void reparsingRange(int position, int size) {
    }

    public ErrorDetails getErrorOnLine(int lineIndex) {
        int lineStart = this.editor.getOffsetFromLineColumn(new SourceLocation(lineIndex + 1, 1));
        if (lineIndex + 1 >= this.editor.numberOfLines()) {
            return this.errorInfos.stream().filter(e -> e.endPos >= lineStart).findFirst().orElse(null);
        }
        int lineEnd = this.editor.getOffsetFromLineColumn(new SourceLocation(lineIndex + 2, 1));
        return this.errorInfos.stream().filter(e -> e.startPos <= lineEnd && e.endPos >= lineStart).findFirst().orElse(null);
    }

    public static class ErrorDetails {
        public final int startPos;
        public final int endPos;
        public final String message;
        private final Object highlightTag;

        private ErrorDetails(Object highlightTag, int startPos, int endPos, String message) {
            this.highlightTag = highlightTag;
            this.startPos = startPos;
            this.endPos = endPos;
            this.message = message;
        }
    }
}

