/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.EscapeDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GoToLineDialog
extends EscapeDialog
implements ActionListener {
    static final String goToLineTitle = Config.getString((String)"editor.gotoline.title");
    static final String goToLineLabel = Config.getString((String)"editor.gotoline.label");
    static final String notNumericMessage = Config.getString((String)"editor.gotoline.notNumericMessage");
    static final String notInRangeMessage = Config.getString((String)"editor.gotoline.notInRangeMessage");
    static final int INVALID_NUMBER = -1;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField lineNumberField;
    private JLabel instructionLabel;
    private JLabel messageLabel;
    private int lineNumber = -1;
    private int sizeOfClass;

    public GoToLineDialog(Frame owner) {
        super(owner, goToLineTitle, true);
        this.makeDialog();
    }

    public void showDialog(int range) {
        this.sizeOfClass = range;
        this.instructionLabel.setText(goToLineLabel + " ( 1 - " + range + " )");
        this.lineNumberField.requestFocus();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.okButton) {
            this.doOK();
        } else if (src == this.cancelButton) {
            this.doCancel();
        }
    }

    private void makeDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                GoToLineDialog.this.doCancel();
            }
        });
        JPanel bodyPanel = new JPanel();
        bodyPanel.setLayout(new BoxLayout(bodyPanel, 1));
        bodyPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        this.instructionLabel = new JLabel(goToLineLabel);
        bodyPanel.add(this.instructionLabel);
        bodyPanel.add(Box.createVerticalStrut(6));
        this.lineNumberField = new JTextField();
        bodyPanel.add(this.lineNumberField);
        bodyPanel.add(Box.createVerticalStrut(6));
        IntegerDocument integerDocument1 = new IntegerDocument();
        this.lineNumberField.setDocument(integerDocument1);
        this.messageLabel = new JLabel(" ");
        bodyPanel.add(this.messageLabel);
        bodyPanel.add(Box.createVerticalStrut(6));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        this.okButton = BlueJTheme.getOkButton();
        this.okButton.addActionListener(this);
        this.cancelButton = BlueJTheme.getCancelButton();
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        bodyPanel.add(buttonPanel);
        this.getContentPane().add((Component)bodyPanel, "Center");
        this.pack();
    }

    private void doOK() {
        this.lineNumber = this.validateInput();
        this.clear();
        this.setVisible(false);
    }

    private void doCancel() {
        this.lineNumber = -1;
        this.setVisible(false);
    }

    private void clear() {
        this.lineNumberField.setText("");
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private int validateInput() {
        int validatedNumber = -1;
        try {
            validatedNumber = Integer.parseInt(this.lineNumberField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return validatedNumber;
    }

    @OnThread(value=Tag.Swing, ignoreParent=true)
    class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            String newValue;
            if (string == null) {
                return;
            }
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuffer currentBuffer = new StringBuffer(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            try {
                int parsedNumber = this.checkInputIsInteger(newValue);
                if (this.checkInputRange(parsedNumber)) {
                    super.insertString(offset, string, attributes);
                    GoToLineDialog.this.messageLabel.setText(" ");
                }
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
                GoToLineDialog.this.messageLabel.setText(notNumericMessage);
            }
        }

        private int checkInputIsInteger(String proposedValue) throws NumberFormatException {
            int newValue = 0;
            if (proposedValue.length() > 0) {
                newValue = Integer.parseInt(proposedValue);
            }
            return newValue;
        }

        private boolean checkInputRange(int parsedNumber) {
            return parsedNumber > 0 && parsedNumber <= GoToLineDialog.this.sizeOfClass;
        }
    }
}

