/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.parser.AssistContent;
import bluej.prefmgr.PrefMgr;
import bluej.utility.DBoxLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class CodeCompleteCellRenderer
extends JPanel
implements ListCellRenderer {
    private final JLabel typeLabel = new JLabel();
    private final JLabel descriptionLabel = new JLabel();
    private final Dimension rtypeSize;
    private final String immediateType;
    private final Font cfont;
    private final Font cfontBold;

    CodeCompleteCellRenderer(String immediateType) {
        this.setBorder(null);
        this.setLayout((LayoutManager)new DBoxLayout(DBoxLayout.X_AXIS));
        int fontSize = PrefMgr.getStandardEditorFont().getSize();
        this.cfont = Config.getFont((String)"bluej.codecompletion.font", (String)"Monospaced", (int)fontSize);
        this.cfontBold = this.cfont.deriveFont(1);
        this.typeLabel.setFont(this.cfont);
        this.typeLabel.setText("String123456");
        this.rtypeSize = this.typeLabel.getPreferredSize();
        this.typeLabel.setMaximumSize(this.rtypeSize);
        this.typeLabel.setMinimumSize(this.rtypeSize);
        this.typeLabel.setPreferredSize(this.rtypeSize);
        this.typeLabel.setForeground(new Color(90, 80, 45));
        this.add(this.typeLabel);
        this.add(this.descriptionLabel);
        this.add(Box.createHorizontalGlue());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.immediateType = immediateType;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null && list.isValid() && index <= list.getLastVisibleIndex() && index >= list.getFirstVisibleIndex()) {
            AssistContent content = (AssistContent)value;
            this.typeLabel.setText(content.getType().toString());
            this.descriptionLabel.setText(content.getName() + "(" + content.getParams().stream().map(AssistContent.ParamInfo::getUnqualifiedType).collect(Collectors.joining(", ")) + ")");
            if (content.getDeclaringClass() != null && content.getDeclaringClass().equals(this.immediateType)) {
                this.descriptionLabel.setFont(this.cfontBold);
            } else {
                this.descriptionLabel.setFont(this.cfont);
            }
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            if (!Config.isRaspberryPi()) {
                this.setOpaque(true);
            }
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            if (!Config.isRaspberryPi()) {
                this.setOpaque(false);
            }
        }
        return this;
    }
}

