/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor;

import bluej.editor.moe.MoeEditor;
import bluej.pkgmgr.Project;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.IdentityHashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing)
public class SwingTabbedEditor {
    private final JFrame window;
    private final JTabbedPane tabPane;
    private final Project project;
    private final IdentityHashMap<Component, MoeEditor> panelToEditor = new IdentityHashMap();
    private final IdentityHashMap<MoeEditor, Component> editorToPanel = new IdentityHashMap();
    private final IdentityHashMap<MoeEditor, HeaderPanel> editorToHeader = new IdentityHashMap();
    private final IdentityHashMap<MoeEditor, JMenuBar> menuBars = new IdentityHashMap();

    public SwingTabbedEditor(Project project) {
        this.window = new JFrame(project.getProjectName() + " - Java");
        this.tabPane = new JTabbedPane();
        this.window.add(this.tabPane);
        this.tabPane.addChangeListener(evt -> {
            MoeEditor editor = this.panelToEditor.get(this.tabPane.getSelectedComponent());
            this.window.setJMenuBar(this.menuBars.get(editor));
            for (MoeEditor ed : this.editorToPanel.keySet()) {
                ed.notifyVisibleTab(ed == editor && this.window.isFocused());
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                for (MoeEditor ed : SwingTabbedEditor.this.editorToPanel.keySet()) {
                    ed.notifyVisibleTab(false);
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MoeEditor editor = (MoeEditor)SwingTabbedEditor.this.panelToEditor.get(SwingTabbedEditor.this.tabPane.getSelectedComponent());
                Iterator iterator = SwingTabbedEditor.this.editorToPanel.keySet().iterator();
                while (iterator.hasNext()) {
                    MoeEditor ed;
                    ed.notifyVisibleTab((ed = (MoeEditor)iterator.next()) == editor);
                }
            }
        };
        this.window.addWindowFocusListener(windowFocusListener);
        this.project = project;
    }

    public void setEditorVisible(boolean visible, MoeEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Cannot show null editor");
        }
        if (visible) {
            Component editorTab = this.getMoeEditorTab(editor);
            if (!this.window.isShowing()) {
                this.window.pack();
                this.window.setVisible(true);
                EventQueue.invokeLater(() -> {
                    if (this.window.getWidth() % 2 == 0) {
                        this.window.setSize(this.window.getWidth() + 1, this.window.getHeight());
                    } else {
                        this.window.setSize(this.window.getWidth() - 1, this.window.getHeight());
                    }
                });
            }
            this.tabPane.setSelectedComponent(editorTab);
        } else {
            Component tab = this.editorToPanel.get(editor);
            this.tabPane.remove(tab);
            this.panelToEditor.remove(tab);
            this.editorToPanel.remove(editor);
            this.editorToHeader.remove(editor);
            if (this.tabPane.getTabCount() == 0) {
                this.window.setVisible(false);
            }
        }
    }

    private Component getMoeEditorTab(MoeEditor editor) {
        if (!this.editorToPanel.containsKey(editor)) {
            JPanel tmp = new JPanel();
            tmp.setLayout(new BorderLayout());
            tmp.add((Component)editor, "Center");
            this.panelToEditor.put(tmp, editor);
            this.editorToPanel.put(editor, tmp);
            HeaderPanel header = new HeaderPanel(editor);
            this.editorToHeader.put(editor, header);
            this.tabPane.addTab(editor.getTitle(), tmp);
            this.tabPane.setTabComponentAt(this.tabPane.indexOfComponent(tmp), header);
        }
        return this.editorToPanel.get(editor);
    }

    public void bringToFront() {
        this.window.toFront();
        Utility.bringToFront((Window)this.window);
        MoeEditor editor = this.panelToEditor.get(this.tabPane.getSelectedComponent());
        editor.getSourcePane().requestFocusInWindow();
        editor.getSourcePane().setVisible(true);
    }

    public void scheduleCompilation(boolean immediate) {
        this.project.scheduleCompilation(immediate);
    }

    public JMenuBar getJMenuBar(MoeEditor e) {
        return this.menuBars.get(e);
    }

    public void setJMenuBar(MoeEditor e, JMenuBar menuBar) {
        this.menuBars.put(e, menuBar);
    }

    public void setTitle(MoeEditor moeEditor, String title) {
        this.editorToHeader.get(moeEditor).setTitle(title);
    }

    private class CloseIcon
    implements Icon {
        private int width = 16;
        private int height = 16;

        private CloseIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            this.width = this.height = g2d.getFontMetrics(g2d.getFont()).getHeight();
            int offset = 5;
            g2d.setColor(Color.BLACK);
            g2d.drawLine(x + offset, y + offset, this.width - offset, this.height - offset);
            g2d.drawLine(this.width - offset, y + offset, x + offset, this.height - offset);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private class HeaderPanel
    extends JPanel {
        private final JLabel label;

        public HeaderPanel(final MoeEditor editor) {
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.label = new JLabel(editor.getTitle());
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.label.setOpaque(false);
            this.add(this.label);
            CloseIcon closeIcon = new CloseIcon();
            JButton close = new JButton(closeIcon);
            close.setBorder(null);
            close.setBorderPainted(false);
            close.setOpaque(false);
            close.setContentAreaFilled(false);
            close.addActionListener(e -> SwingTabbedEditor.this.setEditorVisible(false, editor));
            this.add(close);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        SwingTabbedEditor.this.setEditorVisible(false, editor);
                    } else {
                        SwingTabbedEditor.this.setEditorVisible(true, editor);
                    }
                }
            });
            close.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SwingTabbedEditor.this.setEditorVisible(false, editor);
                }
            });
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }
    }
}

