/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.ClassPresenterPanel;
import org.netbeans.modules.profiler.heapwalk.FieldsBrowserController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesListController;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.ReferencesBrowserController;
import org.netbeans.modules.profiler.heapwalk.ui.InstancesControllerUI;

public class InstancesController
extends AbstractTopLevelController
implements FieldsBrowserController.Handler,
ReferencesBrowserController.Handler,
NavigationHistoryManager.NavigationHistoryCapable {
    private ClassPresenterPanel classPresenter;
    private FieldsBrowserController fieldsBrowserController;
    private HeapFragmentWalker heapFragmentWalker;
    private InstancesListController instancesListController;
    private JavaClass selectedClass;
    private ReferencesBrowserController referencesBrowserController;

    public InstancesController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        this.classPresenter = new ClassPresenterPanel(){

            @Override
            public void refresh() {
                this.setJavaClass(InstancesController.this.selectedClass);
            }
        };
        this.instancesListController = new InstancesListController(this);
        this.fieldsBrowserController = new FieldsBrowserController(this, 0);
        this.referencesBrowserController = new ReferencesBrowserController(this);
        this.classPresenter.setHeapFragmentWalker(heapFragmentWalker);
    }

    public void setClass(JavaClass javaClass) {
        if (javaClass == this.selectedClass) {
            return;
        }
        this.selectedClass = javaClass;
        ((InstancesControllerUI)this.getPanel()).update();
        this.updateClientPresentersEnabling(this.getClientPresenters());
        this.classPresenter.setJavaClass(javaClass);
        if (!this.instancesListController.getPanel().isVisible()) {
            this.instancesListController.getPanel().setVisible(true);
        }
        this.instancesListController.scheduleFirstInstanceSelection();
        this.instancesListController.setClass(javaClass);
    }

    public ClassPresenterPanel getClassPresenterPanel() {
        return this.classPresenter;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        long l = -1L;
        List list = null;
        TreePath treePath = null;
        List list2 = null;
        TreePath treePath2 = null;
        Instance instance = this.getSelectedInstance();
        if (instance != null) {
            l = instance.getInstanceId();
            list = this.fieldsBrowserController.getExpandedPaths();
            treePath = this.fieldsBrowserController.getSelectedRow();
            list2 = this.referencesBrowserController.getExpandedPaths();
            treePath2 = this.referencesBrowserController.getSelectedRow();
        }
        return new Configuration(l, list, treePath, list2, treePath2);
    }

    public FieldsBrowserController getFieldsBrowserController() {
        return this.fieldsBrowserController;
    }

    @Override
    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public InstancesListController getInstancesListController() {
        return this.instancesListController;
    }

    public ReferencesBrowserController getReferencesBrowserController() {
        return this.referencesBrowserController;
    }

    public JavaClass getSelectedClass() {
        return this.selectedClass;
    }

    public Instance getSelectedInstance() {
        return this.instancesListController.getSelectedInstance();
    }

    @Override
    public void configure(NavigationHistoryManager.Configuration configuration) {
        if (configuration instanceof Configuration) {
            Configuration configuration2 = (Configuration)configuration;
            Instance instance = null;
            long l = configuration2.getInstanceID();
            if (l != -1L) {
                instance = this.heapFragmentWalker.getHeapFragment().getInstanceByID(l);
            }
            if (instance != null) {
                JavaClass javaClass;
                this.selectedClass = javaClass = instance.getJavaClass();
                ((InstancesControllerUI)this.getPanel()).update();
                this.updateClientPresentersEnabling(this.getClientPresenters());
                this.heapFragmentWalker.switchToHistoryInstancesView();
                this.classPresenter.setJavaClass(javaClass);
                this.fieldsBrowserController.restoreState(configuration2.getExpandedFields(), configuration2.getSelectedField());
                this.referencesBrowserController.restoreState(configuration2.getExpandedReferences(), configuration2.getSelectedReference());
                this.instancesListController.showInstance(instance);
            } else {
                this.heapFragmentWalker.switchToHistoryInstancesView();
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration: " + configuration);
        }
    }

    public void instanceSelected() {
        Instance instance = this.getSelectedInstance();
        this.fieldsBrowserController.setInstance(instance);
        this.referencesBrowserController.setInstance(instance);
    }

    @Override
    public void showClass(JavaClass javaClass) {
        this.heapFragmentWalker.getClassesController().showClass(javaClass);
    }

    @Override
    public void showInstance(Instance instance) {
        JavaClass javaClass;
        this.selectedClass = javaClass = instance.getJavaClass();
        ((InstancesControllerUI)this.getPanel()).update();
        this.updateClientPresentersEnabling(this.getClientPresenters());
        this.heapFragmentWalker.switchToInstancesView();
        this.classPresenter.setJavaClass(javaClass);
        this.instancesListController.showInstance(instance);
    }

    @Override
    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[]{this.instancesListController.getPresenter(), this.fieldsBrowserController.getPresenter(), this.referencesBrowserController.getPresenter()};
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((InstancesControllerUI)this.getPanel()).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new InstancesControllerUI(this);
    }

    @Override
    protected void updateClientPresentersEnabling(AbstractButton[] abstractButtonArray) {
        if (this.selectedClass == null) {
            for (int i = 0; i < abstractButtonArray.length; ++i) {
                abstractButtonArray[i].setVisible(false);
            }
        } else {
            for (int i = 0; i < abstractButtonArray.length; ++i) {
                abstractButtonArray[i].setVisible(true);
            }
            super.updateClientPresentersEnabling(abstractButtonArray);
        }
    }

    public static class Configuration
    extends NavigationHistoryManager.Configuration {
        private final long instanceID;
        private final List expandedFields;
        private final TreePath selectedField;
        private final List expandedReferences;
        private final TreePath selectedReference;

        public Configuration(long l, List list, TreePath treePath, List list2, TreePath treePath2) {
            this.instanceID = l;
            this.expandedFields = list;
            this.selectedField = treePath;
            this.expandedReferences = list2;
            this.selectedReference = treePath2;
        }

        public long getInstanceID() {
            return this.instanceID;
        }

        public List getExpandedFields() {
            return this.expandedFields;
        }

        public TreePath getSelectedField() {
            return this.selectedField;
        }

        public List getExpandedReferences() {
            return this.expandedReferences;
        }

        public TreePath getSelectedReference() {
            return this.selectedReference;
        }
    }
}

