/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.provider.Producer;
import com.jrockit.mc.flightrecorder.provider.TrackGroup;
import com.jrockit.mc.flightrecorder.provider.View;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.IRepository;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.ITrackGroup;
import com.jrockit.mc.flightrecorder.spi.IView;
import java.util.ArrayList;
import java.util.Collection;

public final class Repository
implements IRepository {
    private final TrackGroup root;
    private final Collection<ITrack> allTracks;
    private final Collection<IEventType> allEventTypes;
    private final Collection<EventStorage> allEventStorages;
    private final Collection<Producer> allProducers;
    private final ITimeRange range;

    public Repository(Collection<Producer> producers, Collection<EventStorage> eventStorages, TrackGroup rootTrackGroup, ITimeRange range) {
        this.root = rootTrackGroup;
        this.allEventStorages = eventStorages;
        this.range = range;
        this.allTracks = rootTrackGroup.getAllTracks();
        this.allEventTypes = new ArrayList<IEventType>();
        for (Producer p : producers) {
            this.allEventTypes.addAll(p.getEventTypes());
        }
        this.allProducers = producers;
    }

    public Collection<IEventType> getEventTypes() {
        return this.allEventTypes;
    }

    public Collection<ITrack> getTracks() {
        return this.allTracks;
    }

    @Override
    public Collection<? extends IProducer> getProducers() {
        return this.allProducers;
    }

    @Override
    public ITimeRange getTimeRange() {
        return this.range;
    }

    @Override
    public IView createView() {
        return new View(this, this.allEventStorages);
    }

    @Override
    public ITrackGroup getRootGroup() {
        return this.root;
    }
}

