/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ITypedParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import java.io.UnsupportedEncodingException;

final class UTFStringParser
implements IParser,
ITypedParser<String> {
    private static final String CHARSET = "UTF-8";
    public static final UTFStringParser INSTANCE = new UTFStringParser();

    UTFStringParser() {
    }

    @Override
    public String read(byte[] bytes, Offset offset) throws InvalidFlrFileException {
        int len = UTFStringParser.readUnsignedShort(bytes, offset.get());
        offset.increase(2);
        int index = offset.get();
        offset.increase(len);
        try {
            return new String(bytes, index, len, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int readUnsignedShort(byte[] bytes, int offset) {
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        return (ch1 << 8) + (ch2 << 0);
    }

    public String[] createArray(int length) {
        return new String[length];
    }
}

