/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx.binding;

import bluej.utility.javafx.binding.DeepListBinding;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;

public class ConcatMapListBinding<DEST, SRC>
extends DeepListBinding<DEST> {
    private final ObservableList<SRC> src;
    private final Function<SRC, ObservableList<? extends DEST>> via;

    public static <DEST, SRC> void bind(ObservableList<DEST> dest, ObservableList<SRC> src, Function<SRC, ObservableList<? extends DEST>> via) {
        new ConcatMapListBinding<DEST, SRC>(dest, src, via).startListening();
    }

    private ConcatMapListBinding(ObservableList<DEST> dest, ObservableList<SRC> src, Function<SRC, ObservableList<? extends DEST>> via) {
        super(dest);
        this.src = src;
        this.via = via;
    }

    @Override
    protected Stream<ObservableList<?>> getListenTargets() {
        return Stream.concat(Stream.of(this.src), this.src.stream().map(this.via));
    }

    @Override
    protected Stream<DEST> calculateValues() {
        return this.src.stream().map(this.via).flatMap(Collection::stream);
    }
}

