/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.Config;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.WindowOverlayPane;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXCache;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.FXSupplier;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JavaFXUtil {
    private static final FXCache<Font, FXCache<String, Double>> measured = new FXCache<Font, FXCache>(f -> new FXCache<String, Double>(s -> JavaFXUtil.measureString(f, s), 1000), 3);

    public static void setPseudoclass(String name, boolean on, Node ... nodes) {
        if (!name.startsWith("bj-")) {
            throw new IllegalArgumentException("Our pseudoclasses should begin with bj- to avoid confusion with JavaFX's pseudo classes");
        }
        for (Node node : nodes) {
            node.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)name), on);
        }
    }

    public static boolean hasPseudoclass(Node node, String s) {
        return node.getPseudoClassStates().stream().filter(p -> p.getPseudoClassName().equals(s)).count() > 0L;
    }

    public static void setStyleClass(Styleable n, boolean on, String ... styleClasses) {
        if (on) {
            JavaFXUtil.addStyleClass(n, styleClasses);
        } else {
            JavaFXUtil.removeStyleClass(n, styleClasses);
        }
    }

    public static void selectStyleClass(String chosen, Styleable n, String ... all) {
        n.getStyleClass().removeAll((Object[])all);
        if (chosen != null) {
            n.getStyleClass().add((Object)chosen);
        }
    }

    public static void selectStyleClass(int index, Styleable n, String ... all) {
        JavaFXUtil.selectStyleClass(index == -1 ? null : all[index], n, all);
    }

    public static void selectPseudoClass(Node node, int index, String ... pseudoClasses) {
        for (int i = 0; i < pseudoClasses.length; ++i) {
            JavaFXUtil.setPseudoclass(pseudoClasses[i], i == index, node);
        }
    }

    public static void addStyleClass(Styleable n, String ... styleClasses) {
        for (String styleClass : styleClasses) {
            if (n.getStyleClass().contains((Object)styleClass)) continue;
            n.getStyleClass().add((Object)styleClass);
        }
    }

    public static void removeStyleClass(Styleable n, String ... styleClasses) {
        n.getStyleClass().removeAll((Object[])styleClasses);
    }

    public static <T> ObservableValue<T> conditional(ObservableBooleanValue prop, T ifTrue, T ifFalse) {
        return new When(prop).then(ifTrue).otherwise(ifFalse);
    }

    public static double measureString(TextInputControl node, String str) {
        return JavaFXUtil.measureString(node, str, true, true);
    }

    public static double measureString(TextInputControl node, String str, boolean includeLeftInset, boolean includeRightInset) {
        return JavaFXUtil.measureString(node, str, node.getFont(), includeLeftInset, includeRightInset);
    }

    public static double measureString(TextInputControl node, String str, Font overrideFont, boolean includeLeftInset, boolean includeRightInset) {
        return measured.get(overrideFont).get(str) + (includeLeftInset ? node.getInsets().getLeft() : 0.0) + (includeRightInset ? node.getInsets().getRight() : 0.0);
    }

    private static double measureString(Font f, String str) {
        if (str == null || str.length() == 0) {
            return 0.0;
        }
        Text text = new Text(str);
        text.setFont(f);
        return text.getLayoutBounds().getWidth();
    }

    public static double measureString(Labeled node, String str) {
        return JavaFXUtil.measureString(node, str, node.getFont());
    }

    public static double measureString(Labeled node, String str, Font overrideFont) {
        return measured.get(overrideFont).get(str) + node.getLabelPadding().getLeft() + node.getLabelPadding().getRight() + node.getPadding().getLeft() + node.getPadding().getRight();
    }

    public static double measureStringHeight(Labeled node, String str) {
        Text text = new Text(str);
        text.setFont(node.getFont());
        return text.getLayoutBounds().getHeight();
    }

    public static void toggleStyleClass(Boolean on, Styleable n, String styleClass) {
        if (on.booleanValue()) {
            JavaFXUtil.addStyleClass(n, styleClass);
        } else {
            JavaFXUtil.removeStyleClass(n, styleClass);
        }
    }

    public static <T extends Styleable> CssMetaData<T, Number> cssSize(String propertyName, final Function<T, SimpleStyleableDoubleProperty> propGetter) {
        return new CssMetaData<T, Number>(propertyName, StyleConverter.getSizeConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Color> cssColor(String propertyName, final Function<T, SimpleStyleableObjectProperty<Color>> propGetter) {
        return new CssMetaData<T, Color>(propertyName, StyleConverter.getColorConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Color> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Insets> cssInsets(String propertyName, final Function<T, StyleableObjectProperty<Insets>> propGetter) {
        return new CssMetaData<T, Insets>(propertyName, StyleConverter.getInsetsConverter(), Insets.EMPTY){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Insets> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static void writeImageTo(WritableImage image, String filename) {
        File file = new File(filename);
        BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)image, null);
        try {
            ImageIO.write((RenderedImage)renderedImage, "png", file);
        }
        catch (IOException e) {
            Debug.reportError(e);
        }
    }

    public static void workAroundFunctionKeyBug(TextField field) {
        field.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            switch (e.getCode()) {
                case F1: 
                case F2: 
                case F3: 
                case F4: 
                case F5: 
                case F6: 
                case F7: 
                case F8: 
                case F9: 
                case F10: 
                case F11: 
                case F12: {
                    Runnable r = (Runnable)field.getScene().getAccelerators().get((Object)new KeyCodeCombination(e.getCode(), new KeyCombination.Modifier[0]));
                    if (r == null) break;
                    r.run();
                    e.consume();
                    break;
                }
            }
        });
    }

    public static ListBuilder<CssMetaData<? extends Styleable, ?>> extendCss(List<CssMetaData<? extends Styleable, ?>> superClassCssMetaData) {
        return new ListBuilder(superClassCssMetaData);
    }

    private static FXRunnable bindSet(Node n, DoubleExpression value, BiConsumer<Node, Double> set) {
        set.accept(n, Math.ceil(value.get()));
        ChangeListener listener = (a, b, newVal) -> set.accept(n, Math.ceil(newVal.doubleValue()));
        value.addListener(listener);
        return () -> value.removeListener(listener);
    }

    public static FXRunnable bindLeftAnchor(Node n, DoubleExpression value) {
        return JavaFXUtil.bindSet(n, value, AnchorPane::setLeftAnchor);
    }

    public static FXRunnable bindRightAnchor(Node n, DoubleExpression value) {
        return JavaFXUtil.bindSet(n, value, AnchorPane::setRightAnchor);
    }

    public static FXRunnable bindTopAnchor(Node n, DoubleExpression value) {
        return JavaFXUtil.bindSet(n, value, AnchorPane::setTopAnchor);
    }

    public static FXRunnable bindBottomAnchor(Node n, DoubleExpression value) {
        return JavaFXUtil.bindSet(n, value, AnchorPane::setBottomAnchor);
    }

    public static void listenForContextMenu(Node node, BiFunction<Double, Double, Boolean> showContextMenu) {
        EventHandler popupHandler = e -> {
            if (e.isPopupTrigger() && ((Boolean)showContextMenu.apply(e.getScreenX(), e.getScreenY())).booleanValue()) {
                e.consume();
            }
        };
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, popupHandler);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, popupHandler);
        node.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            Scene scene;
            Point2D scenePt;
            Point2D screenPt;
            if (e.getCode() == KeyCode.CONTEXT_MENU && ((Boolean)showContextMenu.apply((screenPt = (scenePt = node.localToScene(5.0, 5.0)).add((scene = node.getScene()).getWindow().getX() + scene.getX(), scene.getWindow().getY() + scene.getY())).getX(), screenPt.getY())).booleanValue()) {
                e.consume();
            }
        });
    }

    public static OkCancel makeOkCancel(EventHandler<ActionEvent> onOk, EventHandler<ActionEvent> onCancel) {
        final Button ok = new Button("Ok");
        ok.setOnAction(onOk);
        final Button cancel = new Button("Cancel");
        cancel.setOnAction(onCancel);
        final HBox hbox = new HBox(new Node[]{cancel, new Rectangle(50.0, 1.0, (Paint)Color.TRANSPARENT), ok});
        return new OkCancel(){
            private final BooleanProperty okEnabled = new SimpleBooleanProperty(true);
            {
                ok.disableProperty().bind((ObservableValue)this.okEnabled.not());
            }

            @Override
            public Node getNode() {
                return hbox;
            }

            @Override
            public void requestOkFocus() {
                ok.requestFocus();
            }

            @Override
            public void requestCancelFocus() {
                cancel.requestFocus();
            }

            @Override
            public WritableBooleanValue okEnabledProperty() {
                return this.okEnabled;
            }
        };
    }

    public static MenuItem makeMenuItem(String text, FXRunnable run, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        if (run != null) {
            item.setOnAction(e -> run.run());
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static MenuItem makeDisabledMenuItem(String text, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        item.setDisable(true);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static CheckMenuItem makeCheckMenuItem(String text, Consumer<Boolean> handler, KeyCombination shortcut) {
        CheckMenuItem item = new CheckMenuItem(text);
        item.selectedProperty().addListener((a, b, newVal) -> handler.accept(Boolean.valueOf(newVal)));
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static CheckMenuItem makeCheckMenuItem(String text, Property<Boolean> state, KeyCombination shortcut) {
        CheckMenuItem item = new CheckMenuItem(text);
        item.selectedProperty().bindBidirectional(state);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static CheckMenuItem makeCheckMenuItem(String text, Property<Boolean> state, ObservableValue<? extends KeyCombination> shortcut) {
        CheckMenuItem item = new CheckMenuItem(text);
        item.selectedProperty().bindBidirectional(state);
        if (shortcut != null) {
            item.acceleratorProperty().bind(shortcut);
        }
        return item;
    }

    public static Menu makeMenu(String text, MenuItem ... items) {
        Menu menu = new Menu(text);
        menu.getItems().setAll((Object[])items);
        return menu;
    }

    public static void initializeCustomTooltip(InteractionManager editor, Node parent, String tooltipText, long delayMillis) {
        JavaFXUtil.initializeCustomTooltip(editor, parent, (StringExpression)new ReadOnlyStringWrapper(tooltipText), delayMillis);
    }

    public static void initializeCustomTooltip(final InteractionManager editor, final Node parent, final StringExpression tooltipText, final long delayMillis) {
        parent.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){
            final Label l = new Label();
            private Runnable focusRunnable;
            {
                this.l.textProperty().bind((ObservableValue)tooltipText);
                this.l.visibleProperty().bind((ObservableValue)this.l.textProperty().isNotEmpty());
                this.l.setMouseTransparent(true);
                this.l.setWrapText(true);
                JavaFXUtil.addStyleClass((Styleable)this.l, "frame-tooltip");
            }

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean newVal) {
                5 syncOn = this;
                if (newVal.booleanValue()) {
                    Runnable r;
                    this.focusRunnable = r = new Runnable(){

                        @Override
                        @OnThread(value=Tag.FX, ignoreParent=true)
                        public void run() {
                            if (focusRunnable == this) {
                                editor.getCodeOverlayPane().addOverlay((Node)l, parent, null, (DoubleExpression)l.heightProperty().negate(), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
                                FadeTransition ft = new FadeTransition(Duration.millis((double)100.0), (Node)l);
                                ft.setFromValue(0.0);
                                ft.setToValue(1.0);
                                ft.play();
                            }
                        }
                    };
                    Utility.getBackground().schedule(() -> Platform.runLater((Runnable)r), delayMillis, TimeUnit.MILLISECONDS);
                } else {
                    this.focusRunnable = null;
                    editor.getCodeOverlayPane().removeOverlay((Node)this.l);
                }
            }
        });
    }

    public static void initializeCustomTooltipCatalogue(final FXTabbedEditor window, Node target, String tooltipText, final Duration delay) {
        final Label l = new Label(tooltipText);
        l.visibleProperty().bind((ObservableValue)l.textProperty().isNotEmpty());
        l.setMouseTransparent(true);
        l.setWrapText(true);
        JavaFXUtil.addStyleClass((Styleable)l, "frame-tooltip");
        JavaFXUtil.setPseudoclass("bj-tight-border", true, new Node[]{l});
        l.setMaxWidth(300.0);
        final FXRunnable show = () -> {
            WindowOverlayPane overlayPane = window.getOverlayPane();
            double x = overlayPane.sceneXToWindowOverlayX(target.localToScene(target.getBoundsInLocal()).getMinX());
            double y = overlayPane.sceneYToWindowOverlayY(target.localToScene(target.getBoundsInLocal()).getMaxY() + 10.0);
            overlayPane.addOverlay((Node)l, (ObservableDoubleValue)new ReadOnlyDoubleWrapper(x), (ObservableDoubleValue)new ReadOnlyDoubleWrapper(y), true);
            FadeTransition ft = new FadeTransition(Duration.millis((double)100.0), (Node)l);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            ft.play();
        };
        target.addEventFilter(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(){
            FXRunnable cancel;

            public void handle(MouseEvent event) {
                if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    this.cancel = JavaFXUtil.runAfter(delay, show);
                } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                    if (this.cancel != null) {
                        this.cancel.run();
                        this.cancel = null;
                    }
                    window.getOverlayPane().removeOverlay((Node)l);
                }
            }
        });
    }

    public static void initializeCustomHelp(InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip, boolean onHoverToo) {
        Label l = new Label();
        l.visibleProperty().bind((ObservableValue)l.textProperty().isNotEmpty());
        l.setMouseTransparent(true);
        l.setWrapText(true);
        JavaFXUtil.addStyleClass((Styleable)l, "frame-tooltip");
        TooltipListener listener = new TooltipListener(l, editor, parent, requestTooltip);
        parent.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)listener);
        parent.focusedProperty().addListener((ChangeListener)listener);
        if (onHoverToo) {
            parent.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)listener);
            parent.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)listener);
        }
    }

    public static <T6> void onceNotNull(final ObservableValue<T6> value, final FXConsumer<T6> f) {
        Object t = value.getValue();
        if (t != null) {
            f.accept(t);
            return;
        }
        ChangeListener listener = new ChangeListener<T6>(){

            public void changed(ObservableValue<? extends T6> observable, T6 oldValue, T6 newVal) {
                if (newVal != null) {
                    f.accept(newVal);
                    value.removeListener((ChangeListener)this);
                }
            }
        };
        value.addListener(listener);
    }

    public static <SRC2, DEST2> void bindMap(final List<DEST2> dest, final ObservableList<SRC2> src, final Function<SRC2, DEST2> func) {
        dest.clear();
        dest.addAll(Utility.mapList(src, func));
        src.addListener(new ListChangeListener<SRC2>(){

            public void onChanged(ListChangeListener.Change<? extends SRC2> changes) {
                while (changes.next()) {
                    int i;
                    if (changes.wasPermutated() || changes.wasUpdated()) {
                        for (i = changes.getFrom(); i < changes.getTo(); ++i) {
                            dest.set(i, func.apply(src.get(i)));
                        }
                        continue;
                    }
                    for (i = 0; i < changes.getRemovedSize(); ++i) {
                        dest.remove(changes.getFrom());
                    }
                    for (i = 0; i < changes.getAddedSubList().size(); ++i) {
                        dest.add(i + changes.getFrom(), func.apply(changes.getAddedSubList().get(i)));
                    }
                }
            }
        });
    }

    public static <SRC, DEST> ObservableList<DEST> mapObservableList(ObservableList<SRC> src, Function<SRC, DEST> func) {
        ObservableList r = FXCollections.observableArrayList();
        JavaFXUtil.bindMap(r, src, func);
        return r;
    }

    @OnThread(value=Tag.Any)
    public static <T> CompletableFuture<T> future(FXSupplier<T> r) {
        CompletableFuture f = new CompletableFuture();
        Platform.runLater(() -> f.complete(r.get()));
        return f;
    }

    public static <T> void bindFuture(Future<T> future, FXConsumer<T> andThen) {
        new Thread(() -> {
            try {
                Object x = future.get();
                Platform.runLater(() -> andThen.accept(x));
            }
            catch (InterruptedException | ExecutionException e) {
                Debug.reportError(e);
            }
        }).start();
    }

    public static <T> void bindAtomic(ObservableValue<T> from, AtomicReference<T> to) {
        from.addListener((a, b, newVal) -> to.set(newVal));
    }

    public static <T> ObservableList<T> listBool(BooleanExpression putInList, T ... items) {
        ObservableList r = FXCollections.observableArrayList();
        if (putInList.get()) {
            r.setAll((Object[])items);
        }
        putInList.addListener((a, b, newVal) -> {
            if (newVal.booleanValue()) {
                r.setAll(items);
            } else {
                r.clear();
            }
        });
        return r;
    }

    public static <T> FXRunnable addSelfRemovingListener(final ObservableValue<T> prop, final FXConsumer<T> callback) {
        ChangeListener l = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                callback.accept(newValue);
                prop.removeListener((ChangeListener)this);
            }
        };
        prop.addListener(l);
        return () -> JavaFXUtil.lambda$addSelfRemovingListener$952(prop, (ChangeListener)l);
    }

    public static <T> FXRunnable bindList(ObservableList<T> dest, ObservableList<T> src) {
        ListChangeListener obs = c -> dest.setAll((Collection)src);
        src.addListener(obs);
        dest.setAll(src);
        return () -> src.removeListener(obs);
    }

    public static <T> FXRunnable addChangeListener(ObservableValue<T> property, FXConsumer<T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> listener.accept(newVal);
        property.addListener(wrapped);
        return () -> property.removeListener(wrapped);
    }

    public static FXRunnable sequence(FXRunnable ... actions) {
        return () -> Arrays.stream(actions).forEach(FXRunnable::run);
    }

    public static FXRunnable runAfter(Duration delay, FXRunnable task) {
        if (delay.lessThanOrEqualTo(Duration.ZERO)) {
            task.run();
            return () -> {};
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(delay, arg_0 -> JavaFXUtil.lambda$runAfter$959((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(1);
        timeline.play();
        return () -> JavaFXUtil.lambda$runAfter$960((BooleanProperty)okToRun, timeline);
    }

    public static FXRunnable runRegular(Duration interval, FXRunnable task) {
        if (interval.lessThanOrEqualTo(Duration.ZERO)) {
            throw new IllegalArgumentException("Cannot run at a regular interval of zero or less");
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(interval, arg_0 -> JavaFXUtil.lambda$runRegular$961((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(false);
        timeline.play();
        return () -> JavaFXUtil.lambda$runRegular$962((BooleanProperty)okToRun, timeline);
    }

    public static boolean isDragCopyKeyPressed(KeyEvent event) {
        return Config.isMacOS() ? event.isAltDown() : event.isShortcutDown();
    }

    public static boolean isDragCopyKeyPressed(MouseEvent event) {
        return Config.isMacOS() ? event.isAltDown() : event.isShortcutDown();
    }

    private static /* synthetic */ void lambda$runRegular$962(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runRegular$961(BooleanProperty okToRun, FXRunnable task, ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$runAfter$960(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runAfter$959(BooleanProperty okToRun, FXRunnable task, ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$addSelfRemovingListener$952(ObservableValue prop, ChangeListener l) {
        prop.removeListener(l);
    }

    @OnThread(value=Tag.FX)
    private static class TooltipListener
    implements EventHandler<InputEvent>,
    ChangeListener<Boolean> {
        private final Label l;
        private final InteractionManager editor;
        private final Node parent;
        private final FXConsumer<FXConsumer<String>> requestTooltip;
        private FXRunnable cancelHoverShow = null;
        private boolean showing = false;
        private boolean mouseShown = false;

        private TooltipListener(Label l, InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip) {
            this.l = l;
            this.editor = editor;
            this.parent = parent;
            this.requestTooltip = requestTooltip;
        }

        public void handle(InputEvent original) {
            if (original instanceof KeyEvent) {
                KeyEvent event = (KeyEvent)original;
                if (event.getCode() == KeyCode.F1 && !this.showing) {
                    this.mouseShown = false;
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    this.show();
                    event.consume();
                }
                if (event.getCode() == KeyCode.ESCAPE && this.showing && !this.mouseShown) {
                    this.hide();
                }
            } else if (original instanceof MouseEvent) {
                MouseEvent event = (MouseEvent)original;
                if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (!this.showing) {
                        this.cancelHoverShow = JavaFXUtil.runAfter(Duration.millis((double)1000.0), () -> {
                            this.mouseShown = true;
                            this.show();
                        });
                    }
                } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (this.showing && this.mouseShown) {
                        this.hide();
                    }
                }
            }
        }

        private void show() {
            this.requestTooltip.accept(arg_0 -> ((Label)this.l).setText(arg_0));
            this.editor.getCodeOverlayPane().addOverlay((Node)this.l, this.parent, null, (DoubleExpression)this.l.heightProperty().negate().subtract(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.showing = true;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newVal) {
            if (!newVal.booleanValue() && this.showing && !this.mouseShown) {
                this.hide();
            }
        }

        private void hide() {
            if (this.showing) {
                this.editor.getCodeOverlayPane().removeOverlay((Node)this.l);
                this.showing = false;
            }
        }
    }

    public static interface OkCancel {
        public Node getNode();

        public void requestOkFocus();

        public void requestCancelFocus();

        public WritableBooleanValue okEnabledProperty();
    }

    public static class ListBuilder<T> {
        private ArrayList<T> list;

        private ListBuilder(List<T> list) {
            this.list = new ArrayList<T>(list);
        }

        public ListBuilder<T> add(T t) {
            this.list.add(t);
            return this;
        }

        public List<T> build() {
            return Collections.unmodifiableList(this.list);
        }
    }
}

