/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.slots.EditableSlot;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class ErrorUnderlineCanvas {
    private final Canvas canvas = new Canvas(){

        public boolean isResizable() {
            return true;
        }

        public void resize(double width, double height) {
            this.setWidth(width);
            this.setHeight(height);
        }

        public double minWidth(double height) {
            return 0.0;
        }

        public double minHeight(double width) {
            return 0.0;
        }

        public double prefWidth(double height) {
            return 0.0;
        }

        public double prefHeight(double width) {
            return 0.0;
        }

        public double maxWidth(double height) {
            return Double.MAX_VALUE;
        }

        public double maxHeight(double width) {
            return Double.MAX_VALUE;
        }
    };
    private final List<HyperlinkInfo> hyperlinks = new ArrayList<HyperlinkInfo>();
    private final List<ErrorInfo> errors = new ArrayList<ErrorInfo>();
    private final List<FXConsumer<GraphicsContext>> extraRedraw = new ArrayList<FXConsumer<GraphicsContext>>();
    private final List<PendingError> pending = new ArrayList<PendingError>();
    private FXRunnable hoverCancel;
    private FXConsumer<Boolean> currentHover;

    public ErrorUnderlineCanvas(Node mouseableContainer) {
        this.canvas.setMouseTransparent(true);
        mouseableContainer.addEventFilter(MouseEvent.MOUSE_MOVED, e -> {
            ErrorUnderlineCanvas errorUnderlineCanvas = this;
            synchronized (errorUnderlineCanvas) {
                if (this.hoverCancel != null) {
                    this.hoverCancel.run();
                }
                if (this.currentHover != null) {
                    this.currentHover.accept(false);
                    this.currentHover = null;
                }
                this.hoverCancel = JavaFXUtil.runAfter(Duration.millis((double)500.0), () -> this.hoverAt(e.getSceneX(), e.getSceneY()));
            }
        });
        mouseableContainer.addEventFilter(MouseEvent.MOUSE_EXITED, e -> {
            ErrorUnderlineCanvas errorUnderlineCanvas = this;
            synchronized (errorUnderlineCanvas) {
                if (this.hoverCancel != null) {
                    this.hoverCancel.run();
                    this.hoverCancel = null;
                }
            }
        });
    }

    public void redraw() {
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setLineWidth(0.75);
        gc.setStroke((Paint)Color.RED);
        gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        for (ErrorInfo error : this.errors) {
            for (TextOverlayPosition.Line line : error.positionInfo.getAllLines(error.start, error.end, error.javaPos)) {
                TextOverlayPosition startTOP = line.getStart();
                TextOverlayPosition endTOP = line.getEnd();
                Point2D start = this.canvas.sceneToLocal(startTOP.getSceneX(), startTOP.getSceneBaselineY());
                Point2D end = this.canvas.sceneToLocal(endTOP.getSceneX(), endTOP.getSceneBaselineY());
                double width = end.getX() - start.getX();
                width = Math.max(width, 15.0);
                int n = (int)(width / 2.0) + 1;
                double[] xPoints = new double[n + 1];
                double[] yPoints = new double[n + 1];
                for (int j = 0; j <= n; ++j) {
                    xPoints[j] = start.getX() + (double)(j * 2);
                    yPoints[j] = start.getY() + (double)(3 * (j % 2));
                }
                gc.strokePolyline(xPoints, yPoints, n + 1);
            }
        }
        gc.setLineWidth(0.75);
        gc.setStroke((Paint)Color.BLACK);
        for (HyperlinkInfo link : this.hyperlinks) {
            if (!link.showing) continue;
            TextOverlayPosition startTOP = link.positionInfo.getOverlayLocation(link.start, false);
            TextOverlayPosition endTOP = link.positionInfo.getOverlayLocation(link.end, false);
            Point2D start = this.canvas.sceneToLocal(startTOP.getSceneX(), startTOP.getSceneBaselineY());
            Point2D end = this.canvas.sceneToLocal(endTOP.getSceneX(), endTOP.getSceneBaselineY());
            gc.strokeLine(start.getX(), start.getY(), end.getX(), end.getY());
        }
        this.extraRedraw.forEach(c -> c.accept(gc));
    }

    public void clearErrorMarkers(EditableSlot origin) {
        int i = 0;
        while (i < this.errors.size()) {
            if (this.errors.get(i).positionInfo == origin) {
                this.errors.remove(i);
                continue;
            }
            ++i;
        }
        this.pending.forEach(PendingError::cancel);
        this.pending.clear();
        this.redraw();
    }

    public void addErrorMarker(EditableSlot origin, int start, int end, boolean javaPos, FXConsumer<Boolean> onHover, ObservableBooleanValue visible) {
        ErrorInfo err = new ErrorInfo(origin, start, end, javaPos, onHover);
        if (!visible.get()) {
            this.pending.add(new PendingError((ObservableValue<Boolean>)visible, err));
        } else {
            this.errors.add(err);
            this.redraw();
        }
    }

    public void clearUnderlines() {
        this.hyperlinks.clear();
        this.redraw();
    }

    public void addUnderline(UnderlineInfo info, int startPosition, int endPosition, FXRunnable onClick) {
        this.hyperlinks.add(new HyperlinkInfo(info, startPosition, endPosition, onClick));
        this.redraw();
    }

    public FXRunnable linkFromX(double sceneX) {
        for (HyperlinkInfo link : this.hyperlinks) {
            double startX = link.positionInfo.getOverlayLocation(link.start, false).getSceneX();
            double endX = link.positionInfo.getOverlayLocation(link.end, false).getSceneX();
            if (!(sceneX >= startX) || !(sceneX < endX)) continue;
            return link.onClick;
        }
        return null;
    }

    public FXRunnable hoverAtPos(int pos) {
        FXRunnable r = null;
        for (HyperlinkInfo link : this.hyperlinks) {
            link.showing = false;
            if (pos < link.start || pos > link.end || r != null) continue;
            r = link.onClick;
            link.showing = true;
        }
        Platform.runLater(this::redraw);
        return r;
    }

    public void addExtraRedraw(FXConsumer<GraphicsContext> redraw) {
        this.extraRedraw.add(redraw);
    }

    private synchronized void hoverAt(double sceneX, double sceneY) {
        for (ErrorInfo error : this.errors) {
            double left = error.positionInfo.getOverlayLocation(error.start, error.javaPos).getSceneX();
            double right = error.positionInfo.getOverlayLocation(error.end, error.javaPos).getSceneX();
            double top = error.positionInfo.getOverlayLocation(error.start, error.javaPos).getSceneTopY();
            double bottom = error.positionInfo.getOverlayLocation(error.end, error.javaPos).getSceneBottomY();
            if (!(top <= sceneY) || !(sceneY <= bottom) || !(left <= sceneX) || !(sceneX <= right)) continue;
            error.onHover.accept(true);
            this.currentHover = error.onHover;
        }
    }

    public Node getNode() {
        return this.canvas;
    }

    public Point2D localToScene(double x, double y) {
        return this.canvas.localToScene(x, y);
    }

    public Point2D sceneToLocal(double x, double y) {
        return this.canvas.sceneToLocal(x, y);
    }

    public Point2D sceneToLocal(Point2D p) {
        return this.canvas.sceneToLocal(p);
    }

    public double getHeight() {
        return this.canvas.getHeight();
    }

    private class PendingError
    implements ChangeListener<Boolean> {
        private final ObservableValue<Boolean> prop;
        private final ErrorInfo error;

        public PendingError(ObservableValue<Boolean> prop, ErrorInfo err) {
            this.prop = prop;
            this.error = err;
            prop.addListener((ChangeListener)this);
        }

        public void changed(ObservableValue<? extends Boolean> a, Boolean b, Boolean c) {
            ErrorUnderlineCanvas.this.errors.add(this.error);
            ErrorUnderlineCanvas.this.redraw();
            this.cancel();
        }

        public void cancel() {
            this.prop.removeListener((ChangeListener)this);
        }
    }

    public static interface UnderlineInfo {
        public TextOverlayPosition getOverlayLocation(int var1, boolean var2);

        default public List<TextOverlayPosition.Line> getAllLines(int start, int end, boolean javaPos) {
            return TextOverlayPosition.groupIntoLines(Arrays.asList(this.getOverlayLocation(start, javaPos), this.getOverlayLocation(end, javaPos)));
        }
    }

    private static class ErrorInfo {
        private final EditableSlot positionInfo;
        private final int start;
        private final int end;
        private final boolean javaPos;
        private final FXConsumer<Boolean> onHover;

        private ErrorInfo(EditableSlot slot, int start, int end, boolean javaPos, FXConsumer<Boolean> onHover) {
            this.positionInfo = slot;
            this.start = start;
            this.end = end;
            this.javaPos = javaPos;
            this.onHover = onHover;
        }
    }

    private static class HyperlinkInfo {
        private final UnderlineInfo positionInfo;
        private final int start;
        private final int end;
        private final FXRunnable onClick;
        private boolean showing = true;

        private HyperlinkInfo(UnderlineInfo positionInfo, int start, int end, FXRunnable onClick) {
            this.positionInfo = positionInfo;
            this.start = start;
            this.end = end;
            this.onClick = onClick;
        }
    }
}

