/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.stride.slots.CompletionCalculator;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightTextField;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class AnnotatableTextField {
    private final ScalableHeightTextField field;
    private final StackPane pane;
    private final ErrorUnderlineCanvas errorMarker;
    private final BooleanProperty fakeCaretShowing = new SimpleBooleanProperty(false);

    public AnnotatableTextField(String str, ErrorUnderlineCanvas overlay, boolean startHidden) {
        this.field = new ScalableHeightTextField(str, startHidden);
        this.field.focusedProperty().addListener((a, b, newVal) -> JavaFXUtil.setPseudoclass("bj-empty", newVal == false && this.field.getLength() == 0, new Node[]{this.field}));
        if (overlay != null) {
            this.errorMarker = overlay;
            this.pane = new StackPane(new Node[]{this.field});
        } else {
            this.pane = new StackPane();
            this.errorMarker = new ErrorUnderlineCanvas((Node)this.pane);
            this.pane.getChildren().addAll((Object[])new Node[]{this.field, this.errorMarker.getNode()});
        }
        this.field.setOnMouseMoved(e -> JavaFXUtil.setPseudoclass("bj-hyperlink", this.errorMarker.linkFromX(e.getSceneX()) != null, new Node[]{this.field}));
        this.field.setOnMouseClicked(e -> Utility.ifNotNull(this.errorMarker.linkFromX(e.getSceneX()), FXRunnable::runLater));
        this.errorMarker.addExtraRedraw(g -> {
            if (this.fakeCaretShowing.get()) {
                double x = this.errorMarker.sceneToLocal(this.field.localToScene(this.calculateCaretPosition(this.field.getCaretPosition()), 0.0)).getX();
                Paint p = g.getStroke();
                g.setStroke((Paint)Color.BLACK);
                g.strokeLine(x, 0.0, x, this.field.getHeight());
                g.setStroke(p);
            }
        });
        JavaFXUtil.addChangeListener(this.fakeCaretShowing, c -> this.errorMarker.redraw());
        JavaFXUtil.addChangeListener(this.field.caretPositionProperty(), p -> {
            if (this.fakeCaretShowing.get()) {
                this.errorMarker.redraw();
            }
        });
    }

    public AnnotatableTextField(ErrorUnderlineCanvas overlay) {
        this("", overlay);
    }

    public AnnotatableTextField(String str, ErrorUnderlineCanvas overlay) {
        this(str, overlay, false);
    }

    public Region getNode() {
        return this.pane;
    }

    public Node getFocusableNode() {
        return this.field;
    }

    public final StringProperty textProperty() {
        return this.field.textProperty();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.field.widthProperty();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.field.heightProperty();
    }

    public final ReadOnlyBooleanProperty focusedProperty() {
        return this.field.focusedProperty();
    }

    public void positionCaret(int pos) {
        this.field.positionCaret(pos);
    }

    public final StringProperty promptTextProperty() {
        return this.field.promptTextProperty();
    }

    public void replaceText(int start, int end, String text) {
        this.field.replaceText(start, end, text);
    }

    public final boolean isFocused() {
        return this.field.isFocused();
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    public final int getLength() {
        return this.field.getLength();
    }

    public final ReadOnlyIntegerProperty caretPositionProperty() {
        return this.field.caretPositionProperty();
    }

    public final DoubleProperty minWidthProperty() {
        return this.field.minWidthProperty();
    }

    public final ReadOnlyObjectProperty<IndexRange> selectionProperty() {
        return this.field.selectionProperty();
    }

    public final ReadOnlyIntegerProperty anchorProperty() {
        return this.field.anchorProperty();
    }

    public void end() {
        this.field.end();
    }

    public void deselect() {
        this.field.deselect();
    }

    public final DoubleProperty prefWidthProperty() {
        return this.field.prefWidthProperty();
    }

    public final ObjectProperty<Font> fontProperty() {
        return this.field.fontProperty();
    }

    public double measureString(String str) {
        return JavaFXUtil.measureString((TextInputControl)this.field, str);
    }

    public final IndexRange getSelection() {
        return this.field.getSelection();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        return this.field.onKeyPressedProperty();
    }

    public final BooleanProperty editableProperty() {
        return this.field.editableProperty();
    }

    public final BooleanProperty disableProperty() {
        return this.field.disableProperty();
    }

    public Timeline getGrowToFullHeightTimeline(Duration dur) {
        return this.field.getGrowToFullHeightTimeline(dur);
    }

    public Timeline getShrinkToNothingTimeline(Duration dur) {
        return this.field.getShrinkToNothingTimeline(dur);
    }

    public boolean executeCompletion(CompletionCalculator cc, int highlighted, int startOfCurWord) {
        return cc.execute(this.field, highlighted, startOfCurWord);
    }

    protected double calculateCaretPosition(int beforeIndex) {
        if (beforeIndex == Integer.MAX_VALUE) {
            return this.field.getWidth();
        }
        double paddingLeft = this.field.getPadding().getLeft();
        double borderLeft = 0.0;
        if (this.field.getBorder() != null && this.field.getBorder().getInsets() != null) {
            borderLeft = this.field.getBorder().getInsets().getLeft();
        }
        int index = Math.min(beforeIndex, this.field.getText().length());
        return paddingLeft + borderLeft + this.measureString(this.field.getText().substring(0, index));
    }

    protected double getBaseline() {
        double height = this.field.getHeight() - 3.0 - this.field.getPadding().getBottom();
        if (this.field.getBorder() != null && this.field.getBorder().getInsets() != null) {
            height -= this.field.getBorder().getInsets().getBottom();
        }
        return height;
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        return this.field.tooltipProperty();
    }

    public void clearUnderlines() {
        this.errorMarker.clearUnderlines();
        this.field.setCursor(null);
    }

    public void drawUnderline(ErrorUnderlineCanvas.UnderlineInfo s, int startPosition, int endPosition, FXRunnable onClick) {
        this.errorMarker.addUnderline(s, startPosition, endPosition, onClick);
    }

    protected void addStyleClasses(String ... styleClasses) {
        JavaFXUtil.addStyleClass((Styleable)this.field, styleClasses);
    }

    protected void setPseudoclass(String pseudoClass, boolean on) {
        JavaFXUtil.setPseudoclass(pseudoClass, on, new Node[]{this.field});
    }

    public void drawErrorMarker(EditableSlot s, int startPos, int endPos, boolean javaPos, FXConsumer<Boolean> onHover, ObservableBooleanValue visible) {
        if (startPos == 0 && endPos == 0 || this.getLength() == 0) {
            this.errorMarker.addErrorMarker(s, 0, Integer.MAX_VALUE, false, onHover, visible);
        } else {
            this.errorMarker.addErrorMarker(s, startPos, endPos, javaPos, onHover, visible);
        }
    }

    public void clearErrorMarkers(EditableSlot s) {
        this.errorMarker.clearErrorMarkers(s);
    }

    public void selectAll() {
        this.field.selectAll();
    }

    public void cut() {
        this.field.cut();
    }

    public void copy() {
        this.field.copy();
    }

    public void paste() {
        this.field.paste();
    }

    public void backspace() {
        this.field.deletePreviousChar();
    }

    public void setContextMenu(ContextMenu menu) {
        this.field.setContextMenu(menu);
    }

    public void injectEvent(KeyEvent e) {
        this.field.fireEvent((Event)e.copyFor(null, (EventTarget)this.field));
    }

    public void setFakeCaretShowing(boolean showing) {
        this.fakeCaretShowing.set(showing);
    }

    public Font getFont() {
        return this.field.getFont();
    }

    public double measureString(String text, Font font) {
        return JavaFXUtil.measureString((TextInputControl)this.field, text, font, true, true);
    }

    public boolean hasSelection() {
        return this.field.getAnchor() != this.field.getCaretPosition();
    }
}

