/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.terminal.TermTextArea;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class TerminalPrinter {
    private static final int tabSize = 8;
    private static final int PADDING = 5;

    public static boolean printTerminal(PrinterJob job, TermTextArea textArea, PageFormat pageFormat, Font font) {
        try {
            Book pages = TerminalPrinter.paginateText(textArea, pageFormat, font);
            job.setPageable(pages);
            job.print();
            return true;
        }
        catch (Exception e) {
            Debug.reportError("Exception thrown during printing: " + e);
            e.printStackTrace();
            return false;
        }
    }

    private static Book paginateText(TermTextArea textArea, PageFormat pageFormat, Font font) {
        LinkedList<String> text = new LinkedList<String>(Arrays.asList(textArea.getText().split("\r\n|\r|\n")));
        Book book = new Book();
        int height = (int)pageFormat.getImageableHeight();
        int linesPerPage = height / (font.getSize() + 2);
        TerminalPrinter.wrapLines(text, pageFormat, font);
        int numberOfPages = text.size() / linesPerPage + 1;
        ListIterator li = text.listIterator();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            ArrayList<String> pageText = new ArrayList<String>();
            for (int lineCount = 0; li.hasNext() && lineCount < linesPerPage; ++lineCount) {
                pageText.add((String)li.next());
            }
            book.append(new TerminalPage(pageText, font), pageFormat);
        }
        return book;
    }

    private static void wrapLines(List<String> text, PageFormat format, Font font) {
        StyleContext context = new StyleContext();
        FontMetrics fontMetrics = context.getFontMetrics(font);
        int maxWidth = (int)format.getImageableWidth() - 10;
        int fontWidth = fontMetrics.charWidth('m');
        int chars = maxWidth / fontWidth;
        ListIterator<String> li = text.listIterator();
        while (li.hasNext()) {
            String pl = li.next();
            String currentLine = Utility.convertTabsToSpaces(pl.toString(), 8);
            int currentLineLength = currentLine.length();
            int width = fontMetrics.stringWidth(currentLine);
            if (width <= maxWidth) continue;
            int[] tabSpaces = Utility.calculateTabSpaces(pl.toString(), 8);
            li.remove();
            int begin = 0;
            int end = 0;
            for (double iterations = (double)(currentLineLength / chars + 1); iterations > 0.0; iterations -= 1.0) {
                end = Utility.advanceChars(pl.toString(), tabSpaces, begin, chars);
                String newSubString = pl.substring(begin, end);
                if (newSubString.length() != 0) {
                    li.add(newSubString);
                }
                begin = Utility.advanceChars(pl.toString(), tabSpaces, begin, chars);
            }
        }
    }

    public static class TerminalPage
    implements Printable {
        private List<String> pageText;
        private Font font;

        public TerminalPage(List<String> pageText, Font font) {
            this.pageText = pageText;
            this.font = font;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            g.setFont(this.font);
            g.setColor(Color.black);
            int xPosition = (int)pageFormat.getImageableX();
            int yPosition = (int)pageFormat.getImageableY();
            int width = (int)pageFormat.getImageableWidth();
            int height = (int)pageFormat.getImageableHeight();
            StyleContext context = new StyleContext();
            FontMetrics fontMetrics = context.getFontMetrics(this.font);
            int textYPosition = yPosition;
            int textXPosition = xPosition + 5;
            g.drawRect(xPosition, textYPosition, width, height);
            ListIterator<String> li = this.pageText.listIterator();
            while (li.hasNext()) {
                int position = textYPosition + (this.font.getSize() + 2) * (li.nextIndex() + 1);
                String line = li.next();
                int x = textXPosition;
                if (line.length() == 0) {
                    char[] nonBlank = new char[]{' '};
                    Segment lineSeg = new Segment(nonBlank, 0, 1);
                    x = Utilities.drawTabbedText(lineSeg, x, position, g, null, 0);
                    continue;
                }
                Segment lineSeg = new Segment(line.toCharArray(), 0, line.length());
                TabExpander tab = Utility.makeTabExpander(line, 8, fontMetrics);
                x = Utilities.drawTabbedText(lineSeg, x, position, g, tab, 0);
            }
            return 0;
        }
    }
}

