/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.terminal.ExceptionSourceLocation;
import bluej.utility.JavaNames;
import bluej.utility.PersistentMarkDocument;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Swing, ignoreParent=true)
public class TerminalDocument
extends PersistentMarkDocument {
    private boolean highlightSourceLinks;
    private Project project;

    public TerminalDocument(Project project, boolean highlightSourceLinks) {
        this.project = project;
        this.highlightSourceLinks = highlightSourceLinks;
    }

    public void markLineAsMethodOutput(int line) {
        this.writeLock();
        Element el = this.root.getElement(line);
        MutableAttributeSet attr = (MutableAttributeSet)el.getAttributes();
        attr.addAttribute("method-record", true);
        this.writeUnlock();
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if (this.highlightSourceLinks) {
            this.scanForStackTrace();
        }
    }

    private void scanForStackTrace() {
        try {
            MutableAttributeSet attr;
            Element el;
            int elementIndex;
            String content = this.getText(0, this.getLength());
            Pattern p = Pattern.compile("at (\\S+)\\((\\S+)\\.java:(\\d+)\\)");
            Matcher m = p.matcher(content);
            while (m.find()) {
                elementIndex = this.getDefaultRootElement().getElementIndex(m.start());
                el = this.getDefaultRootElement().getElement(elementIndex);
                attr = (MutableAttributeSet)el.getAttributes();
                String fullyQualifiedMethodName = m.group(1);
                String javaFile = m.group(2);
                int lineNumber = Integer.parseInt(m.group(3));
                String fullyQualifiedClassName = JavaNames.getPrefix(fullyQualifiedMethodName);
                String packageName = JavaNames.getPrefix(fullyQualifiedClassName);
                Package pkg = this.project.getPackage(packageName);
                if (pkg != null && pkg.getAllClassnames().contains(javaFile)) {
                    attr.addAttribute("source-location", new ExceptionSourceLocation(m.start(1), m.end(), pkg, javaFile, lineNumber));
                    continue;
                }
                attr.addAttribute("foreign-stack-trace", true);
            }
            p = Pattern.compile("at \\S+\\(Native Method|Unknown Source\\)");
            m = p.matcher(content);
            while (m.find()) {
                elementIndex = this.getDefaultRootElement().getElementIndex(m.start());
                el = this.getDefaultRootElement().getElement(elementIndex);
                attr = (MutableAttributeSet)el.getAttributes();
                attr.addAttribute("foreign-stack-trace", true);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }
}

