/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.generic.Frame;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.HeaderItem;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.OverrunStyle;

public class WrappableSlotLabel
implements HeaderItem {
    private final ObservableList<String> styleClasses = FXCollections.observableArrayList((Object[])new String[]{"wrappable-slot-label"});
    private final ObservableList<Label> words = FXCollections.observableArrayList();
    private HangingFlowPane.FlowAlignment alignment;

    public WrappableSlotLabel(String fullText) {
        this.setText(fullText);
    }

    public void setText(String fullText) {
        this.words.clear();
        boolean first = true;
        for (String word : fullText.split(" ")) {
            if (word.equals("")) continue;
            Label l = new Label(word);
            l.setMinWidth(0.0);
            JavaFXUtil.bindList(l.getStyleClass(), this.styleClasses);
            JavaFXUtil.setPseudoclass("bj-first", first, new Node[]{l});
            first = false;
            this.words.add((Object)l);
        }
        this.setAlignment(this.alignment);
    }

    public void addStyleClass(String styleClass) {
        if (!this.styleClasses.contains((Object)styleClass)) {
            this.styleClasses.add((Object)styleClass);
        }
    }

    @Override
    public EditableSlot asEditable() {
        return null;
    }

    @Override
    public ObservableList<? extends Node> getComponents() {
        return this.words;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
    }

    public void shrinkHorizontally(SharedTransition animate) {
        for (Label l : this.words) {
            l.setTextOverrun(OverrunStyle.CLIP);
            double cur = l.getWidth();
            l.minWidthProperty().set(0.0);
            l.maxWidthProperty().unbind();
            l.maxWidthProperty().bind((ObservableValue)animate.getProgress().negate().add(1.0).multiply(cur));
        }
    }

    public void growHorizontally(SharedTransition animate) {
        for (Label l : this.words) {
            l.setMinWidth(-1.0);
            l.maxWidthProperty().unbind();
            l.maxWidthProperty().bind((ObservableValue)animate.getProgress().multiply(JavaFXUtil.measureString((Labeled)l, l.getText())));
            animate.addOnStopped(() -> {
                l.maxWidthProperty().unbind();
                l.maxWidthProperty().set(-1.0);
            });
        }
    }

    public void fadeOut(SharedTransition animate, boolean setInvisible) {
        for (Label l : this.words) {
            l.opacityProperty().bind((ObservableValue)animate.getOppositeProgress());
        }
        animate.addOnStopped(() -> {
            for (Label l : this.words) {
                l.opacityProperty().unbind();
                if (!setInvisible) continue;
                l.setVisible(false);
            }
        });
    }

    public void fadeIn(SharedTransition animate) {
        for (Label l : this.words) {
            l.setVisible(true);
            l.opacityProperty().bind((ObservableValue)animate.getProgress());
        }
        animate.addOnStopped(() -> {
            for (Label l : this.words) {
                l.opacityProperty().unbind();
            }
        });
    }

    public void setAlignment(HangingFlowPane.FlowAlignment alignment) {
        this.alignment = alignment;
        this.words.forEach(l -> HangingFlowPane.setAlignment((Node)l, alignment));
    }
}

