/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.slots.ExpressionCompletionCalculator;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.CompletionCalculator;
import bluej.stride.slots.SuggestionList;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.scene.control.TextField;

public class TypeCompletionCalculator
implements CompletionCalculator {
    private final InteractionManager editor;
    private final Class<?> superType;
    private final Set<InteractionManager.Kind> kinds = new HashSet<InteractionManager.Kind>();
    private List<AssistContentThreadSafe> acs;

    public TypeCompletionCalculator(InteractionManager editor) {
        this(editor, (Class)null);
    }

    public TypeCompletionCalculator(InteractionManager editor, Class<?> superType) {
        this.editor = editor;
        this.superType = superType;
        if (superType == null) {
            this.kinds.addAll(Arrays.asList(InteractionManager.Kind.values()));
        } else {
            this.kinds.addAll(Arrays.asList(InteractionManager.Kind.CLASS_FINAL, InteractionManager.Kind.INTERFACE, InteractionManager.Kind.CLASS_NON_FINAL));
        }
    }

    public TypeCompletionCalculator(InteractionManager editor, InteractionManager.Kind kind) {
        this.editor = editor;
        this.superType = null;
        this.kinds.add(kind);
    }

    @Override
    public void withCalculatedSuggestionList(JavaFragment.PosInSourceDoc pos, CodeElement codeEl, SuggestionList.SuggestionListListener listener, String targetType, FXConsumer<SuggestionList> handler) {
        this.editor.withTypes(this.superType, true, this.kinds, acs -> {
            this.acs = new ArrayList<AssistContentThreadSafe>((Collection<AssistContentThreadSafe>)acs);
            this.acs.removeIf(ac -> !ac.accessibleFromPackage(""));
            List<SuggestionList.SuggestionDetailsWithHTMLDoc> suggestions = Utility.mapList(this.acs, ac -> new SuggestionList.SuggestionDetailsWithHTMLDoc(ac.getName(), ExpressionCompletionCalculator.getRarity(ac), ac.getDocHTML()));
            SuggestionList suggestionDisplay = new SuggestionList(this.editor, suggestions, null, SuggestionList.SuggestionShown.COMMON, null, listener);
            handler.accept(suggestionDisplay);
        });
    }

    @Override
    public boolean execute(TextField field, int selected, int startOfCurWord) {
        if (selected == -1) {
            return false;
        }
        AssistContentThreadSafe a = this.acs.get(selected);
        field.setText(a.getName());
        return true;
    }
}

