/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.Config;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.Suggestion;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.BlendMode;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SuggestionList {
    private final SuggestionListListener listener;
    private static final int MAX_EDIT_DISTANCE = 1;
    private final SuggestionVBox listBox;
    private final ScrollPane pane;
    private final Stage window;
    private final List<SuggestionDetails> choices;
    private final List<Suggestion> doubleSuggestions = new ArrayList<Suggestion>();
    private final HashMap<Integer, EligibleDetail> eligible = new HashMap();
    private int highlighted = -1;
    private final Consumer<Integer> highlightListener;
    private final ScalableHeightLabel similarLabel;
    private final ScalableHeightLabel noneLabel;
    private final DoubleExpression typeWidth;
    private String lastPrefix;
    private boolean lastAllowSimilar;
    private boolean expectingToLoseFocus = false;
    private ObjectProperty<SuggestionShown> shownState = new SimpleObjectProperty((Object)SuggestionShown.COMMON);
    private FXRunnable cancelShowDocsTask;
    private Pane docPane;
    private boolean hiding = false;
    private final BooleanProperty moreLabelAtBottom = new SimpleBooleanProperty(true);

    public SuggestionList(InteractionManager editor, List<? extends SuggestionDetails> choices, String targetType, SuggestionShown startShown, Consumer<Integer> highlightListener, SuggestionListListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("SuggestionListListener cannot be null");
        }
        this.choices = new ArrayList<SuggestionDetails>(choices);
        this.shownState.set((Object)startShown);
        this.listener = listener;
        this.highlightListener = highlightListener;
        this.similarLabel = new ScalableHeightLabel("Related:", false);
        this.similarLabel.setMaxWidth(9999.0);
        this.noneLabel = new ScalableHeightLabel("No completions", false);
        this.noneLabel.setMaxWidth(9999.0);
        JavaFXUtil.addStyleClass((Styleable)this.similarLabel, "suggestion-similar-heading");
        JavaFXUtil.addStyleClass((Styleable)this.noneLabel, "suggestion-none");
        this.listBox = new SuggestionVBox();
        JavaFXUtil.addStyleClass((Styleable)this.listBox, "suggestion-list");
        this.typeWidth = choices.stream().allMatch(s -> s.type == null) ? new ReadOnlyDoubleWrapper(0.0) : this.listBox.cssTypeWidthProperty();
        this.listBox.setBackground(null);
        this.listBox.setFillWidth(true);
        this.pane = new ScrollPane((Node)this.listBox);
        this.pane.setFitToWidth(true);
        this.pane.setBackground(null);
        JavaFXUtil.addStyleClass((Styleable)this.pane, "suggestion-list-scroll-pane");
        this.pane.setStyle("-fx-font-size: " + (String)editor.getFontSizeCSS().get() + ";");
        this.pane.maxWidthProperty().bind((ObservableValue)this.listBox.cssMaxWidthProperty());
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, null, null)}));
        this.pane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.docPane = new Pane();
        this.docPane.setMinWidth(400.0);
        this.docPane.setMaxHeight(300.0);
        this.docPane.setBackground(null);
        this.docPane.setMouseTransparent(true);
        BorderPane listAndDocBorderPane = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)listAndDocBorderPane, "suggestion-top-level");
        AnchorPane listAndMoreAndTransPane = new AnchorPane();
        listAndMoreAndTransPane.setBackground(null);
        listAndMoreAndTransPane.setPickOnBounds(false);
        this.pane.setMaxHeight(300.0);
        listAndDocBorderPane.setCenter((Node)listAndMoreAndTransPane);
        listAndDocBorderPane.setRight((Node)this.docPane);
        listAndDocBorderPane.setMaxHeight(300.0);
        Label moreLabel = new Label("Showing common options. Press Ctrl+Space again to see all options");
        JavaFXUtil.addStyleClass((Styleable)moreLabel, "suggestion-more-label");
        listAndDocBorderPane.setBackground(null);
        listAndDocBorderPane.setPickOnBounds(false);
        AnchorPane moreLabelPane = new AnchorPane(new Node[]{moreLabel});
        moreLabel.setMaxWidth(300.0);
        AnchorPane.setLeftAnchor((Node)moreLabel, (Double)0.0);
        AnchorPane.setTopAnchor((Node)moreLabel, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)moreLabel, (Double)0.0);
        JavaFXUtil.addStyleClass((Styleable)moreLabelPane, "suggestion-more-label-pane");
        this.window = new Stage(StageStyle.TRANSPARENT);
        this.window.setResizable(false);
        BorderPane listAndMorePane = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)listAndMorePane, "suggestion-dialog-lhs");
        listAndMorePane.setCenter((Node)this.pane);
        if (this.shownState.get() == SuggestionShown.COMMON) {
            listAndMorePane.setBottom((Node)moreLabelPane);
        }
        listAndMoreAndTransPane.getChildren().add((Object)listAndMorePane);
        AnchorPane.setLeftAnchor((Node)listAndMorePane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)listAndMorePane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)listAndMorePane, (Double)0.0);
        JavaFXUtil.addChangeListener(this.moreLabelAtBottom, atBottom -> {
            if (atBottom.booleanValue()) {
                listAndMorePane.setTop(null);
                listAndMorePane.setBottom((Node)(this.shownState.get() == SuggestionShown.COMMON ? moreLabelPane : null));
                AnchorPane.setTopAnchor((Node)listAndMorePane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)listAndMorePane, null);
                BorderPane.setAlignment((Node)this.docPane, (Pos)Pos.TOP_LEFT);
            } else {
                listAndMorePane.setBottom(null);
                listAndMorePane.setTop((Node)(this.shownState.get() == SuggestionShown.COMMON ? moreLabelPane : null));
                AnchorPane.setTopAnchor((Node)listAndMorePane, null);
                AnchorPane.setBottomAnchor((Node)listAndMorePane, (Double)0.0);
                BorderPane.setAlignment((Node)this.docPane, (Pos)Pos.BOTTOM_LEFT);
            }
            JavaFXUtil.setPseudoclass("bj-at-top", atBottom == false, new Node[]{moreLabelPane});
        });
        JavaFXUtil.addChangeListener(this.shownState, s -> {
            if (s == SuggestionShown.RARE) {
                listAndMorePane.setTop(null);
                listAndMorePane.setBottom(null);
            }
        });
        Scene scene = new Scene((Parent)listAndDocBorderPane);
        this.window.setHeight(350.0);
        scene.setFill(null);
        Config.addEditorStylesheets(scene);
        this.window.setScene(scene);
        editor.setupSuggestionWindow(this.window);
        for (int j = 0; j <= 1; ++j) {
            for (int i = 0; i < choices.size(); ++i) {
                int index = i + j * choices.size();
                SuggestionDetails choice = choices.get(i);
                String display = choice.choice + (choice.suffix == null ? "" : choice.suffix);
                Suggestion sugg = new Suggestion(choice.choice, choice.suffix == null ? "" : choice.suffix, choice.type == null ? "" : choice.type, targetType != null && choice.type != null ? targetType.equals(choice.type) : false, this.typeWidth, j == 0);
                this.listBox.getChildren().add((Object)sugg.getNode());
                sugg.getNode().setOnMouseClicked(e -> {
                    this.highlighted = index;
                    listener.suggestionListChoiceClicked(this.getHighlighted());
                    this.expectingToLoseFocus = true;
                    this.hiding = true;
                    this.window.hide();
                    listener.hidden();
                });
                this.doubleSuggestions.add(sugg);
            }
            if (j == 0) {
                this.listBox.getChildren().add((Object)this.similarLabel);
                continue;
            }
            this.listBox.getChildren().add((Object)this.noneLabel);
        }
        JavaFXUtil.addChangeListener(this.window.focusedProperty(), focused -> {
            if (!focused.booleanValue()) {
                this.hideDocDisplay();
                this.hiding = true;
                Platform.runLater(() -> {
                    this.window.hide();
                    if (!this.expectingToLoseFocus) {
                        listener.suggestionListFocusStolen(this.getHighlighted());
                    }
                    listener.hidden();
                });
            }
        });
        this.pane.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.SPACE && e.isControlDown()) {
                e.consume();
                if (this.shownState.get() == SuggestionShown.COMMON) {
                    this.shownState.set((Object)SuggestionShown.RARE);
                    this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, false);
                    this.updateVisual(this.lastPrefix, false);
                }
            }
        });
        this.pane.addEventFilter(KeyEvent.KEY_TYPED, e -> {
            if (e.getCharacter().equals(" ") && e.isControlDown()) {
                if (this.shownState.get() == SuggestionShown.COMMON) {
                    this.shownState.set((Object)SuggestionShown.RARE);
                    this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, false);
                    this.updateVisual(this.lastPrefix, false);
                }
            } else if (!e.getCharacter().contains("\u0000") && listener.suggestionListKeyTyped((KeyEvent)e, this.getHighlighted()) == SuggestionListListener.Response.DISMISS) {
                this.expectingToLoseFocus = true;
                this.hiding = true;
                this.window.hide();
                listener.hidden();
            }
            e.consume();
        });
        this.pane.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            switch (e.getCode()) {
                case UP: {
                    this.up();
                    break;
                }
                case DOWN: {
                    this.down();
                    break;
                }
                case PAGE_UP: {
                    this.pageUp();
                    break;
                }
                case PAGE_DOWN: {
                    this.pageDown();
                    break;
                }
                case HOME: {
                    this.home();
                    break;
                }
                case END: {
                    this.end();
                    break;
                }
                default: {
                    int selected = this.getHighlighted();
                    if (selected == -1 && this.eligibleCount() == 1) {
                        selected = this.getFirstEligible();
                    }
                    if (listener.suggestionListKeyPressed((KeyEvent)e, selected) != SuggestionListListener.Response.DISMISS) break;
                    this.expectingToLoseFocus = true;
                    this.hiding = true;
                    this.window.hide();
                    listener.hidden();
                }
            }
            e.consume();
        });
    }

    public void show(Node reference, DoubleExpression xOffset, DoubleExpression yOffset) {
        if (this.eligibleCount() == 1) {
            boolean singleOptionAvailable = true;
            if (this.shownState.get() == SuggestionShown.COMMON) {
                this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, SuggestionShown.RARE, false);
                if (this.eligibleCount() != 1) {
                    this.calculateEligible(this.lastPrefix, this.lastAllowSimilar, SuggestionShown.COMMON, false);
                    singleOptionAvailable = false;
                }
            }
            if (singleOptionAvailable) {
                int choice = this.getFirstEligible();
                Platform.runLater(() -> {
                    this.listener.hidden();
                    this.listener.suggestionListChoiceClicked(choice);
                });
                return;
            }
        }
        this.window.getScene().getRoot().applyCss();
        double xPos = reference.localToScene(reference.getBoundsInLocal()).getMinX();
        Window refWindow = reference.getScene().getWindow();
        double screenMaxY = Screen.getScreensForRectangle((double)refWindow.getX(), (double)refWindow.getY(), (double)refWindow.getWidth(), (double)refWindow.getHeight()).stream().mapToDouble(s -> s.getVisualBounds().getMaxY()).min().orElse(999999.0);
        double windowX = refWindow.getX() + reference.getScene().getX() + xPos + xOffset.get() - this.typeWidth.get() - 1.0;
        double windowY = refWindow.getY() + reference.getScene().getY() + reference.localToScene(reference.getBoundsInLocal()).getMinY() + yOffset.get();
        if (screenMaxY < this.window.getHeight() + windowY) {
            windowY = refWindow.getY() + reference.getScene().getY() + reference.localToScene(reference.getBoundsInLocal()).getMinY() - 350.0;
            this.moreLabelAtBottom.set(false);
        } else {
            this.moreLabelAtBottom.set(true);
        }
        this.window.setX(windowX);
        this.window.setY(windowY);
        if (this.window.getOwner() == null) {
            this.window.initOwner(reference.getScene().getWindow());
        }
        this.window.show();
        this.pane.requestFocus();
    }

    private void up() {
        for (int candidate = this.highlighted - 1; candidate >= -1; --candidate) {
            if (candidate != -1 && !this.eligible.containsKey(candidate)) continue;
            this.setHighlighted(candidate, true);
            break;
        }
    }

    private void down() {
        for (int candidate = this.highlighted + 1; candidate < this.doubleSuggestions.size(); ++candidate) {
            if (!this.eligible.containsKey(candidate)) continue;
            this.setHighlighted(candidate, true);
            break;
        }
    }

    private void home() {
        this.setHighlighted(this.getFirstEligible(), true);
    }

    private void end() {
        this.setHighlighted(this.getLastEligible(), true);
    }

    private void pageUp() {
        double height = this.doubleSuggestions.get(this.getFirstEligible()).getNode().getHeight();
        int itemsPerWindow = (int)Math.floor(this.pane.getHeight() / height);
        for (int i = 0; i < itemsPerWindow; ++i) {
            this.up();
        }
        if (this.highlighted == -1) {
            this.home();
        }
    }

    private void pageDown() {
        double height = this.doubleSuggestions.get(this.getFirstEligible()).getNode().getHeight();
        int itemsPerWindow = (int)Math.floor(this.pane.getHeight() / height);
        for (int i = 0; i < itemsPerWindow; ++i) {
            this.down();
        }
    }

    protected void setHighlighted(int newHighlight, boolean scrollTo) {
        if (this.highlighted == newHighlight) {
            return;
        }
        if (this.highlighted != -1) {
            this.doubleSuggestions.get(this.highlighted).setHighlight(false);
        }
        this.highlighted = newHighlight;
        if (this.highlighted != -1) {
            this.doubleSuggestions.get(this.highlighted).setHighlight(true);
            if (scrollTo) {
                double before = 0.0;
                double after = 0.0;
                for (int n : this.eligible.keySet()) {
                    if (n < this.highlighted) {
                        before += 1.0;
                        continue;
                    }
                    if (n <= this.highlighted) continue;
                    after += 1.0;
                }
                this.pane.setVvalue(Math.max(0.0, before / (before + after)));
            }
        }
        if (this.highlightListener != null) {
            this.highlightListener.accept(this.getHighlighted());
        }
        this.showDocsFor(this.getHighlighted());
    }

    public void calculateEligible(String prefix, boolean allowSimilar, boolean canChangeToRare) {
        this.calculateEligible(prefix, allowSimilar, (SuggestionShown)((Object)this.shownState.get()), canChangeToRare);
    }

    public void calculateEligible(String prefix, boolean allowSimilar, SuggestionShown shown, boolean canChangeToRare) {
        this.lastPrefix = prefix;
        this.lastAllowSimilar = allowSimilar;
        this.eligible.clear();
        for (int i = 0; i < this.choices.size(); ++i) {
            List<Integer> wordStarts;
            Optional<EligibleDetail> me;
            String sugg = this.choices.get((int)i).choice;
            if (this.choices.get((int)i).shown.compareTo(shown) > 0) continue;
            if (sugg.toLowerCase().startsWith(prefix.toLowerCase())) {
                this.eligible.put(i, new EligibleDetail(0, 0, prefix.length()));
                continue;
            }
            if (!allowSimilar || !(me = (wordStarts = SuggestionList.splitIdentLower(sugg)).stream().map(j -> new EligibleDetail((int)j, SuggestionList.distanceTo(prefix, sugg, j), prefix.length())).filter(EligibleDetail::close).sorted().findFirst()).isPresent()) continue;
            this.eligible.put(i + this.doubleSuggestions.size() / 2, me.get());
        }
        if (this.eligible.isEmpty() && shown == SuggestionShown.COMMON && canChangeToRare) {
            this.shownState.set((Object)SuggestionShown.RARE);
            this.calculateEligible(prefix, allowSimilar, SuggestionShown.RARE, false);
        }
    }

    private static int distanceTo(String prefix, String candidate, int offset) {
        prefix = prefix.toLowerCase();
        String partialLower = candidate.substring(offset, Math.min(candidate.length(), offset + prefix.length())).toLowerCase();
        String partialLowerShort = candidate.substring(offset, Math.min(candidate.length(), offset + Math.max(1, prefix.length() - 1))).toLowerCase();
        String partialLowerLong = candidate.substring(offset, Math.min(candidate.length(), offset + 1 + prefix.length())).toLowerCase();
        return Math.min(Utility.editDistance(partialLower, prefix), Math.min(Utility.editDistance(partialLowerShort, prefix), Utility.editDistance(partialLowerLong, prefix)));
    }

    private static boolean hasCase(char c) {
        return Character.isUpperCase(c) != Character.isLowerCase(c);
    }

    private static List<Integer> splitIdentLower(String text) {
        int startCurWord = 0;
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (int i = 1; i < text.length(); ++i) {
            if (SuggestionList.hasCase(text.charAt(i)) && SuggestionList.hasCase(text.charAt(i - 1)) && (Character.isUpperCase(text.charAt(i)) == Character.isLowerCase(text.charAt(i - 1)) || Character.isLowerCase(text.charAt(i)) == Character.isUpperCase(text.charAt(i - 1))) && (startCurWord == 0 || i - startCurWord > 1)) {
                r.add(startCurWord);
                startCurWord = i;
                continue;
            }
            if (text.charAt(i) != '_' && text.charAt(i) != '.' || startCurWord >= i - 1) continue;
            r.add(startCurWord);
            startCurWord = i + 1;
        }
        r.add(startCurWord);
        return r;
    }

    public void updateVisual(String prefix, boolean immediate) {
        boolean showingAny = false;
        boolean showingAnySimilar = false;
        for (int i = 0; i < this.doubleSuggestions.size(); ++i) {
            if (this.eligible.containsKey(i)) {
                this.doubleSuggestions.get(i).animateIn(immediate);
                if (i > this.doubleSuggestions.size() / 2) {
                    showingAnySimilar = true;
                }
                showingAny = true;
                continue;
            }
            this.doubleSuggestions.get(i).animateOut(immediate);
        }
        if (showingAnySimilar) {
            if (immediate) {
                this.similarLabel.setToFullHeight();
            } else {
                this.similarLabel.getGrowToFullHeightTimeline(Suggestion.FADE_IN_SPEED).play();
            }
        } else if (immediate) {
            this.similarLabel.setToNothing();
        } else {
            this.similarLabel.getShrinkToNothingTimeline(Suggestion.FADE_OUT_SPEED).play();
        }
        if (!showingAny) {
            if (immediate) {
                this.noneLabel.setToFullHeight();
            } else {
                this.noneLabel.getGrowToFullHeightTimeline(Suggestion.FADE_IN_SPEED).play();
            }
        } else if (immediate) {
            this.noneLabel.setToNothing();
        } else {
            this.noneLabel.getShrinkToNothingTimeline(Suggestion.FADE_OUT_SPEED).play();
        }
        for (Map.Entry<Integer, EligibleDetail> e : this.eligible.entrySet()) {
            boolean canComplete = this.eligible.size() == 1 || this.highlighted == e.getKey() || this.doubleSuggestions.get(e.getKey()).getText().equals(prefix);
            this.doubleSuggestions.get(e.getKey()).notifyEligible(e.getValue().suggestionOffset, prefix.length(), canComplete, immediate);
        }
        if (this.highlighted != -1 && !this.eligible.containsKey(this.highlighted)) {
            this.setHighlighted(this.getFirstEligible(), true);
        }
    }

    public int eligibleCount() {
        return this.eligible.size();
    }

    public int getFirstEligible() {
        return this.eligible.keySet().stream().mapToInt(i -> i).min().orElse(-1);
    }

    public int getLastEligible() {
        return this.eligible.keySet().stream().mapToInt(i -> i).max().orElse(-1);
    }

    public void highlightFirstEligible() {
        this.setHighlighted(this.getFirstEligible(), false);
    }

    private int getHighlighted() {
        return this.choices.size() == 0 ? -1 : this.highlighted % this.choices.size();
    }

    public Optional<String> getLongestCommonPrefix() {
        return SuggestionList.longestCommonPrefix(this.eligible.entrySet().stream().filter(e -> (Integer)e.getKey() < this.choices.size()).map(e -> this.choices.get((int)((Integer)e.getKey()).intValue()).choice).collect(Collectors.toList()));
    }

    private static Optional<String> longestCommonPrefix(List<String> srcs) {
        return srcs.stream().reduce((a, b) -> {
            int maxLen = Math.min(a.length(), b.length());
            if (maxLen == 0) {
                return "";
            }
            for (int i = 0; i < maxLen; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return a.substring(0, i);
            }
            return a.substring(0, maxLen);
        });
    }

    public DoubleExpression widthProperty() {
        return this.pane.widthProperty();
    }

    public DoubleExpression typeWidthProperty() {
        return this.typeWidth;
    }

    public boolean isShowing() {
        return this.window.isShowing();
    }

    public boolean isInMiddleOfHiding() {
        return this.hiding;
    }

    private void showDocsFor(int selected) {
        if (this.cancelShowDocsTask != null) {
            this.cancelShowDocsTask.run();
            this.cancelShowDocsTask = null;
        }
        this.hideDocDisplay();
        if (selected != -1 && this.choices.get(selected).hasDocs()) {
            this.cancelShowDocsTask = JavaFXUtil.runAfter(Duration.millis((double)500.0), () -> this.docPane.getChildren().setAll((Object[])new Node[]{this.choices.get(selected).makeDocPane()}));
        }
    }

    private void hideDocDisplay() {
        this.docPane.getChildren().clear();
    }

    public static interface SuggestionListListener {
        public void suggestionListChoiceClicked(int var1);

        public Response suggestionListKeyTyped(KeyEvent var1, int var2);

        public Response suggestionListKeyPressed(KeyEvent var1, int var2);

        default public void suggestionListFocusStolen(int highlighted) {
        }

        default public void hidden() {
        }

        public static enum Response {
            DISMISS,
            CONTINUE;

        }
    }

    public static class SuggestionDetailsWithCustomDoc
    extends SuggestionDetails {
        private final FXSupplier<Pane> docMaker;

        public SuggestionDetailsWithCustomDoc(String choice, String suffix, String type, SuggestionShown shown, FXSupplier<Pane> docMaker) {
            super(choice, suffix, type, shown);
            this.docMaker = docMaker;
        }

        @Override
        public boolean hasDocs() {
            return true;
        }

        @Override
        public Pane makeDocPane() {
            return this.docMaker.get();
        }
    }

    public static class SuggestionDetailsWithHTMLDoc
    extends SuggestionDetails {
        private final String docHTML;

        public SuggestionDetailsWithHTMLDoc(String choice, SuggestionShown shown, String docHTML) {
            super(choice, null, null, shown);
            this.docHTML = docHTML;
        }

        public SuggestionDetailsWithHTMLDoc(String choice, String suffix, String type, SuggestionShown shown, String docHTML) {
            super(choice, suffix, type, shown);
            this.docHTML = docHTML;
        }

        @Override
        public boolean hasDocs() {
            return true;
        }

        @Override
        public Pane makeDocPane() {
            WebView webView = new WebView();
            BorderPane docDisplay = new BorderPane((Node)webView);
            JavaFXUtil.addStyleClass((Styleable)docDisplay, "suggestion-javadoc");
            webView.getEngine().setJavaScriptEnabled(false);
            webView.getEngine().loadContent(this.docHTML);
            docDisplay.setMaxWidth(400.0);
            docDisplay.setMaxHeight(300.0);
            webView.setBlendMode(BlendMode.DARKEN);
            return docDisplay;
        }
    }

    public static class SuggestionDetails {
        public final String choice;
        public final String suffix;
        public final String type;
        public final SuggestionShown shown;

        public SuggestionDetails(String choice) {
            this(choice, null, null, SuggestionShown.COMMON);
        }

        public SuggestionDetails(String choice, String suffix, String type, SuggestionShown shown) {
            if (choice == null) {
                throw new IllegalArgumentException();
            }
            if (shown == null) {
                throw new IllegalArgumentException();
            }
            this.choice = choice;
            this.suffix = suffix;
            this.type = type;
            this.shown = shown;
        }

        public boolean hasDocs() {
            return false;
        }

        public Pane makeDocPane() {
            return null;
        }
    }

    public static enum SuggestionShown {
        COMMON,
        RARE;

    }

    private static class EligibleDetail
    implements Comparable<EligibleDetail> {
        public final int suggestionOffset;
        public final int distance;
        private final int length;

        public EligibleDetail(int suggestionOffset, int distance, int length) {
            this.suggestionOffset = suggestionOffset;
            this.distance = distance;
            this.length = length;
        }

        @Override
        @OnThread(value=Tag.FX, ignoreParent=true)
        public @OnThread(value=Tag.FX, ignoreParent=true) int compareTo(EligibleDetail e) {
            if (this.suggestionOffset == 0 == (e.suggestionOffset == 0)) {
                return Integer.compare(this.distance, e.distance);
            }
            if (this.suggestionOffset == 0) {
                return -1;
            }
            return 1;
        }

        public boolean close() {
            if (this.distance == 0 && this.suggestionOffset == 0) {
                return true;
            }
            if (this.distance == 0 && this.suggestionOffset != 0) {
                return this.length >= 2;
            }
            if (this.distance == 1) {
                return this.length >= 3;
            }
            if (this.distance == 2) {
                return this.length >= 10;
            }
            return false;
        }
    }

    private static class SuggestionVBox
    extends VBox {
        private final SimpleStyleableDoubleProperty cssTypeWidthProperty = new SimpleStyleableDoubleProperty(TYPE_WIDTH_META_DATA);
        private final SimpleStyleableDoubleProperty cssMaxWidthProperty = new SimpleStyleableDoubleProperty(MAX_WIDTH_META_DATA);
        private static final CssMetaData<SuggestionVBox, Number> TYPE_WIDTH_META_DATA = JavaFXUtil.cssSize("-bj-type-width", SuggestionVBox::cssTypeWidthProperty);
        private static final CssMetaData<SuggestionVBox, Number> MAX_WIDTH_META_DATA = JavaFXUtil.cssSize("-bj-max-width", SuggestionVBox::cssMaxWidthProperty);
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList = JavaFXUtil.extendCss(VBox.getClassCssMetaData()).add(TYPE_WIDTH_META_DATA).add(MAX_WIDTH_META_DATA).build();

        private SuggestionVBox() {
        }

        public final SimpleStyleableDoubleProperty cssTypeWidthProperty() {
            return this.cssTypeWidthProperty;
        }

        public final SimpleStyleableDoubleProperty cssMaxWidthProperty() {
            return this.cssMaxWidthProperty;
        }

        public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
            return cssMetaDataList;
        }

        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return SuggestionVBox.getClassCssMetaData();
        }
    }
}

