/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotValueListener;
import bluej.utility.javafx.FXRunnable;
import javafx.application.Platform;

public class SlotTraversalChars
implements SlotValueListener {
    private final char[] endings;
    private FXRunnable callback;
    public static final SlotTraversalChars ASSIGN_LHS = new SlotTraversalChars('=');
    public static final SlotTraversalChars METHOD_NAME = new SlotTraversalChars(' ', '(');
    public static final SlotTraversalChars IDENTIFIER = new SlotTraversalChars(' ');

    public SlotTraversalChars(char ... endings) {
        this.endings = endings;
        this.callback = null;
    }

    public SlotTraversalChars(FXRunnable callback, char ... endings) {
        this.endings = endings;
        this.callback = callback;
    }

    @Override
    public boolean valueChanged(HeaderItem slot, String oldValue, String newValue, FocusParent<HeaderItem> parent) {
        for (char ending : this.endings) {
            if (!newValue.contains("" + ending)) continue;
            if (newValue.charAt(newValue.length() - 1) == ending) {
                if (this.callback != null) {
                    this.callback.run();
                } else {
                    Platform.runLater(() -> parent.focusRight(slot));
                }
            }
            return false;
        }
        return true;
    }

    public char[] getChars() {
        return this.endings;
    }

    @Override
    public void backSpacePressedAtStart(HeaderItem slot) {
    }

    @Override
    public void deletePressedAtEnd(HeaderItem slot) {
    }
}

