/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.FrameState;
import java.util.LinkedList;

public class UndoRedoManager {
    private int current = 0;
    private boolean recording = false;
    private boolean restoring = false;
    private final LinkedList<FrameState> statesStack = new LinkedList();
    private final int MAX_CAPACITY = 30;

    public UndoRedoManager(FrameState initialState) {
        this.statesStack.add(initialState);
    }

    private void addState(FrameState state) {
        if (!this.restoring) {
            boolean newState = false;
            if (this.statesStack.size() > 0 && state.equals(this.statesStack.get(this.current))) {
                this.statesStack.set(this.current, state);
            } else {
                newState = true;
                while (this.canRedo()) {
                    this.statesStack.removeLast();
                }
                this.statesStack.add(state);
                ++this.current;
                if (this.statesStack.size() > 30) {
                    this.statesStack.removeFirst();
                    --this.current;
                }
            }
        }
    }

    public void beginFrameState(FrameState state) {
        this.recording = true;
        this.addState(state);
    }

    public void endFrameState(FrameState state) {
        this.recording = false;
        this.addState(state);
    }

    public boolean canUndo() {
        return this.current > 0;
    }

    public boolean canRedo() {
        return this.current < this.statesStack.size() - 1;
    }

    public FrameState undo() {
        this.recording = false;
        if (this.canUndo()) {
            --this.current;
            return this.statesStack.get(this.current);
        }
        return null;
    }

    public FrameState redo() {
        this.recording = false;
        if (this.canRedo()) {
            ++this.current;
            return this.statesStack.get(this.current);
        }
        return null;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void startRestoring() {
        this.restoring = true;
    }

    public void stopRestoring() {
        this.restoring = false;
    }
}

