/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.DeleteFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import java.util.Arrays;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class PasteFrameOperation
extends FrameOperation {
    public PasteFrameOperation(InteractionManager editor) {
        super(editor, "PASTE", AbstractOperation.Combine.ALL, (KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
    }

    @Override
    protected void execute(List<Frame> frames) {
        if (frames.size() > 0) {
            FrameCursor insertionCursor = frames.get(0).getCursorBefore();
            new DeleteFrameOperation(this.editor).execute(frames);
            this.editor.getSelection().clear();
            insertionCursor.requestFocus();
        }
        boolean shouldDisable = !this.editor.getFocusedCursor().getParentCanvas().getParent().getFrame().isFrameEnabled();
        List<CodeElement> elements = GreenfootFrameUtil.getClipboardElements();
        if (elements != null && elements.size() > 0) {
            elements.forEach(codeElement -> {
                Frame frame = codeElement.createFrame(this.editor);
                if (this.editor.getFocusedCursor().acceptsFrame(frame.getClass())) {
                    this.editor.getFocusedCursor().insertBlockAfter(frame);
                    if (shouldDisable) {
                        frame.setFrameEnabled(false);
                    }
                    frame.getCursorAfter().requestFocus();
                }
            });
        }
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l("Paste", EditableSlot.MenuItemOrder.PASTE));
    }
}

