/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import java.util.Arrays;
import java.util.List;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class DeleteFrameOperation
extends FrameOperation {
    public DeleteFrameOperation(InteractionManager editor) {
        super(editor, "DELETE", AbstractOperation.Combine.ALL, (KeyCombination)new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]));
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return Arrays.asList(this.l("Delete", EditableSlot.MenuItemOrder.DELETE));
    }

    @Override
    public void enablePreview() {
        this.editor.getSelection().setDeletePreview(true);
    }

    @Override
    public void disablePreview() {
        this.editor.getSelection().setDeletePreview(false);
    }

    @Override
    protected void execute(List<Frame> frames) {
        if (!frames.isEmpty()) {
            FrameCursor focusAfter = frames.get(0).getCursorBefore();
            frames.forEach(frame -> frame.getParentCanvas().removeBlock((Frame)frame));
            focusAfter.requestFocus();
        }
        this.editor.getSelection().clear();
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

