/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.operations;

import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Utility;
import java.util.List;
import java.util.function.Consumer;

public class CustomFrameOperation
extends FrameOperation {
    private List<AbstractOperation.ItemLabel> labels;
    private Consumer<List<Frame>> action;

    public CustomFrameOperation(InteractionManager editor, String identifier, AbstractOperation.Combine combine, List<String> name, EditableSlot.MenuItemOrder menuOrder, Consumer<List<Frame>> action) {
        super(editor, identifier, combine);
        this.labels = Utility.mapList(name, n -> this.l((String)n, menuOrder));
        this.action = action;
    }

    public CustomFrameOperation(InteractionManager editor, String identifier, List<String> name, EditableSlot.MenuItemOrder menuOrder, Frame f, Runnable action) {
        this(editor, identifier, AbstractOperation.Combine.ONE, name, menuOrder, (List<Frame> frames) -> {
            if ((frames.size() != 1 || frames.get(0) != f) && frames.size() != 0) {
                throw new IllegalStateException();
            }
            action.run();
        });
    }

    @Override
    protected void execute(List<Frame> frames) {
        this.action.accept(frames);
    }

    @Override
    public List<AbstractOperation.ItemLabel> getLabels() {
        return this.labels;
    }

    @Override
    public boolean onlyOnContextMenu() {
        return true;
    }
}

