/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.editor.stride.CodeOverlayPane;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.IdentityHashMap;
import javafx.beans.binding.DoubleExpression;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class SuggestedFollowUpDisplay {
    private final InteractionManager editor;
    private final FXRunnable action;
    private final VBox content = new VBox();
    private static final IdentityHashMap<InteractionManager, SuggestedFollowUpDisplay> displays = new IdentityHashMap();

    public SuggestedFollowUpDisplay(InteractionManager editor, String text, FXRunnable action) {
        this.editor = editor;
        this.action = action;
        JavaFXUtil.addStyleClass((Styleable)this.content, "suggested-followup-pane");
        Button yes = new Button("Yes (" + editor.getKey(InteractionManager.ShortcutKey.YES_ANYWHERE) + ")");
        yes.setOnAction(e -> {
            action.run();
            this.hide();
        });
        Button no = new Button("No (" + editor.getKey(InteractionManager.ShortcutKey.NO_ANYWHERE) + ")");
        no.setOnAction(e -> this.hide());
        HBox hbox = new HBox(new Node[]{yes, no});
        JavaFXUtil.addStyleClass((Styleable)hbox, "suggested-followup-hbox");
        this.content.getChildren().addAll((Object[])new Node[]{new Label(text), hbox});
        CodeOverlayPane.setDropShadow((Node)this.content);
    }

    public void showBefore(Node n) {
        if (displays.get(this.editor) != null) {
            displays.get(this.editor).hide();
        }
        this.editor.getCodeOverlayPane().addOverlay((Node)this.content, n, null, (DoubleExpression)this.content.heightProperty().add(5.0).negate());
        this.content.toBack();
        displays.put(this.editor, this);
    }

    public void hide() {
        this.editor.getCodeOverlayPane().removeOverlay((Node)this.content);
        displays.remove(this.editor);
    }

    public static void shortcutTyped(InteractionManager editor, InteractionManager.ShortcutKey key) {
        SuggestedFollowUpDisplay display = displays.get(editor);
        if (display != null) {
            if (key == InteractionManager.ShortcutKey.YES_ANYWHERE) {
                display.action.run();
            }
            display.hide();
        }
    }

    public static void modificationIn(InteractionManager editor) {
        SuggestedFollowUpDisplay display = displays.get(editor);
        if (display != null) {
            display.hide();
        }
    }
}

