/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.SandwichCanvasesElement;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.frames.GreenfootFrameDictionary;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.MultiCanvasFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SandwichCanvasesFrame
extends MultiCanvasFrame
implements CodeFrame<SandwichCanvasesElement>,
DebuggableFrame {
    private String stylePrefix;
    private String frameCaption;
    private final JavaCanvas firstCanvas;
    private String intermediateCanvasCaption;
    private final List<JavaCanvas> intermediateCanvases = new ArrayList<JavaCanvas>();
    private String tailCanvasCaption;
    private JavaCanvas tailCanvas;
    protected SandwichCanvasesElement element;
    protected final InteractionManager editor;
    private GreenfootFrameDictionary dictionary = GreenfootFrameDictionary.getDictionary();

    protected SandwichCanvasesFrame(InteractionManager editor, String frameCaption, String intermediateCanvasCaption, String tailCanvasCaption, String stylePrefix) {
        super(editor, frameCaption, stylePrefix);
        this.frameCaption = frameCaption;
        this.editor = editor;
        this.stylePrefix = stylePrefix;
        this.intermediateCanvasCaption = intermediateCanvasCaption;
        this.tailCanvasCaption = tailCanvasCaption;
        this.firstCanvas = new JavaCanvas(editor, this, stylePrefix, false);
        this.addCanvas(null, this.firstCanvas);
    }

    protected void addIntermediateCanvas() {
        this.addIntermediateCanvas(null, null);
    }

    private void addIntermediateCanvas(FrameCanvas canvas, FrameCursor cursor, int at) {
        ArrayList<Frame> contents = new ArrayList<Frame>();
        if (canvas != null && cursor != null) {
            while (cursor.getFrameAfter() != null) {
                contents.add(cursor.getFrameAfter());
                cursor = cursor.getDown();
            }
            contents.forEach(c -> canvas.removeBlock((Frame)c));
        }
        this.addIntermediateCanvas(null, contents, at);
    }

    public void addIntermediateCanvas(List<SlotFragment> slots, List contents) {
        this.addIntermediateCanvas(slots, contents, this.canvases.size());
    }

    private void addIntermediateCanvas(List<SlotFragment> slots, List contents, int at) {
        JavaCanvas intermediateCanvas = new JavaCanvas(this.editor, this, this.stylePrefix, false);
        if (contents != null) {
            intermediateCanvas.getFirstCursor().insertFramesAfter(contents);
        }
        FrameContentRow intermediateHeader = this.getFrameContentRow(slots, intermediateCanvas, at - 1);
        this.addCanvas(intermediateHeader, intermediateCanvas, at);
        if (!intermediateHeader.focusLeftEndFromPrev()) {
            intermediateCanvas.getFirstCursor().requestFocus();
        }
        this.intermediateCanvases.add(at - 1, intermediateCanvas);
        this.editor.modifiedFrame(this);
    }

    protected abstract FrameContentRow getFrameContentRow(List<SlotFragment> var1, JavaCanvas var2, int var3);

    protected void pullUpCanvasContents(FrameCursor cursor, FrameCanvas canvas) {
        canvas.getFirstCursor().getUp().requestFocus();
        ArrayList<Frame> contents = new ArrayList<Frame>((Collection<Frame>)canvas.getBlockContents());
        contents.forEach(frame -> {
            canvas.removeBlock((Frame)frame);
            frame.setParentCanvas(null);
        });
        cursor.insertFramesAfter(contents);
        if (!contents.isEmpty()) {
            cursor.insertBlockAfter(new BlankFrame(this.editor));
        }
        this.removeCanvas(canvas);
        this.editor.modifiedFrame(this);
    }

    public boolean addTailCanvas() {
        if (this.tailCanvas != null) {
            return false;
        }
        this.tailCanvas = new JavaCanvas(this.editor, this, this.stylePrefix, false);
        SlotLabel tailCanvasLabel = new SlotLabel(this.tailCanvasCaption, new String[0]);
        JavaFXUtil.addStyleClass(tailCanvasLabel, "divider-" + this.tailCanvasCaption);
        this.addCanvas(new FrameContentRow((Frame)this, tailCanvasLabel), this.tailCanvas);
        this.tailCanvas.getFirstCursor().requestFocus();
        this.editor.modifiedFrame(this);
        return true;
    }

    private void addTailCanvas(FrameCanvas canvas, FrameCursor cursor) {
        if (this.addTailCanvas()) {
            ArrayList<Frame> contents = new ArrayList<Frame>();
            if (canvas != null && cursor != null) {
                while (cursor.getFrameAfter() != null) {
                    contents.add(cursor.getFrameAfter());
                    cursor = cursor.getDown();
                }
                contents.forEach(c -> canvas.removeBlock((Frame)c));
            }
            this.tailCanvas.getFirstCursor().insertFramesAfter(contents);
        }
    }

    @Override
    protected void removeCanvas(FrameCanvas canvas) {
        super.removeCanvas(canvas);
        if (this.intermediateCanvases.contains(canvas)) {
            this.intermediateCanvases.remove(canvas);
        }
        if (this.tailCanvas == canvas) {
            this.tailCanvas = null;
        }
        this.editor.modifiedFrame(this);
    }

    @Override
    public void regenerateCode() {
        ArrayList<CodeElement> firstCanvasContents = new ArrayList<CodeElement>();
        this.firstCanvas.getBlocksSubtype(CodeFrame.class).forEach(f -> {
            f.regenerateCode();
            firstCanvasContents.add((CodeElement)f.getCode());
        });
        List<List<CodeElement>> intermediateCanvasesContents = Utility.mapList(this.intermediateCanvases, canvas -> Utility.mapList(canvas.getBlocksSubtype(CodeFrame.class), f -> {
            f.regenerateCode();
            return f.getCode();
        }));
        ArrayList<CodeElement> tailCanvasContents = null;
        if (this.tailCanvas != null) {
            tailCanvasContents = new ArrayList<CodeElement>();
            for (CodeFrame f2 : this.tailCanvas.getBlocksSubtype(CodeFrame.class)) {
                f2.regenerateCode();
                tailCanvasContents.add((CodeElement)f2.getCode());
            }
        }
        this.element = this.regenerateCodeElement(firstCanvasContents, intermediateCanvasesContents, tailCanvasContents, this.frameEnabledProperty.get());
    }

    protected abstract SandwichCanvasesElement regenerateCodeElement(List<CodeElement> var1, List<List<CodeElement>> var2, List<CodeElement> var3, boolean var4);

    @Override
    public SandwichCanvasesElement getCode() {
        return this.element;
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    public JavaCanvas getFirstCanvas() {
        return this.firstCanvas;
    }

    public JavaCanvas getTailCanvas() {
        return this.tailCanvas;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(this, debug);
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions() {
        ArrayList<ExtensionDescription> r = new ArrayList<ExtensionDescription>(super.getAvailableExtensions());
        if (this.tailCanvas == null) {
            r.add(new ExtensionDescription(this.dictionary.getExtensionChar(this.intermediateCanvasCaption), "Add " + this.intermediateCanvasCaption, this::addIntermediateCanvas));
            r.add(new ExtensionDescription(this.dictionary.getExtensionChar(this.tailCanvasCaption), "Add " + this.tailCanvasCaption, this::addTailCanvas, true));
        }
        return r;
    }

    public DebuggableParentFrame getFirstCanvasDebug() {
        return new DebuggableParentFrame(){

            @Override
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)SandwichCanvasesFrame.this.getParentCanvas()).showDebugBefore(SandwichCanvasesFrame.this, debug);
            }

            @Override
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SandwichCanvasesFrame.this.getFirstCanvas().showDebugBefore(null, debug);
            }
        };
    }

    public DebuggableParentFrame getIntermediateCanvasDebug(final int intermediateCanvasIndex) {
        return new DebuggableParentFrame(){

            @Override
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)SandwichCanvasesFrame.this.getParentCanvas()).showDebugBefore(SandwichCanvasesFrame.this, debug);
            }

            @Override
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return ((JavaCanvas)SandwichCanvasesFrame.this.intermediateCanvases.get(intermediateCanvasIndex)).showDebugBefore(null, debug);
            }
        };
    }

    public DebuggableParentFrame getTailCanvasDebug() {
        return new DebuggableParentFrame(){

            @Override
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)SandwichCanvasesFrame.this.getParentCanvas()).showDebugBefore(SandwichCanvasesFrame.this, debug);
            }

            @Override
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SandwichCanvasesFrame.this.getTailCanvas().showDebugBefore(null, debug);
            }
        };
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.firstCanvas.getFirstCursor().requestFocus();
        return true;
    }

    @Override
    public boolean acceptsType(FrameCanvas canvas, Class<? extends Frame> blockClass) {
        return this.getEditor().getDictionary().isValidStatment(blockClass);
    }

    @Override
    public List<ExtensionDescription> getAvailableInnerExtensions(FrameCanvas canvas, FrameCursor cursor) {
        ArrayList<ExtensionDescription> inners = new ArrayList<ExtensionDescription>();
        if (canvas == this.firstCanvas) {
            inners.add(new ExtensionDescription('\b', "Remove " + this.frameCaption + ", keep contents", () -> new PullUpContentsOperation(this.editor).activate(this.getFrame()), false, false));
        }
        if (canvas == this.firstCanvas || this.intermediateCanvases.contains(canvas)) {
            inners.add(new ExtensionDescription(this.dictionary.getExtensionChar(this.intermediateCanvasCaption), "Add " + this.intermediateCanvasCaption, () -> this.addIntermediateCanvas(canvas, cursor, this.canvases.indexOf(canvas) + 1), true));
        }
        if (this.intermediateCanvases.contains(canvas)) {
            inners.add(new ExtensionDescription('\b', "Remove " + this.intermediateCanvasCaption + ", keep contents", () -> this.pullUpCanvasContents(this.getCursorBefore(canvas), canvas), false, false));
        }
        if (Utility.findLast(this.getCanvases()).orElse(null) == canvas && this.tailCanvas == null) {
            inners.add(new ExtensionDescription(this.dictionary.getExtensionChar(this.tailCanvasCaption), "Add " + this.tailCanvasCaption, () -> this.addTailCanvas(canvas, cursor), true));
        }
        if (this.tailCanvas != null && this.tailCanvas == canvas) {
            inners.add(new ExtensionDescription('\b', "Remove " + this.tailCanvasCaption + ", keep contents", () -> this.pullUpCanvasContents(this.getCursorBefore(canvas), canvas), false, false));
        }
        return inners;
    }
}

