/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class FrameDictionary<CATEGORY> {
    private final List<Entry<CATEGORY>> entries;

    protected FrameDictionary(List<Entry<CATEGORY>> entries) {
        this.entries = entries;
    }

    public List<Entry<CATEGORY>> getAllBlocks() {
        return this.entries;
    }

    public List<Entry<CATEGORY>> getBlocksInCategory(CATEGORY c) {
        return this.entries.stream().filter(e -> e.inCategory(c)).collect(Collectors.toList());
    }

    public abstract CATEGORY[] getCategories();

    public abstract String[] getCategoryNames();

    public List<Entry<CATEGORY>> getFramesForShortcutKey(char k) {
        return this.entries.stream().filter(e -> e.hasShortcut(k)).collect(Collectors.toList());
    }

    public abstract boolean isValidStatment(Class<? extends Frame> var1);

    public abstract boolean isValidClassMethod(Class<? extends Frame> var1);

    public abstract boolean isValidConstructor(Class<? extends Frame> var1);

    public abstract boolean isValidInterfaceMethod(Class<? extends Frame> var1);

    public abstract boolean isValidField(Class<? extends Frame> var1);

    public static class Entry<CATEGORY> {
        private final FrameFactory<? extends Frame> factory;
        private final List<Character> shortcutKeys;
        private final String name;
        private final String description;
        private final CATEGORY category;
        private final boolean validOnSelection;

        public Entry(List<Character> shortcutKeys, FrameFactory<? extends Frame> factory, boolean validOnSelection, CATEGORY category, String name, String description) {
            this.shortcutKeys = new ArrayList<Character>(shortcutKeys);
            this.factory = factory;
            this.category = category;
            this.name = name;
            this.description = description;
            this.validOnSelection = validOnSelection;
        }

        public Entry(char shortcutKey, FrameFactory<? extends Frame> factory, boolean validOnSelection, CATEGORY category, String name, String description) {
            this(Arrays.asList(Character.valueOf(shortcutKey)), factory, validOnSelection, category, name, description);
        }

        public boolean inCategory(CATEGORY c) {
            return this.category.equals(c);
        }

        public boolean hasShortcut(char k) {
            return this.shortcutKeys.contains(Character.valueOf(k));
        }

        public List<Character> getReadOnlyShortcuts() {
            return Collections.unmodifiableList(this.shortcutKeys);
        }

        public FrameFactory<? extends Frame> getFactory() {
            return this.factory;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public CATEGORY getCategory() {
            return this.category;
        }

        public String getCategoryName() {
            return this.category.toString();
        }

        public Class<? extends Frame> getBlockClass() {
            return this.factory.getBlockClass();
        }

        public boolean validOnSelection() {
            return this.validOnSelection;
        }

        public String getShortcuts() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.shortcutKeys.get(0));
            for (int i = 1; i < this.shortcutKeys.size(); ++i) {
                builder.append(", ").append(this.shortcutKeys.get(i));
            }
            return builder.toString();
        }
    }
}

