/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.CanvasVBox;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.slots.HeaderItem;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightLabel;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class FrameCanvas
implements FrameContentItem {
    private final CanvasParent parentBlock;
    protected final InteractionManager editorFrm;
    private final ObservableList<Frame> blockContents = FXCollections.observableArrayList();
    private final List<VBox> specials = new ArrayList<VBox>();
    private final List<FrameCursor> cursors = new ArrayList<FrameCursor>();
    private final CanvasVBox canvas = new CanvasVBox(200.0, (Collection<Frame>)this.blockContents);
    private final SimpleBooleanProperty showingProperty = new SimpleBooleanProperty(true);
    private boolean animateLeftMarginScale;
    private final ScalableHeightLabel previewOpeningCurly = new ScalableHeightLabel("{", true);
    private final ScalableHeightLabel previewClosingCurly = new ScalableHeightLabel("}", true);

    private int childBlockIndex(int blockIndex) {
        return blockIndex * 3 + 2;
    }

    private int childCursorIndex(int cursorIndex) {
        return cursorIndex * 3;
    }

    private void validate(FrameCursor cursor, int cursorIndex) {
        this.validate();
        if (this.cursors.get(cursorIndex) != cursor) {
            throw new IllegalStateException("Stable cursor was moved, from: " + cursorIndex + " to: " + this.cursors.indexOf(cursor));
        }
    }

    private void validate() {
        int i;
        if (this.cursors.size() > 0 && this.cursors.size() != this.blockContents.size() + 1) {
            throw new IllegalStateException("Canvas: cursors and blocks out of length sync");
        }
        if (this.canvas.getChildren().size() != this.cursors.size() + this.blockContents.size() + this.specials.size()) {
            throw new IllegalStateException("Canvas: children out of length sync");
        }
        for (i = 0; i < this.cursors.size(); ++i) {
            if (this.cursors.get(i) == null) {
                throw new IllegalStateException("Canvas: cursor is null");
            }
            if (this.cursors.indexOf(this.cursors.get(i)) != i || this.cursors.lastIndexOf(this.cursors.get(i)) != i) {
                throw new IllegalStateException("Canvas: cursor is duplicated");
            }
            if (this.canvas.getChildren().get(this.childCursorIndex(i)) != this.cursors.get(i).getNode()) {
                throw new IllegalStateException("Canvas: cursors out of sync");
            }
            if (this.cursors.get(i).getParentCanvas() == this) continue;
            throw new IllegalStateException("Canvas: cursor parent out of sync");
        }
        for (i = 0; i < this.blockContents.size(); ++i) {
            if (this.blockContents.get(i) == null) {
                throw new IllegalStateException("Canvas: block is null");
            }
            if (this.blockContents.indexOf(this.blockContents.get(i)) != i || this.blockContents.lastIndexOf(this.blockContents.get(i)) != i) {
                throw new IllegalStateException("Canvas: block is duplicated");
            }
            if (this.canvas.getChildren().get(this.childBlockIndex(i)) != ((Frame)this.blockContents.get(i)).getNode()) {
                throw new IllegalStateException("Canvas: blocks out of sync");
            }
            if (((Frame)this.blockContents.get(i)).getParentCanvas() == this) continue;
            throw new IllegalStateException("Canvas: block parent out of sync");
        }
        for (i = 0; i < this.blockContents.size(); ++i) {
            if (this.specials.get(i) == null) {
                throw new IllegalStateException("Canvas: special is null");
            }
            if (this.specials.indexOf(this.specials.get(i)) != i || this.specials.lastIndexOf(this.specials.get(i)) != i) {
                throw new IllegalStateException("Canvas: special is duplicated");
            }
            if (this.canvas.getChildren().get(this.childBlockIndex(i) - 1) == this.specials.get(i)) continue;
            throw new IllegalStateException("Canvas: specials out of sync");
        }
    }

    public CanvasParent getParent() {
        return this.parentBlock;
    }

    public VBox getSpecialBefore(FrameCursor cursor) {
        int index = 0;
        if (cursor == null) {
            index = 0;
            cursor = this.cursors.get(index);
        } else {
            index = this.cursors.indexOf(cursor);
        }
        if (index < 0) {
            throw new IllegalArgumentException("insertSpecialBefore: canvas does not contain specified cursor");
        }
        return this.specials.get(index);
    }

    public VBox getSpecialBefore(Frame f) {
        return this.getSpecialAfter(this.getCursorBefore(f));
    }

    public VBox getSpecialAfter(FrameCursor cursor) {
        int index;
        if (cursor == null) {
            index = this.cursors.size() - 1;
            cursor = this.cursors.get(index);
        } else {
            index = this.cursors.indexOf(cursor);
        }
        if (index < 0) {
            throw new IllegalArgumentException("insertSpecialBefore: canvas does not contain specified cursor");
        }
        return this.specials.get(index);
    }

    public void insertBlockBefore(Frame toAdd, FrameCursor cursor) {
        if (toAdd == null) {
            throw new IllegalArgumentException("Cannot add null block");
        }
        if (!this.acceptsType(toAdd)) {
            throw new IllegalArgumentException("Block " + this.getClass() + " does not accept " + toAdd.getClass());
        }
        if (toAdd.getParentCanvas() != null) {
            throw new IllegalArgumentException("Block already has parent");
        }
        int index = 0;
        if (cursor == null) {
            index = 0;
            cursor = this.cursors.get(index);
        } else {
            index = this.cursors.indexOf(cursor);
        }
        if (index < 0) {
            throw new IllegalArgumentException("insertBlockBefore: canvas does not contain specified cursor");
        }
        int childIndex = this.childCursorIndex(index);
        FrameCursor newCursor = this.editorFrm.createCursor(this);
        VBox special = new VBox();
        this.canvas.getChildren().add(childIndex, (Object)toAdd.getNode());
        this.canvas.getChildren().add(childIndex, (Object)special);
        this.canvas.getChildren().add(childIndex, (Object)newCursor.getNode());
        this.cursors.add(index, newCursor);
        this.blockContents.add(index, (Object)toAdd);
        this.specials.add(index, special);
        toAdd.setParentCanvas(this);
        this.validate(cursor, index + 1);
    }

    public void insertBlockAfter(Frame toAdd, FrameCursor cursor) {
        int index;
        if (toAdd == null) {
            throw new IllegalArgumentException("Cannot add null block");
        }
        if (!this.acceptsType(toAdd)) {
            throw new IllegalArgumentException("Block " + this.getClass() + " does not accept " + toAdd.getClass());
        }
        if (toAdd.getParentCanvas() != null) {
            throw new IllegalArgumentException("Block already has parent");
        }
        if (cursor == null) {
            index = this.cursors.size() - 1;
            cursor = this.cursors.get(index);
        } else {
            index = this.cursors.indexOf(cursor);
        }
        if (index < 0) {
            throw new IllegalArgumentException("insertBlockAfter: canvas does not contain specified cursor");
        }
        int childIndex = this.childCursorIndex(index);
        FrameCursor newCursor = this.editorFrm.createCursor(this);
        VBox special = new VBox();
        this.canvas.getChildren().add(childIndex + 1, (Object)newCursor.getNode());
        this.canvas.getChildren().add(childIndex + 1, (Object)toAdd.getNode());
        this.canvas.getChildren().add(childIndex + 1, (Object)special);
        this.cursors.add(index + 1, newCursor);
        this.blockContents.add(index, (Object)toAdd);
        this.specials.add(index, special);
        toAdd.setParentCanvas(this);
        this.validate(cursor, index);
    }

    public void removeBlock(Frame b) {
        int index = this.blockContents.indexOf((Object)b);
        if (index < 0) {
            throw new IllegalArgumentException("removeBlock: canvas does not contain specified block");
        }
        this.canvas.getChildren().remove((Object)((Frame)this.blockContents.get(index)).getNode());
        this.canvas.getChildren().remove((Object)this.specials.get(index));
        this.canvas.getChildren().remove((Object)this.cursors.get(index + 1).getNode());
        this.blockContents.remove(index);
        this.cursors.remove(index + 1);
        this.specials.remove(index);
        b.cleanup();
        b.setParentCanvas(null);
        this.validate();
    }

    public void replaceBlock(Frame old, Frame replacement) {
        if (replacement == null) {
            throw new IllegalArgumentException("Cannot add null block");
        }
        if (!this.acceptsType(replacement)) {
            throw new IllegalArgumentException("Block " + this.getClass() + " does not accept " + replacement.getClass());
        }
        if (replacement.getParentCanvas() != null) {
            throw new IllegalArgumentException("Block already has parent");
        }
        int index = this.blockContents.indexOf((Object)old);
        if (index < 0) {
            throw new IllegalArgumentException("replaceBlock: canvas does not contain specified block");
        }
        this.blockContents.set(index, (Object)replacement);
        this.canvas.getChildren().set(this.childBlockIndex(index), (Object)replacement.getNode());
        replacement.setParentCanvas(this);
        old.cleanup();
        old.setParentCanvas(null);
        this.validate();
        replacement.focusWhenJustAdded();
    }

    public Frame getFrameBefore(FrameCursor cursor) {
        int index = this.cursors.indexOf(cursor);
        if (index < 0) {
            throw new IllegalArgumentException("getBlockBefore: canvas does not contain specified cursor");
        }
        if (index == 0) {
            return null;
        }
        return (Frame)this.blockContents.get(index - 1);
    }

    public Stream<Frame> getFramesBefore(Frame f) {
        if (f == null) {
            return this.blockContents.stream();
        }
        int index = this.blockContents.indexOf((Object)f);
        if (index == -1) {
            throw new IllegalArgumentException("getFramesBefore: canvas does not contain specified frame");
        }
        return this.blockContents.stream().limit(index);
    }

    public Frame getFrameAfter(FrameCursor cursor) {
        int index = this.cursors.indexOf(cursor);
        if (index < 0) {
            throw new IllegalArgumentException("getBlockAfter: canvas does not contain specified cursor");
        }
        if (index == this.blockContents.size()) {
            return null;
        }
        return (Frame)this.blockContents.get(index);
    }

    public Stream<Frame> getFramesAfter(Frame frame) {
        if (frame == null) {
            return this.blockContents.stream();
        }
        int index = this.blockContents.indexOf((Object)frame);
        if (index < 0) {
            throw new IllegalArgumentException("getFramesAfter: canvas does not contain specified frame");
        }
        return this.blockContents.stream().skip(index + 1);
    }

    public FrameCursor getCursorBefore(Frame block) {
        int index = this.blockContents.indexOf((Object)block);
        if (index < 0) {
            throw new IllegalArgumentException("getCursorBefore: canvas does not contain specified block");
        }
        return this.cursors.get(index);
    }

    public FrameCursor getCursorAfter(Frame block) {
        int index = this.blockContents.indexOf((Object)block);
        if (index < 0) {
            throw new IllegalArgumentException("getCursorBefore: canvas does not contain specified block");
        }
        return this.cursors.get(index + 1);
    }

    public boolean acceptsType(Frame blockOfType) {
        if (blockOfType != null) {
            return this.parentBlock.acceptsType(this, blockOfType.getClass());
        }
        return false;
    }

    @Override
    public Node getNode() {
        return this.canvas;
    }

    public <T> List<T> getBlocksSubtype(Class<T> clazz) {
        ArrayList<T> r = new ArrayList<T>();
        for (Frame b : this.blockContents) {
            if (!clazz.isAssignableFrom(b.getClass())) continue;
            r.add(clazz.cast(b));
        }
        return r;
    }

    public FrameCursor getPrevCursor(FrameCursor orig, boolean canChangeLevel) {
        FrameCursor c;
        int index = this.cursors.indexOf(orig);
        if (index < 0) {
            throw new IllegalArgumentException("getPrevCursor: cursor not in this canvas");
        }
        if (index == 0) {
            if (canChangeLevel) {
                return this.parentBlock.getCursorBefore(this);
            }
            return null;
        }
        if (canChangeLevel && (c = ((Frame)this.blockContents.get(index - 1)).getLastInternalCursor()) != null) {
            return c;
        }
        return this.cursors.get(index - 1);
    }

    public FrameCursor getNextCursor(FrameCursor orig, boolean canChangeLevel) {
        FrameCursor c;
        int index = this.cursors.indexOf(orig);
        if (index < 0) {
            throw new IllegalArgumentException("getPrevCursor: cursor not in this canvas");
        }
        if (index == this.cursors.size() - 1) {
            if (canChangeLevel) {
                return this.parentBlock.getCursorAfter(this);
            }
            return null;
        }
        if (canChangeLevel && (c = ((Frame)this.blockContents.get(index)).getFirstInternalCursor()) != null) {
            return c;
        }
        return this.cursors.get(index + 1);
    }

    public FrameCursor findClosestCursor(double sceneX, double sceneY, List<Frame> exclude, boolean isDrag, boolean canDescend) {
        for (int i = 0; i < this.cursors.size(); ++i) {
            FrameCursor c = this.cursors.get(i);
            Bounds sceneBounds = c.getSceneBounds();
            if (sceneY < sceneBounds.getMaxY()) {
                return c;
            }
            if (i >= this.blockContents.size()) continue;
            Frame b = (Frame)this.blockContents.get(i);
            if (!canDescend || exclude != null && exclude.contains(b)) {
                int validCursorBelow;
                int validCursorAbove;
                for (validCursorAbove = i; validCursorAbove >= 1 && exclude != null && exclude.contains(this.blockContents.get(validCursorAbove - 1)); --validCursorAbove) {
                }
                for (validCursorBelow = i + 1; validCursorBelow < this.blockContents.size() && exclude != null && exclude.contains(this.blockContents.get(validCursorBelow)); ++validCursorBelow) {
                }
                double distToAbove = sceneY - this.cursors.get(validCursorAbove).getSceneBounds().getMaxY();
                double distToBelow = sceneY - this.cursors.get(validCursorBelow).getSceneBounds().getMinY();
                if (distToBelow < 0.0) {
                    if (distToAbove <= -distToBelow) {
                        return this.cursors.get(validCursorAbove);
                    }
                    return this.cursors.get(validCursorBelow);
                }
                i = validCursorBelow - 1;
                continue;
            }
            FrameCursor c2 = b.findCursor(sceneX, sceneY, this.cursors.get(i), this.cursors.get(i + 1), exclude, isDrag, true);
            if (!(sceneY < b.lowestCursorY())) continue;
            return c2;
        }
        return this.getLastCursor();
    }

    public FrameCursor getFirstCursor() {
        return this.cursors.get(0);
    }

    public FrameCursor getLastCursor() {
        return this.cursors.get(this.cursors.size() - 1);
    }

    @Override
    public Bounds getSceneBounds() {
        return this.canvas.localToScene(this.canvas.getBoundsInLocal());
    }

    public double getHeight() {
        return this.canvas.getHeight();
    }

    public int blockCount() {
        return this.blockContents.size();
    }

    public ObservableList<Frame> getBlockContents() {
        return this.blockContents;
    }

    public List<? extends RecallableFocus> getFocusableCursors() {
        return this.cursors;
    }

    public List<Frame> framesBetween(FrameCursor a, FrameCursor b) {
        int late;
        int early;
        int ai = this.cursors.indexOf(a);
        int bi = this.cursors.indexOf(b);
        if (ai == -1 || bi == -1) {
            throw new IllegalArgumentException("framesBetween called for a cursor not present in canvas");
        }
        if (ai < bi) {
            early = ai;
            late = bi;
        } else if (bi < ai) {
            early = bi;
            late = ai;
        } else {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.blockContents.subList(early, late));
    }

    public void shrinkUsing(DoubleExpression animate) {
        this.canvas.snapshot(null, null);
        Rectangle clipRect = new Rectangle();
        clipRect.widthProperty().bind((ObservableValue)this.canvas.widthProperty());
        clipRect.heightProperty().bind((ObservableValue)this.canvas.maxHeightProperty());
        this.canvas.setClip((Node)clipRect);
        this.canvas.maxHeightProperty().bind((ObservableValue)animate.multiply(this.getHeight()));
        this.canvas.prefHeightProperty().bind((ObservableValue)this.canvas.maxHeightProperty());
        PerspectiveTransform pt = new PerspectiveTransform();
        pt.setLlx(0.0);
        pt.setUlx(0.0);
        pt.setLrx(this.canvas.getWidth());
        pt.setUrx(this.canvas.getWidth());
        pt.setUly(0.0);
        pt.setUry(0.0);
        pt.llyProperty().bind((ObservableValue)this.canvas.maxHeightProperty());
        pt.lryProperty().bind((ObservableValue)this.canvas.maxHeightProperty());
        this.canvas.setEffect((Effect)pt);
    }

    public void growUsing(DoubleExpression animate) {
        double calcHeight = this.blockContents.stream().mapToDouble(f -> f.getRegion().getHeight()).sum();
        calcHeight += this.cursors.stream().mapToDouble(f -> f.getNode().getHeight()).sum();
        this.canvas.maxHeightProperty().bind((ObservableValue)animate.multiply(calcHeight += (double)Math.max(0, this.blockContents.size() - 1) * this.canvas.spacingProperty().get()));
        animate.addListener((a, b, newVal) -> {
            if (newVal.doubleValue() >= 0.99) {
                this.canvas.maxHeightProperty().unbind();
                this.canvas.prefHeightProperty().unbind();
                this.canvas.setPrefHeight(-1.0);
                this.canvas.setMaxHeight(Double.MAX_VALUE);
                this.canvas.setClip(null);
                this.canvas.setEffect(null);
            }
        });
    }

    public DoubleExpression widthProperty() {
        return this.canvas.widthProperty();
    }

    public FrameCanvas(InteractionManager editor, CanvasParent parent, String stylePrefix) {
        JavaFXUtil.addStyleClass((Styleable)this.previewOpeningCurly, "preview-curly");
        JavaFXUtil.addStyleClass((Styleable)this.previewClosingCurly, "preview-curly");
        this.parentBlock = parent;
        this.canvas.getStyleClass().addAll((Object[])new String[]{"frame-canvas", stylePrefix + "frame-canvas"});
        JavaFXUtil.setPseudoclass("bj-empty", true, new Node[]{this.canvas});
        this.blockContents.addListener(c -> {
            boolean empty = this.blockContents.size() == 0;
            JavaFXUtil.setPseudoclass("bj-empty", empty, new Node[]{this.canvas});
            JavaFXUtil.setPseudoclass("bj-non-empty", !empty, new Node[]{this.canvas});
            parent.modifiedCanvasContent();
        });
        this.canvas.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                if (event.getGestureSource() != this && event.getDragboard().hasString()) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                }
                event.consume();
            }
        });
        this.canvas.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.isStillSincePress()) {
                editor.clickNearestCursor(e.getSceneX(), e.getSceneY(), e.isShiftDown());
                e.consume();
            }
        });
        FrameCursor topCursor = editor.createCursor(this);
        this.cursors.add(topCursor);
        this.canvas.getChildren().add(0, (Object)topCursor.getNode());
        VBox topSpecial = new VBox();
        this.specials.add(topSpecial);
        this.canvas.getChildren().add(1, (Object)topSpecial);
        this.editorFrm = editor;
    }

    public void emptyTo(FrameCanvas targetCanvas, Frame after) {
        List<Frame> allBlocks = this.getBlocksSubtype(Frame.class);
        for (int i = allBlocks.size() - 1; i >= 0; --i) {
            targetCanvas.insertBlockAfter(allBlocks.get(i), targetCanvas.getCursorAfter(after));
        }
    }

    public void moveContentsTo(FrameCanvas targetCanvas) {
        this.getBlocksSubtype(Frame.class).forEach(b -> {
            this.removeBlock((Frame)b);
            targetCanvas.insertBlockAfter((Frame)b, targetCanvas.getLastCursor());
        });
    }

    public void focusTopCursor() {
        FrameCursor firstCursor = this.getFirstCursor();
        if (firstCursor == null) {
            firstCursor = this.getParent().getCursorAfter(this);
        }
        firstCursor.requestFocus();
    }

    public boolean focusBottomCursor() {
        FrameCursor c = this.getLastCursor();
        if (c != null) {
            c.requestFocus();
            return true;
        }
        return false;
    }

    public void cleanup() {
        this.getBlockContents().forEach(f -> f.cleanup());
    }

    public Stream<HeaderItem> getHeaderItems() {
        return this.getBlocksSubtype(Frame.class).stream().flatMap(Frame::getHeaderItems);
    }

    public void setAnimateLeftMarginScale(boolean animateLeftMarginScale) {
        this.animateLeftMarginScale = animateLeftMarginScale;
    }

    public void setTopOutsideBorderBackgroundPadding(Optional<Double> height) {
        if (height.isPresent()) {
            this.canvas.setStyle("-bj-border-insets: " + -height.get().doubleValue() + " 0 0 0;");
        } else {
            this.canvas.setStyle("");
        }
    }

    public void previewCurly(boolean on, boolean affectOpen, boolean affectClose, double sceneX, DoubleExpression openingYAdjust, SharedTransition animate) {
        if (on) {
            this.canvas.addSpace(animate);
            ReadOnlyDoubleWrapper xOffset = new ReadOnlyDoubleWrapper(sceneX - this.canvas.localToScene(this.canvas.getBoundsInLocal()).getMinX());
            if (affectOpen) {
                this.editorFrm.getCodeOverlayPane().addOverlay((Node)this.previewOpeningCurly, (Node)this.canvas, (DoubleExpression)xOffset, openingYAdjust);
                this.previewOpeningCurly.growToFullHeightWith(animate, true);
            }
            if (affectClose) {
                this.editorFrm.getCodeOverlayPane().addOverlay((Node)this.previewClosingCurly, (Node)this.canvas, (DoubleExpression)xOffset, (DoubleExpression)this.canvas.heightProperty().subtract(18.0));
                this.previewClosingCurly.growToFullHeightWith(animate, true);
            }
        } else {
            this.canvas.removeSpace(animate);
            if (affectOpen) {
                this.previewOpeningCurly.shrinkToNothingWith(animate, true);
            }
            if (affectClose) {
                this.previewClosingCurly.shrinkToNothingWith(animate, true);
            }
            animate.addOnStopped(() -> {
                if (affectOpen) {
                    this.editorFrm.getCodeOverlayPane().removeOverlay((Node)this.previewOpeningCurly);
                }
                if (affectClose) {
                    this.editorFrm.getCodeOverlayPane().removeOverlay((Node)this.previewClosingCurly);
                }
            });
        }
    }

    public void previewCurly(boolean on, double sceneX, DoubleExpression openingYAdjust, SharedTransition animate) {
        this.previewCurly(on, true, true, sceneX, openingYAdjust, animate);
    }

    public List<FrameCursor> getCursors() {
        return this.cursors;
    }

    public void clear() {
        while (this.blockContents.size() > 0) {
            this.removeBlock((Frame)this.blockContents.get(0));
        }
    }

    public void setLastInMulti(boolean last) {
        JavaFXUtil.setPseudoclass("bj-last-canvas", last, new Node[]{this.canvas});
    }

    public SimpleBooleanProperty getShowingProperty() {
        return this.showingProperty;
    }

    public boolean isAlmostBlank() {
        return this.blockContents.stream().allMatch(f -> f instanceof BlankFrame);
    }

    public double getBottomMargin() {
        return this.canvas.getBottomMargin();
    }

    public DoubleExpression leftMargin() {
        return this.canvas.leftMarginProperty();
    }

    public DoubleExpression rightMargin() {
        return this.canvas.rightMarginProperty();
    }

    public void setPseudoclass(String name, boolean on) {
        JavaFXUtil.setPseudoclass(name, on, new Node[]{this.canvas});
    }

    public Bounds getContentSceneBounds() {
        return this.canvas.getContentSceneBounds();
    }

    @Override
    public Optional<FrameCanvas> getCanvas() {
        return Optional.of(this);
    }

    @Override
    public Stream<HeaderItem> getHeaderItemsDeep() {
        return this.getHeaderItems();
    }

    @Override
    public Stream<HeaderItem> getHeaderItemsDirect() {
        return Stream.empty();
    }

    @Override
    public boolean focusBottomEndFromNext() {
        return this.focusBottomCursor();
    }

    @Override
    public boolean focusLeftEndFromPrev() {
        this.focusTopCursor();
        return true;
    }

    @Override
    public boolean focusRightEndFromNext() {
        return this.focusBottomCursor();
    }

    @Override
    public boolean focusTopEndFromPrev() {
        this.focusTopCursor();
        return true;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animation) {
        this.canvas.animateColorsToPseudoClass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, animation);
        if (this.animateLeftMarginScale) {
            if (newView == Frame.View.JAVA_PREVIEW) {
                this.canvas.leftMarginScaleProperty().bind((ObservableValue)animation.getOppositeProgress());
                animation.addOnStopped(() -> ((DoubleProperty)this.canvas.leftMarginScaleProperty()).unbind());
            } else {
                this.canvas.leftMarginScaleProperty().bind((ObservableValue)animation.getProgress());
                animation.addOnStopped(() -> ((DoubleProperty)this.canvas.leftMarginScaleProperty()).unbind());
            }
        }
    }

    public void restore(List<? extends CodeElement> elements, InteractionManager editor) {
        HashMap<String, List> existingLookup = new HashMap<String, List>();
        ArrayList<String> existingList = new ArrayList<String>();
        for (CodeFrame f : this.getBlocksSubtype(CodeFrame.class)) {
            String xml = ((CodeElement)f.getCode()).toXML().toXML();
            existingLookup.merge(xml, new ArrayList<Frame>(Arrays.asList((Frame)((Object)f))), (a, b) -> {
                a.addAll(b);
                return a;
            });
            existingList.add(xml);
        }
        List newContentXML = elements.stream().map(el -> el.toXML().toXML()).collect(Collectors.toList());
        if (existingList.size() == newContentXML.size()) {
            int numDiff = 0;
            int lastDiff = -1;
            for (int i = 0; i < existingList.size(); ++i) {
                if (((String)existingList.get(i)).equals(newContentXML.get(i))) continue;
                ++numDiff;
                lastDiff = i;
            }
            if (numDiff == 0) {
                return;
            }
            if (numDiff == 1 && ((Frame)this.blockContents.get(lastDiff)).tryRestoreTo(elements.get(lastDiff))) {
                return;
            }
        }
        ArrayList newContents = new ArrayList(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            List fs = (List)existingLookup.get(newContentXML.get(i));
            if (fs != null && fs.size() > 0) {
                newContents.add(fs.remove(0));
                continue;
            }
            newContents.add(elements.get(i).createFrame(editor));
        }
        while (this.blockContents.size() > 0) {
            this.removeBlock((Frame)this.blockContents.get(this.blockContents.size() - 1));
        }
        for (Frame f : newContents) {
            this.insertBlockAfter(f, this.getLastCursor());
        }
    }

    public double getCurlyBracketHeight() {
        return this.canvas.getCurlyBracketHeight();
    }
}

