/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.errors.ErrorShower;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.FrameHelper;
import bluej.stride.generic.CursorFinder;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameEffects;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.operations.DeleteFrameOperation;
import bluej.stride.operations.DisableFrameOperation;
import bluej.stride.operations.EnableFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.BetterVBox;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class Frame
implements CursorFinder,
FocusParent<FrameContentItem>,
ErrorShower {
    private static int FRAME_ENABLE_PREVIEW_NO_PREVIEW = 0;
    private static int FRAME_ENABLE_PREVIEW_ENABLED = 1;
    private static int FRAME_ENABLE_PREVIEW_DISABLED = 2;
    protected final ObservableList<FrameContentItem> contents = FXCollections.observableArrayList();
    protected final FrameContentRow header;
    protected final SlotLabel headerCaptionLabel;
    protected final BooleanProperty frameEnabledProperty = new SimpleBooleanProperty(true);
    private final BetterVBox frameContents;
    private final BooleanProperty disabledRoot = new SimpleBooleanProperty(true);
    private final IntegerProperty framePreviewEnableProperty = new SimpleIntegerProperty(0);
    private final BooleanProperty frameDragSourceProperty = new SimpleBooleanProperty(false);
    private final InteractionManager editor;
    private final BooleanProperty fresh = new SimpleBooleanProperty(false);
    private final ObservableList<CodeError> allFrameErrors = FXCollections.observableArrayList();
    private final ObjectProperty<CodeError> shownError = new SimpleObjectProperty(null);
    private FrameCanvas parentCanvas;
    private boolean alwaysBeenBlank = true;

    public Frame(InteractionManager editor, String caption, String stylePrefix) {
        this.frameContents = new BetterVBox(200.0){

            @Override
            public double getBottomMarginFor(Node n) {
                return Frame.this.getBottomMarginFor(n);
            }

            @Override
            public double getLeftMarginFor(Node n) {
                return Frame.this.getLeftMarginFor(n);
            }

            @Override
            public double getRightMarginFor(Node n) {
                return Frame.this.getRightMarginFor(n);
            }
        };
        this.frameContents.getStyleClass().addAll((Object[])new String[]{"frame", stylePrefix + "frame"});
        this.frameEnabledProperty.addListener((a, b, enabled) -> {
            this.getEditableSlotsDirect().forEach(e -> e.setEditable((boolean)enabled));
            editor.modifiedFrame(this);
        });
        this.frameContents.effectProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.disabledRoot.and((ObservableBooleanValue)this.frameEnabledProperty.not().and((ObservableBooleanValue)this.framePreviewEnableProperty.isEqualTo(FRAME_ENABLE_PREVIEW_NO_PREVIEW)).or((ObservableBooleanValue)this.framePreviewEnableProperty.isEqualTo(FRAME_ENABLE_PREVIEW_DISABLED)))).then((ObservableObjectValue)new When((ObservableBooleanValue)this.frameDragSourceProperty).then((Object)FrameEffects.getDragSourceAndDisabledEffect()).otherwise((Object)FrameEffects.getDisabledEffect())).otherwise((ObservableObjectValue)new When((ObservableBooleanValue)this.frameDragSourceProperty).then((Object)FrameEffects.getDragSourceEffect()).otherwise((Object)null)));
        if (editor != null) {
            editor.setupFrame(this);
        }
        this.editor = editor;
        this.headerCaptionLabel = caption == null ? null : new SlotLabel(caption, "caption", stylePrefix + "caption");
        this.header = this.makeHeader(stylePrefix);
        this.contents.addListener(c -> this.frameContents.getChildren().setAll(this.calculateContents(Utility.mapList(this.contents, FrameContentItem::getNode))));
        this.contents.setAll((Object[])new FrameContentItem[]{this.header});
        this.setHeaderRow(new HeaderItem[0]);
        this.getNode().focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.getCursorAfter().requestFocus();
            }
        });
        this.allFrameErrors.addListener(c -> {
            this.shownError.set(this.allFrameErrors.stream().min(CodeError::compareErrors).orElse(null));
            FXRunnable update = () -> JavaFXUtil.setPseudoclass("bj-frame-error", this.shownError.get() != null, new Node[]{this.frameContents});
            if (this.isFresh()) {
                this.onNonFresh(update);
            } else {
                update.run();
            }
        });
    }

    private static void blitImage(WritableImage dest, int xOffset, int yOffset, Image src) {
        dest.getPixelWriter().setPixels(xOffset, yOffset, (int)Math.ceil(src.getWidth()), (int)Math.ceil(src.getHeight()), src.getPixelReader(), 0, 0);
    }

    public static Image takeShot(List<Frame> frames, Color border) {
        int xOffset;
        int yOffset;
        int y;
        WritableImage collated;
        int totalHeight = 0;
        int maxWidth = 0;
        for (Frame f : frames) {
            Bounds b = f.getNode().getBoundsInParent();
            totalHeight += (int)Math.ceil(b.getHeight()) + 0;
            maxWidth = Math.max(maxWidth, (int)Math.ceil(b.getWidth()));
        }
        totalHeight += 0;
        if (border != null) {
            collated = new WritableImage(maxWidth + 2, totalHeight + 2);
            for (int x = 0; x < maxWidth + 2; ++x) {
                collated.getPixelWriter().setColor(x, 0, border);
                collated.getPixelWriter().setColor(x, totalHeight + 1, border);
            }
            for (y = 0; y < totalHeight + 2; ++y) {
                collated.getPixelWriter().setColor(0, y, border);
                collated.getPixelWriter().setColor(maxWidth + 1, y, border);
            }
            yOffset = 1;
            xOffset = 1;
        } else {
            if (maxWidth * totalHeight < 1) {
                return null;
            }
            collated = new WritableImage(maxWidth, totalHeight);
            yOffset = 0;
            xOffset = 0;
        }
        y = 0;
        for (Frame f : frames) {
            Bounds b = f.getNode().getBoundsInParent();
            WritableImage image = new WritableImage((int)Math.ceil(b.getWidth()), (int)Math.ceil(b.getHeight()));
            SnapshotParameters p = new SnapshotParameters();
            p.setFill((Paint)Color.TRANSPARENT);
            boolean dr = f.disabledRoot.get();
            f.disabledRoot.set(true);
            JavaFXUtil.setPseudoclass("bj-hide-caret", true, f.getNode());
            f.getNode().snapshot(p, image);
            f.disabledRoot.set(dr);
            JavaFXUtil.setPseudoclass("bj-hide-caret", false, f.getNode());
            Frame.blitImage(collated, xOffset, yOffset + y, (Image)image);
            y += (int)Math.ceil(b.getHeight()) + 0;
        }
        return collated;
    }

    protected static Stream<RecallableFocus> getFocusablesInclContained(Frame f) {
        return Utility.concat(f.getEditableSlotsDirect(), f.getPersistentCanvases().flatMap(c -> c.getFocusableCursors().stream()), f.getPersistentCanvases().flatMap(c -> c.getBlockContents().stream()).flatMap(Frame::getFocusablesInclContained));
    }

    protected double getRightMarginFor(Node n) {
        return n == this.header.getNode() ? 1.0 : 0.0;
    }

    protected double getLeftMarginFor(Node n) {
        return n == this.header.getNode() ? 1.0 : 0.0;
    }

    protected double getBottomMarginFor(Node n) {
        return 0.0;
    }

    protected FrameContentRow makeHeader(String stylePrefix) {
        return new FrameContentRow(this, stylePrefix);
    }

    protected List<? extends Node> calculateContents(List<Node> normalContent) {
        return normalContent;
    }

    public List<FrameOperation> getContextOperations(InteractionManager editor) {
        return this.getStandardOperations(editor);
    }

    public void replaceWith(Frame replacement) {
        this.getParentCanvas().replaceBlock(this, replacement);
    }

    protected void addUnmanagedToBlockContainer(Node n) {
        if (n.isManaged()) {
            throw new IllegalArgumentException("Attempting to add managed node as unmanaged");
        }
        this.frameContents.getChildren().add((Object)n);
    }

    public final FrameCursor getFirstInternalCursor() {
        return this.getCanvases().map(FrameCanvas::getFirstCursor).findFirst().orElse(null);
    }

    public final FrameCursor getLastInternalCursor() {
        return Utility.findLast(this.getCanvases().map(FrameCanvas::getLastCursor)).orElse(null);
    }

    public FrameCanvas getParentCanvas() {
        return this.parentCanvas;
    }

    public void setParentCanvas(FrameCanvas parentCanvas) {
        FrameCanvas oldCanvas = this.parentCanvas;
        this.parentCanvas = parentCanvas;
        if (oldCanvas != null) {
            oldCanvas.getBlockContents().forEach(f -> f.updateAppearance(f.getParentCanvas()));
        }
        if (parentCanvas != null) {
            parentCanvas.getBlockContents().forEach(f -> f.updateAppearance(f.getParentCanvas()));
            Utility.iterableStream(this.getAllFrames()).forEach(f -> f.updateAppearance(f.getParentCanvas()));
        }
    }

    public final FrameCursor getCursorAfter() {
        return this.parentCanvas == null ? null : this.parentCanvas.getCursorAfter(this);
    }

    public final FrameCursor getCursorBefore() {
        return this.parentCanvas == null ? null : this.parentCanvas.getCursorBefore(this);
    }

    protected final void addStyleClass(String styleClass) {
        JavaFXUtil.addStyleClass((Styleable)this.frameContents, styleClass);
    }

    protected final void removeStyleClass(String styleClass) {
        JavaFXUtil.removeStyleClass((Styleable)this.frameContents, styleClass);
    }

    public final Node getNode() {
        return this.frameContents;
    }

    protected final Region getRegion() {
        return this.frameContents;
    }

    public void updateAppearance(FrameCanvas parentCanvas) {
        this.disabledRoot.set(this.canHaveEnabledState(true));
    }

    public void setDragSourceEffect(boolean on) {
        this.frameDragSourceProperty.set(on);
    }

    private List<FrameOperation> getStandardOperations(InteractionManager editor) {
        ArrayList<FrameOperation> ops = new ArrayList<FrameOperation>();
        ops.addAll(this.getCutCopyPasteOperations(editor));
        ops.add(this.isFrameEnabled() ? new DisableFrameOperation(editor) : new EnableFrameOperation(editor));
        ops.add(new DeleteFrameOperation(editor));
        return ops;
    }

    protected abstract List<FrameOperation> getCutCopyPasteOperations(InteractionManager var1);

    public boolean isFrameEnabled() {
        return this.frameEnabledProperty.get();
    }

    public void setFrameEnabled(boolean enabled) {
        if (!this.canHaveEnabledState(enabled)) {
            return;
        }
        this.frameEnabledProperty.set(enabled);
        if (this instanceof CodeFrame) {
            ((CodeFrame)((Object)this)).setElementEnabled(enabled);
        }
        if (!enabled) {
            this.flagErrorsAsOld();
            this.removeOldErrors();
        }
        this.setChildrenEnabled(enabled);
        this.updateAppearance(this.getParentCanvas());
    }

    public boolean canHaveEnabledState(boolean enabled) {
        Frame parent;
        FrameCanvas canvas;
        if (enabled && (canvas = this.getParentCanvas()) != null && (parent = canvas.getParent().getFrame()) != null) {
            return parent.isFrameEnabled() && parent.canHaveEnabledState(enabled);
        }
        return true;
    }

    public void setFrameEnablePreview(Optional<Boolean> previewingEnable) {
        this.framePreviewEnableProperty.set(previewingEnable.isPresent() ? (previewingEnable.get().booleanValue() ? FRAME_ENABLE_PREVIEW_ENABLED : FRAME_ENABLE_PREVIEW_DISABLED) : FRAME_ENABLE_PREVIEW_NO_PREVIEW);
    }

    protected final void setChildrenEnabled(boolean enabled) {
        this.getCanvases().forEach(canvas -> canvas.getBlocksSubtype(Frame.class).forEach(b -> b.setFrameEnabled(enabled)));
    }

    public final void flagErrorsAsOld() {
        this.allFrameErrors.forEach(CodeError::flagAsOld);
        this.getEditableSlots().forEach(EditableSlot::flagErrorsAsOld);
        this.getCanvases().forEach(FrameHelper::flagErrorsAsOld);
    }

    public final void removeOldErrors() {
        this.allFrameErrors.removeIf(CodeError::isFlaggedAsOld);
        this.getEditableSlots().forEach(EditableSlot::removeOldErrors);
        this.getCanvases().forEach(FrameHelper::removeOldErrors);
    }

    public final void cleanup() {
        this.getEditableSlots().forEach(EditableSlot::cleanup);
        this.getCanvases().forEach(FrameCanvas::cleanup);
        this.cleanupFrame();
    }

    protected void cleanupFrame() {
    }

    public final Stream<FrameCanvas> getCanvases() {
        return this.contents.stream().map(FrameContentItem::getCanvas).flatMap(Utility::streamOptional);
    }

    public Stream<FrameCanvas> getPersistentCanvases() {
        return this.getCanvases();
    }

    public boolean isCollapsible() {
        return false;
    }

    public void setCollapsed(boolean collapse) {
    }

    public void checkForEmptySlot() {
    }

    public List<ExtensionDescription> getAvailableExtensions() {
        return Collections.emptyList();
    }

    public final boolean notifyExtensionKey(char c, RecallableFocus rc) {
        return this.notifyKey(c, rc, this.getAvailableExtensions(), "extension");
    }

    protected List<ExtensionDescription> getAvailablePrefixes() {
        return Arrays.asList(new ExtensionDescription('\\', "Disable/Enable frames", () -> {
            if (this.canHaveEnabledState(this.isFrameEnabled())) {
                this.setFrameEnabled(!this.isFrameEnabled());
            }
        }, false, false));
    }

    public final boolean notifyPrefixKey(char c, RecallableFocus rc) {
        return this.notifyKey(c, rc, this.getAvailablePrefixes(), "prefix");
    }

    private boolean notifyKey(char c, RecallableFocus rc, List<ExtensionDescription> extensions, String label) {
        List candidates = extensions.stream().filter(e -> e.getShortcutKey() == c).collect(Collectors.toList());
        if (candidates.size() == 0) {
            return false;
        }
        if (candidates.size() > 1) {
            throw new IllegalStateException("Ambiguous " + label + " for: " + c);
        }
        if (((ExtensionDescription)candidates.get(0)).isAvailable()) {
            this.editor.beginRecordingState(rc);
            ((ExtensionDescription)candidates.get(0)).activate();
            this.editor.endRecordingState(rc);
            return true;
        }
        return false;
    }

    public boolean canDrag() {
        return true;
    }

    public final boolean leftClicked(double sceneX, double sceneY, boolean shiftDown) {
        this.editor.clickNearestCursor(sceneX, sceneY, shiftDown);
        return true;
    }

    public boolean focusWhenJustAdded() {
        EditableSlot s = this.getEditableSlotsDirect().findFirst().orElse(null);
        if (s != null) {
            s.requestFocus();
            return true;
        }
        return false;
    }

    protected void addTopRight(Node n) {
    }

    protected final FrameContentRow getHeaderRow() {
        return this.header;
    }

    protected void setHeaderRow(HeaderItem ... headerItems) {
        if (this.headerCaptionLabel == null) {
            this.header.setHeaderItems(Arrays.asList(headerItems));
        } else {
            ArrayList<HeaderItem> items = new ArrayList<HeaderItem>();
            items.add(this.headerCaptionLabel);
            items.addAll(Arrays.asList(headerItems));
            this.header.setHeaderItems(items);
        }
    }

    public final boolean focusFrameEnd(boolean up) {
        if (this.isFrameEnabled()) {
            FrameContentItem last = (FrameContentItem)this.contents.get(this.contents.size() - 1);
            return up ? last.focusBottomEndFromNext() : last.focusRightEndFromNext();
        }
        return false;
    }

    public final boolean focusFrameStart() {
        if (this.isFrameEnabled()) {
            FrameContentItem first = (FrameContentItem)this.contents.get(0);
            return first.focusLeftEndFromPrev();
        }
        return false;
    }

    public InteractionManager getEditor() {
        return this.editor;
    }

    public void show(ShowReason reason) {
        switch (reason) {
            case EXCEPTION: {
                Platform.runLater(() -> {
                    JavaFXUtil.setPseudoclass("bj-stack-highlight", true, this.getNode());
                    this.getParentCanvas().getCursorBefore(this).requestFocus();
                    this.editor.scrollTo(this.getNode(), -50.0);
                    this.editor.registerStackHighlight(this);
                });
                break;
            }
            case LINK_TARGET: {
                Platform.runLater(() -> {
                    this.editor.scrollTo(this.getNode(), -50.0);
                    this.focusName();
                });
            }
        }
    }

    public void focusName() {
        this.focusWhenJustAdded();
    }

    public void removeStackHighlight() {
        Platform.runLater(() -> JavaFXUtil.setPseudoclass("bj-stack-highlight", false, this.getNode()));
    }

    public final Stream<HeaderItem> getHeaderItems() {
        return this.contents.stream().flatMap(FrameContentItem::getHeaderItemsDeep);
    }

    public final Stream<EditableSlot> getEditableSlots() {
        return this.getHeaderItems().map(HeaderItem::asEditable).filter(x -> x != null);
    }

    public final Stream<EditableSlot> getEditableSlotsDirect() {
        return this.contents.stream().flatMap(FrameContentItem::getHeaderItemsDirect).map(HeaderItem::asEditable).filter(x -> x != null);
    }

    @Override
    public void focusUp(FrameContentItem src, boolean toEnd) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == 0) {
            this.focusPrevTarget();
        } else if (!((FrameContentItem)this.contents.get(index - 1)).focusBottomEndFromNext()) {
            this.focusUp((FrameContentItem)this.contents.get(index - 1), toEnd);
        }
    }

    @Override
    public void focusDown(FrameContentItem src) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == this.contents.size() - 1) {
            if (this.getCursorAfter() != null) {
                this.getCursorAfter().requestFocus();
            }
        } else if (!((FrameContentItem)this.contents.get(index + 1)).focusTopEndFromPrev()) {
            this.focusDown((FrameContentItem)this.contents.get(index + 1));
        }
    }

    @Override
    public void focusEnter(FrameContentItem src) {
        this.focusDown(src);
    }

    @Override
    public void focusLeft(FrameContentItem src) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == 0) {
            this.focusPrevTarget();
        } else if (!((FrameContentItem)this.contents.get(index - 1)).focusRightEndFromNext()) {
            this.focusLeft((FrameContentItem)this.contents.get(index - 1));
        }
    }

    @Override
    public void focusRight(FrameContentItem src) {
        int index = this.contents.indexOf((Object)src);
        if (index == -1) {
            throw new IllegalStateException("Item not contained in frame");
        }
        if (index == this.contents.size() - 1) {
            if (this.getCursorAfter() != null) {
                this.getCursorAfter().requestFocus();
            }
        } else if (!((FrameContentItem)this.contents.get(index + 1)).focusLeftEndFromPrev()) {
            this.focusRight((FrameContentItem)this.contents.get(index + 1));
        }
    }

    protected void focusPrevTarget() {
        FrameCursor cursorBefore = this.getCursorBefore();
        if (cursorBefore != null) {
            cursorBefore.requestFocus();
        }
    }

    public boolean backspaceAtStart(FrameContentItem srcRow, HeaderItem src) {
        if (this.contents.size() > 0 && (src == this.contents.get(0) || srcRow == this.contents.get(0)) && this.isAlmostBlank()) {
            FrameCanvas parentCanvas = this.getParentCanvas();
            FrameCursor cursorBefore = this.getCursorBefore();
            parentCanvas.removeBlock(this);
            cursorBefore.requestFocus();
            return true;
        }
        return false;
    }

    public boolean deleteAtEnd(FrameContentItem srcRow, HeaderItem src) {
        return false;
    }

    public void pullUpContents() {
        this.editor.modifiedFrame(this);
        this.getCursorBefore().insertFramesAfter(Utility.concat(this.getCanvases().map(canvas -> {
            ArrayList<Frame> contents = new ArrayList<Frame>((Collection<Frame>)canvas.getBlockContents());
            contents.forEach(c -> canvas.removeBlock((Frame)c));
            return contents;
        }).collect(Utility.intersperse(() -> Arrays.asList(new BlankFrame(this.editor)))).toArray(new List[0])));
    }

    public final Stream<Frame> getAllFrames() {
        return Stream.concat(Stream.of(this), this.getCanvases().flatMap(c -> c.getBlocksSubtype(Frame.class).stream()).flatMap(Frame::getAllFrames));
    }

    public void markFresh() {
        this.fresh.set(true);
    }

    public void markNonFresh() {
        this.fresh.set(false);
    }

    public boolean isFresh() {
        return this.fresh.get();
    }

    public void onNonFresh(FXRunnable action) {
        if (!this.isFresh()) {
            throw new IllegalStateException("Calling onNonFresh when we are already non-fresh; state cannot go back to fresh");
        }
        JavaFXUtil.addSelfRemovingListener(this.fresh, b -> action.run());
    }

    public ObservableBooleanValue freshProperty() {
        return this.fresh;
    }

    public List<String> getDeclaredVariablesAfter() {
        return Collections.emptyList();
    }

    public List<String> getDeclaredVariablesWithin(FrameCanvas c) {
        return Collections.emptyList();
    }

    public void setView(View oldView, View newView, SharedTransition animation) {
        this.setViewNoOverride(oldView, newView, animation);
    }

    protected final void setViewNoOverride(View oldView, View newView, SharedTransition animation) {
        Background start = this.frameContents.getBackground();
        Border startBorder = this.frameContents.getBorder();
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == View.JAVA_PREVIEW, new Node[]{this.frameContents});
        this.frameContents.applyCss();
        Background end = this.frameContents.getBackground();
        Border endBorder = this.frameContents.getBorder();
        boolean animatingBackground = false;
        if (start != null && end != null && start.getImages().isEmpty() && end.getImages().isEmpty() && start.getFills().size() == 1 && end.getFills().size() == 1) {
            BackgroundFill startFill = (BackgroundFill)start.getFills().get(0);
            BackgroundFill endFill = (BackgroundFill)end.getFills().get(0);
            if (startFill.getFill() instanceof Color && endFill.getFill() instanceof Color && !startFill.getFill().equals(endFill.getFill())) {
                Color startColor = (Color)startFill.getFill();
                Color endColor = (Color)endFill.getFill();
                animatingBackground = true;
                JavaFXUtil.addChangeListener(animation.getProgress(), t -> {
                    Color c = startColor.interpolate(endColor, t.doubleValue());
                    this.frameContents.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)c, endFill.getRadii(), endFill.getInsets())}));
                });
            }
        }
        boolean animatingBorder = false;
        if (startBorder != null && endBorder != null && startBorder.getImages().isEmpty() && endBorder.getImages().isEmpty() && startBorder.getStrokes().size() == 1 && endBorder.getStrokes().size() == 1) {
            BorderStroke startStroke = (BorderStroke)startBorder.getStrokes().get(0);
            BorderStroke endStroke = (BorderStroke)endBorder.getStrokes().get(0);
            if (startStroke.isStrokeUniform() && endStroke.isStrokeUniform()) {
                Paint startStrokePaint = startStroke.getTopStroke();
                Paint endStrokePaint = endStroke.getTopStroke();
                if (startStrokePaint instanceof Color && endStrokePaint instanceof Color && !startStrokePaint.equals(endStrokePaint)) {
                    Color startColor = (Color)startStrokePaint;
                    Color endColor = (Color)endStrokePaint;
                    animatingBorder = true;
                    JavaFXUtil.addChangeListener(animation.getProgress(), t -> {
                        Color c = startColor.interpolate(endColor, t.doubleValue());
                        this.frameContents.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)c, startStroke.getTopStyle(), startStroke.getRadii(), startStroke.getWidths())}));
                    });
                }
            }
        }
        if (animatingBackground || animatingBorder) {
            animation.addOnStopped(() -> this.frameContents.applyCss());
        }
        if (!this.isFrameEnabled()) {
            if (newView == View.JAVA_PREVIEW) {
                this.frameContents.opacityProperty().bind((ObservableValue)animation.getOppositeProgress());
                animation.addOnStopped(() -> {
                    this.frameContents.opacityProperty().unbind();
                    this.frameContents.setVisible(false);
                });
            } else {
                this.frameContents.setVisible(true);
                this.frameContents.opacityProperty().bind((ObservableValue)animation.getProgress());
                animation.addOnStopped(() -> this.frameContents.opacityProperty().unbind());
            }
        }
        this.contents.forEach(i -> i.setView(oldView, newView, animation));
    }

    public Stream<CodeError> getCurrentErrors() {
        return this.shownError.get() == null ? Stream.empty() : Stream.of(this.shownError.get());
    }

    public void addError(CodeError err) {
        this.allFrameErrors.add((Object)err);
        err.bindFresh((ObservableBooleanValue)this.fresh);
    }

    @Override
    public void focusAndPositionAtError(CodeError err) {
        this.getCursorBefore().requestFocus();
    }

    @Override
    public Node getRelevantNodeForError(CodeError err) {
        if (this.getCursorBefore() == null) {
            return null;
        }
        return this.getCursorBefore().getNode();
    }

    public void compiled() {
    }

    public EditableSlot getErrorShowRedirect() {
        return this.getEditableSlotsDirect().findFirst().orElse(null);
    }

    public boolean isAlmostBlank() {
        return this.getEditableSlotsDirect().allMatch(EditableSlot::isAlmostBlank) && this.getCanvases().allMatch(FrameCanvas::isAlmostBlank);
    }

    public void trackBlank() {
        this.alwaysBeenBlank &= this.isAlmostBlank();
    }

    public void escape(FrameContentItem srcRow, HeaderItem src) {
        if (this.alwaysBeenBlank && this.isFresh()) {
            FrameCanvas parentCanvas = this.getParentCanvas();
            FrameCursor cursorBefore = this.getCursorBefore();
            parentCanvas.removeBlock(this);
            cursorBefore.requestFocus();
        }
    }

    protected Pane getSidebarContainer() {
        return this.frameContents;
    }

    @Override
    public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
        List canvases = this.getCanvases().filter(canvas -> canvas.getShowingProperty().get()).collect(Collectors.toList());
        FrameCanvas lastCanvas = (FrameCanvas)canvases.get(canvases.size() - 1);
        double sceneMaxY = lastCanvas.getSceneBounds().getMaxY() + lastCanvas.getBottomMargin();
        Bounds headerRowBounds = this.getHeaderRow().getSceneBounds();
        if (prevCursor != null && sceneY <= (headerRowBounds.getMinY() + headerRowBounds.getMaxY()) / 2.0) {
            return prevCursor;
        }
        for (int canvasIndex = 0; canvasIndex < canvases.size(); ++canvasIndex) {
            Bounds canvasBounds = ((FrameCanvas)canvases.get(canvasIndex)).getSceneBounds();
            double nextY = canvasIndex == canvases.size() - 1 ? sceneMaxY : ((FrameCanvas)canvases.get(canvasIndex + 1)).getSceneBounds().getMinY();
            if (!(sceneY <= (canvasBounds.getMaxY() + nextY) / 2.0)) continue;
            boolean isClickOnMargin = sceneX >= headerRowBounds.getMinX() && sceneX < canvasBounds.getMinX() && !isDrag;
            return ((FrameCanvas)canvases.get(canvasIndex)).findClosestCursor(sceneX, sceneY, exclude, isDrag, canDescend && !isClickOnMargin);
        }
        if (nextCursor != null) {
            return nextCursor;
        }
        if (prevCursor != null) {
            return prevCursor;
        }
        return lastCanvas.findClosestCursor(sceneX, sceneY, exclude, isDrag, canDescend);
    }

    public double lowestCursorY() {
        FrameCanvas lastCanvas = Utility.findLast(this.getCanvases()).orElse(null);
        Bounds canvasBounds = lastCanvas.getSceneBounds();
        return canvasBounds.getMaxY() + lastCanvas.getBottomMargin();
    }

    public boolean tryRestoreTo(CodeElement codeElement) {
        return false;
    }

    public boolean isEffectiveFrame() {
        return true;
    }

    public static enum View {
        NORMAL,
        JAVA_PREVIEW,
        BIRDSEYE;

    }

    public static enum ShowReason {
        EXCEPTION,
        LINK_TARGET;

    }
}

