/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.InfixExpression;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.stream.Stream;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Label;

class Operator {
    private final Label l;
    private final StringProperty sourceProperty = new SimpleStringProperty();
    private final BooleanProperty showingJava = new SimpleBooleanProperty();
    private final StringProperty rangeJavaPreview = new SimpleStringProperty(", ");
    private Precedence precedence;

    public Operator(String op, InfixExpression parent) {
        this.sourceProperty.set((Object)op);
        this.l = new Label();
        JavaFXUtil.addStyleClass((Styleable)this.l, "expression-operator");
        this.l.setOnMousePressed(e -> {
            parent.moveTo(e.getSceneX(), e.getSceneY(), true);
            e.consume();
        });
        this.l.setOnMouseDragged(e -> {
            parent.selectTo(e.getSceneX(), e.getSceneY());
            e.consume();
        });
        this.l.setOnMouseReleased(e -> {
            parent.selected();
            e.consume();
        });
        this.l.setOnMouseMoved(e -> {
            if (e.isShortcutDown()) {
                parent.getSlot().getOverlay().hoverAtPos(-1);
            }
        });
        this.l.setOnMouseClicked(Event::consume);
        this.l.setOnDragDetected(Event::consume);
        this.l.textProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.showingJava).then((ObservableStringValue)new When((ObservableBooleanValue)this.sourceProperty.isEqualTo("<:")).then(" instanceof ").otherwise((ObservableStringValue)new When((ObservableBooleanValue)this.sourceProperty.isEqualTo("..")).then((ObservableStringValue)this.rangeJavaPreview).otherwise((ObservableStringValue)this.sourceProperty))).otherwise((ObservableStringValue)this.sourceProperty));
    }

    static boolean canBeUnary(String s) {
        if (s == null) {
            return false;
        }
        switch (s) {
            case "+": 
            case "-": 
            case "~": 
            case "!": 
            case "new ": {
                return true;
            }
        }
        return false;
    }

    static boolean isOperator(String s) {
        switch (s) {
            case "+": 
            case "-": 
            case "*": 
            case "/": 
            case "==": 
            case "!=": 
            case ">": 
            case ">=": 
            case "<=": 
            case "<": 
            case "%": 
            case "&": 
            case "&&": 
            case "|": 
            case "||": 
            case "^": 
            case "~": 
            case "!": 
            case ".": 
            case "..": 
            case "<:": 
            case ",": 
            case "<<": 
            case ">>": 
            case ">>>": 
            case "->": 
            case "::": {
                return true;
            }
        }
        return false;
    }

    static boolean beginsOperator(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    static int getOperatorPrecedence(String op, boolean unary) {
        int prec;
        switch (op) {
            case ",": {
                prec = 0;
                break;
            }
            case "..": {
                prec = 1;
                break;
            }
            case "||": {
                prec = 1;
                break;
            }
            case "&&": {
                prec = 2;
                break;
            }
            case "|": {
                prec = 3;
                break;
            }
            case "^": {
                prec = 4;
                break;
            }
            case "&": {
                prec = 5;
                break;
            }
            case "=": 
            case "==": 
            case "!=": {
                prec = 6;
                break;
            }
            case "<": 
            case ">": 
            case ">=": 
            case "<=": 
            case "<:": {
                prec = 7;
                break;
            }
            case "<<": 
            case ">>": 
            case ">>>": {
                prec = 8;
                break;
            }
            case "+": 
            case "-": {
                prec = unary ? 11 : 9;
                break;
            }
            case "*": 
            case "/": 
            case "%": {
                prec = 10;
                break;
            }
            case "~": 
            case "!": {
                prec = 12;
                break;
            }
            case "new ": {
                prec = 14;
                break;
            }
            case ".": {
                prec = 15;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operator: " + op);
            }
        }
        return prec;
    }

    static Precedence getPrecForLevel(int ourLevel) {
        if (ourLevel == 0) {
            return Precedence.HIGH;
        }
        if (ourLevel == 1) {
            return Precedence.MEDIUM;
        }
        return Precedence.LOW;
    }

    public String getCopyText() {
        return (String)this.sourceProperty.get();
    }

    public Node getNode() {
        return this.l;
    }

    public String get() {
        return (String)this.sourceProperty.get();
    }

    public void set(String s) {
        this.sourceProperty.set((Object)s);
    }

    public Object getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Precedence chosen) {
        for (Precedence p : Precedence.values()) {
            JavaFXUtil.setPseudoclass(p.getPseudoClass(), false, new Node[]{this.l});
        }
        JavaFXUtil.setPseudoclass(chosen.getPseudoClass(), true, new Node[]{this.l});
        this.precedence = chosen;
    }

    public Stream<TextOverlayPosition> getStartEndPositions(InfixExpression parent) {
        return Stream.of(TextOverlayPosition.nodeToOverlay((Node)this.l, 0.0, 0.0, this.l.getBaselineOffset(), this.l.getHeight()), TextOverlayPosition.nodeToOverlay((Node)this.l, this.l.getWidth(), 0.0, this.l.getBaselineOffset(), this.l.getHeight()));
    }

    public ObservableStringValue textProperty() {
        return this.sourceProperty;
    }

    public String getJavaCode() {
        if ("<:".equals(this.get())) {
            return " instanceof ";
        }
        if (this.get().equals(",")) {
            return ", ";
        }
        if (this.get().equals(".")) {
            return ".";
        }
        return " " + this.get() + " ";
    }

    public void setView(Frame.View view, SharedTransition animate) {
        if (view != Frame.View.JAVA_PREVIEW) {
            this.rangeJavaPreview.set((Object)", ");
        }
        this.showingJava.set(view == Frame.View.JAVA_PREVIEW);
        JavaFXUtil.setPseudoclass("bj-java-preview", view == Frame.View.JAVA_PREVIEW, new Node[]{this.l});
    }

    public void setJavaPreviewRangeOverride(String s) {
        this.rangeJavaPreview.set((Object)s);
    }

    static class OpPrec {
        int prec;
        int levels;

        OpPrec(int prec, int levels) {
            this.prec = prec;
            this.levels = levels;
        }
    }

    public static enum Precedence {
        DOT,
        HIGH,
        MEDIUM,
        LOW,
        NEW,
        COMMA;


        public String getPseudoClass() {
            switch (this) {
                case DOT: {
                    return "bj-op-dot";
                }
                case HIGH: {
                    return "bj-op-high";
                }
                case MEDIUM: {
                    return "bj-op-medium";
                }
                case LOW: {
                    return "bj-op-low";
                }
                case NEW: {
                    return "bj-op-new";
                }
                case COMMA: {
                    return "bj-op-comma";
                }
            }
            return null;
        }
    }
}

