/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.utility.Utility;
import java.util.Optional;

class CaretPos {
    public final int index;
    public final CaretPos subPos;

    public CaretPos(int index, CaretPos subPos) {
        this.index = index;
        this.subPos = subPos;
    }

    public String toString() {
        return "" + this.index + (this.subPos == null ? "" : "->" + this.subPos.toString());
    }

    public boolean before(CaretPos p) {
        if (this.index < p.index) {
            return true;
        }
        if (this.index > p.index) {
            return false;
        }
        if (this.subPos == null || p.subPos == null) {
            return false;
        }
        return this.subPos.before(p.subPos);
    }

    public boolean equals(Object o) {
        if (o instanceof CaretPos) {
            CaretPos pos = (CaretPos)o;
            return pos != null && this.index == pos.index && (this.subPos == null && pos.subPos == null || this.subPos != null && this.subPos.equals(pos.subPos));
        }
        return false;
    }

    public CaretPos append(CaretPos replacement) {
        if (this.subPos == null) {
            return new CaretPos(this.index, replacement);
        }
        return new CaretPos(this.index, this.subPos.append(replacement));
    }

    public Optional<Integer> getFollowing(CaretPos outer) {
        if (outer == null) {
            return Optional.of(this.index);
        }
        if (this.index == outer.index) {
            return this.subPos.getFollowing(outer.subPos);
        }
        return Optional.empty();
    }

    public CaretPos normalise() {
        if (this.subPos != null && this.subPos.index == -1) {
            return Utility.orNull(this.subPos.subPos, CaretPos::normalise);
        }
        if (this.subPos != null) {
            return new CaretPos(this.index, this.subPos.normalise());
        }
        return this;
    }

    public static boolean between(CaretPos start, CaretPos end, CaretPos p) {
        if (start == null && end == null) {
            return true;
        }
        if (p == null) {
            return false;
        }
        if (!(start != null && start.index > p.index || end != null && p.index > end.index)) {
            return CaretPos.between(start == null ? null : start.subPos, end == null ? null : end.subPos, p.subPos);
        }
        return false;
    }

    public CaretPos init() {
        if (this.subPos == null) {
            return null;
        }
        return new CaretPos(this.index, this.subPos.init());
    }
}

