/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.ExpressionSlotComponent;
import bluej.stride.framedjava.slots.ExpressionSlotField;
import bluej.stride.framedjava.slots.InfixExpression;
import bluej.stride.framedjava.slots.PosAndDist;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.ConcatListBinding;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;

class BracketedExpression
implements ExpressionSlotComponent {
    private final InfixExpression parent;
    private final InfixExpression content;
    private final ObservableList<Node> components = FXCollections.observableArrayList();
    private final char opening;
    private final char closing;
    private final StringExpression textProperty;
    private final Label openingLabel;
    private final Label closingLabel;

    public BracketedExpression(InteractionManager editor, InfixExpression parent, ExpressionSlot slot, char opening, String initialContent) {
        this.parent = parent;
        this.opening = opening;
        switch (opening) {
            case '(': {
                this.closing = (char)41;
                break;
            }
            case '[': {
                this.closing = (char)93;
                break;
            }
            case '{': {
                this.closing = (char)125;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised bracket: " + opening);
            }
        }
        this.content = new InfixExpression(editor, slot, initialContent, this, Character.valueOf(this.closing));
        this.openingLabel = ExpressionSlot.makeBracket("" + opening, true, this.content);
        this.closingLabel = ExpressionSlot.makeBracket("" + this.closing, false, this.content);
        ConcatListBinding.bind(this.components, FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new Node[]{this.openingLabel}), this.content.getComponents(), FXCollections.observableArrayList((Object[])new Node[]{this.closingLabel})}));
        this.textProperty = new ReadOnlyStringWrapper("" + opening).concat((Object)this.content.textProperty()).concat((Object)("" + this.closing));
    }

    @Override
    public void focusAtStart() {
        this.content.focusAtStart();
    }

    @Override
    public void focusAtEnd() {
        this.content.focusAtEnd();
    }

    @Override
    public Node focusAtPos(CaretPos caretPos) {
        return this.content.positionCaret(caretPos);
    }

    @Override
    public TextOverlayPosition calculateOverlayPos(CaretPos subPos) {
        return this.content.calculateOverlayPos(subPos);
    }

    @Override
    public PosAndDist getNearest(double sceneX, double sceneY, boolean allowDescend, boolean anchorInItem) {
        if (allowDescend) {
            return this.content.getNearest(sceneX, sceneY, true, Optional.empty());
        }
        return new PosAndDist();
    }

    @Override
    public CaretPos getSelectIntoPos(boolean atEnd) {
        return null;
    }

    @Override
    public CaretPos getStartPos() {
        return this.content.getStartPos();
    }

    @Override
    public CaretPos getEndPos() {
        return this.content.getEndPos();
    }

    @Override
    public String getCopyText(CaretPos from, CaretPos to) {
        StringBuilder b = new StringBuilder();
        if (from == null) {
            b.append(this.opening);
        }
        b.append(this.content.getCopyText(from, to));
        if (to == null) {
            b.append(this.closing);
        }
        return b.toString();
    }

    @Override
    public String getJavaCode() {
        StringBuilder b = new StringBuilder();
        b.append(this.opening);
        b.append(this.content.getJavaCode());
        b.append(this.closing);
        return b.toString();
    }

    @Override
    public CaretPos getCurrentPos() {
        return this.content.getCurrentPos();
    }

    public ObservableList<Node> getComponents() {
        return this.components;
    }

    @Override
    public List<InfixExpression.CaretPosMap> mapCaretPosStringPos(InfixExpression.IntCounter len, boolean javaString) {
        ++len.counter;
        List<InfixExpression.CaretPosMap> r = this.content.mapCaretPosStringPos(len, javaString);
        ++len.counter;
        return r;
    }

    @Override
    public Region getNodeForPos(CaretPos pos) {
        return this.content.getNodeForPos(pos);
    }

    InfixExpression getContent() {
        return this.content;
    }

    public void insertAfter(String text) {
        this.parent.insertNext(this, text);
    }

    @Override
    public String testingGetState(CaretPos pos) {
        return "" + this.opening + this.content.testingGetState(pos) + this.closing;
    }

    InfixExpression testingContent() {
        return this.content;
    }

    public CaretPos flatten(boolean atEnd) {
        return this.parent.flattenCompound(this, atEnd);
    }

    @Override
    public boolean isFocused() {
        return this.content.isFocused();
    }

    @Override
    public void insertSuggestion(CaretPos p, String name, List<String> params) {
        this.content.insertSuggestion(p, name, params);
    }

    public void withTooltipAtPos(int paramPos, FXConsumer<String> handler) {
        this.parent.withTooltipForParam(this, paramPos, handler);
    }

    CaretPos absolutePos(CaretPos p) {
        return this.parent.absolutePos(this, p);
    }

    char getOpening() {
        return this.opening;
    }

    @Override
    public void updatePrompts() {
        this.content.updatePromptsInMethodCalls();
    }

    public void focusBefore() {
        this.parent.backwardAtStart(this);
    }

    public void focusAfter() {
        this.parent.forwardAtEnd(this);
    }

    @Override
    public Stream<TextOverlayPosition> getAllStartEndPositionsBetween(CaretPos start, CaretPos end) {
        return this.content.getAllStartEndPositionsBetween(start, end);
    }

    @Override
    public Stream<InfixExpression> getAllExpressions() {
        return this.content.getAllExpressions();
    }

    @Override
    public ObservableStringValue textProperty() {
        return this.textProperty;
    }

    void highlightBrackets(boolean on) {
        JavaFXUtil.setPseudoclass("bj-bracket-highlight", on, new Node[]{this.openingLabel, this.closingLabel});
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        this.content.setView(oldView, newView, animate, Optional.empty());
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.openingLabel, this.closingLabel});
    }

    @Override
    public boolean isAlmostBlank() {
        return this.content.isAlmostBlank();
    }

    @Override
    public void notifyLostFocus(ExpressionSlotField except) {
        this.content.notifyLostFocus(except);
    }

    Node positionParentPos(CaretPos pos) {
        return this.parent.positionCaret(pos);
    }

    boolean isInSelection() {
        return this.parent != null && this.parent.isInSelection();
    }

    @Override
    public void setEditable(boolean editable) {
        this.content.setEditable(editable);
    }

    @Override
    public boolean isNumericLiteral() {
        return this.content.isNumericLiteral();
    }
}

