/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.SandwichCanvasesElement;
import bluej.stride.framedjava.elements.TryElement;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SandwichCanvasesFrame;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.FocusParent;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotValueListener;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.stride.slots.TypeTextSlot;
import bluej.stride.slots.VariableNameDefTextSlot;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TryFrame
extends SandwichCanvasesFrame {
    private static final String TRY_STYLE_PREFIX = "try-";
    private final List<TypeTextSlot> catchTypes = new ArrayList<TypeTextSlot>();
    private final List<VariableNameDefTextSlot> catchVars = new ArrayList<VariableNameDefTextSlot>();

    private TryFrame(InteractionManager editor) {
        super(editor, "try", "catch", "finally", TRY_STYLE_PREFIX);
    }

    public TryFrame(InteractionManager editor, List<Frame> contents) {
        this(editor);
        this.getFirstCanvas().getFirstCursor().insertFramesAfter(contents);
    }

    public TryFrame(InteractionManager editor, List<Frame> tryContents, List<TypeSlotFragment> catchTypes, List<NameDefSlotFragment> catchNames, List<List<Frame>> catchContents, List<Frame> finallyContents, boolean enabled) {
        this(editor, tryContents);
        for (int i = 0; i < catchContents.size(); ++i) {
            this.addIntermediateCanvas(Arrays.asList(catchTypes.get(i), catchNames.get(i)), catchContents.get(i));
        }
        if (finallyContents != null) {
            this.addTailCanvas();
            finallyContents.forEach(f -> this.getTailCanvas().insertBlockAfter((Frame)f, null));
        }
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    protected FrameContentRow getFrameContentRow(List<SlotFragment> slots, final JavaCanvas canvas, int at) {
        final FrameContentRow row = new FrameContentRow((Frame)this, "catch-");
        TypeTextSlot type = new TypeTextSlot(this.editor, this, this, row, new TypeCompletionCalculator(this.editor, Throwable.class), "catch-type-");
        type.setPromptText("type");
        type.setTargetType("Exception");
        type.addValueListener(new SlotValueListener(){

            @Override
            public boolean valueChanged(HeaderItem slot, String oldValue, String newValue, FocusParent<HeaderItem> parent) {
                return !newValue.contains(",");
            }

            @Override
            public void backSpacePressedAtStart(HeaderItem slot) {
                if (row.getSlotsDirect().allMatch(EditableSlot::isAlmostBlank)) {
                    TryFrame.this.pullUpCanvasContents(canvas.getFirstCursor().getUp(), canvas);
                } else {
                    row.focusLeft(slot);
                }
            }
        });
        final VariableNameDefTextSlot var = new VariableNameDefTextSlot(this.editor, this, this, row, "catch-var-");
        var.setPromptText("name");
        var.addValueListener(new SlotValueListener(){

            @Override
            public boolean valueChanged(HeaderItem slot, String oldValue, String newValue, FocusParent<HeaderItem> parent) {
                if (newValue.contains(",")) {
                    return false;
                }
                if (newValue.contains(")")) {
                    if (newValue.endsWith(")")) {
                        parent.focusRight(var);
                    }
                    return false;
                }
                return true;
            }

            @Override
            public void backSpacePressedAtStart(HeaderItem slot) {
                row.focusLeft(slot);
            }
        });
        if (slots != null) {
            if (slots.size() != 2) {
                Debug.printCallStack("slots has to include the exception type and var name, but the size is " + slots.size());
            }
            type.setText((TypeSlotFragment)slots.get(0));
            var.setText((NameDefSlotFragment)slots.get(1));
        }
        row.setHeaderItems(Arrays.asList(new SlotLabel("catch", "catch-caption", "caption"), new SlotLabel(" (", "if-bracket-opening"), type, var, new SlotLabel(")", new String[0])));
        this.catchTypes.add(at, type);
        this.catchVars.add(at, var);
        return row;
    }

    public static FrameFactory<TryFrame> getFactory() {
        return new FrameFactory<TryFrame>(){

            @Override
            public TryFrame createBlock(InteractionManager editor) {
                TryFrame tryFrame = new TryFrame(editor);
                tryFrame.addIntermediateCanvas();
                tryFrame.getFirstCanvas().getFirstCursor().requestFocus();
                return tryFrame;
            }

            @Override
            public TryFrame createBlock(InteractionManager editor, List<Frame> contents) {
                return new TryFrame(editor, contents);
            }

            @Override
            public Class<TryFrame> getBlockClass() {
                return TryFrame.class;
            }
        };
    }

    @Override
    protected SandwichCanvasesElement regenerateCodeElement(List<CodeElement> firstCanvasContents, List<List<CodeElement>> intermediateCanvasesContents, List<CodeElement> tailCanvasContents, boolean enabled) {
        return new TryElement(this, firstCanvasContents, Utility.mapList(this.catchTypes, TextSlot::getSlotElement), Utility.mapList(this.catchVars, TextSlot::getSlotElement), intermediateCanvasesContents, tailCanvasContents, enabled);
    }
}

