/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.SwitchElement;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CaseFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.MultiCanvasFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.SlotLabel;
import bluej.utility.Debug;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SwitchFrame
extends MultiCanvasFrame
implements CodeFrame<SwitchElement>,
DebuggableParentFrame {
    private static final String SWITCH_STYLE_PREFIX = "switch-";
    private final ExpressionSlot<FilledExpressionSlotFragment> expression;
    private final JavaCanvas casesCanvas;
    private JavaCanvas defaultCanvas;
    private SwitchElement element;
    private final InteractionManager editor;

    private SwitchFrame(final InteractionManager editor) {
        super(editor, "switch", SWITCH_STYLE_PREFIX);
        this.editor = editor;
        this.casesCanvas = new JavaCanvas(editor, this, SWITCH_STYLE_PREFIX, false);
        this.addCanvas(null, this.casesCanvas);
        this.expression = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), SWITCH_STYLE_PREFIX){

            @Override
            public boolean backspaceAtStart() {
                if (this.isAlmostBlank()) {
                    new PullUpContentsOperation(editor).activate(this.getParentFrame());
                    return true;
                }
                return super.backspaceAtStart();
            }
        };
        this.expression.setSimplePromptText("expression");
        this.setHeaderRow(new SlotLabel("(", new String[0]), this.expression, new SlotLabel(")", new String[0]));
        this.expression.onTextPropertyChange(this.updateSidebarCurried("switch "));
    }

    public SwitchFrame(InteractionManager editor, ExpressionSlotFragment expression, boolean enabled) {
        this(editor);
        this.expression.setText(expression);
        this.frameEnabledProperty.set(enabled);
    }

    public boolean addDefault() {
        if (this.defaultCanvas != null) {
            return false;
        }
        this.defaultCanvas = new JavaCanvas(this.editor, this, "default-case-", false);
        SlotLabel defaultLabel = new SlotLabel("default", new String[0]);
        JavaFXUtil.addStyleClass(defaultLabel, "divider-default-case");
        this.addCanvas(new FrameContentRow((Frame)this, defaultLabel), this.defaultCanvas);
        this.defaultCanvas.getFirstCursor().requestFocus();
        return true;
    }

    private void removeDefault() {
        if (this.defaultCanvas != null) {
            this.removeCanvas(this.defaultCanvas);
            this.defaultCanvas = null;
        }
    }

    public static FrameFactory<SwitchFrame> getFactory() {
        return new FrameFactory<SwitchFrame>(){

            @Override
            public SwitchFrame createBlock(InteractionManager editor) {
                SwitchFrame switchFrame = new SwitchFrame(editor);
                switchFrame.getFirstInternalCursor().insertBlockAfter(CaseFrame.getFactory().createBlock(editor));
                return switchFrame;
            }

            @Override
            public Class<SwitchFrame> getBlockClass() {
                return SwitchFrame.class;
            }
        };
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    @Override
    public void pullUpContents() {
        ArrayList<Frame> casesFrames = new ArrayList<Frame>((Collection<Frame>)this.casesCanvas.getBlockContents());
        casesFrames.forEach(c -> this.casesCanvas.removeBlock((Frame)c));
        ArrayList<Frame> contents = new ArrayList<Frame>();
        casesFrames.forEach(c -> {
            contents.add(new BlankFrame(this.editor));
            contents.addAll(((CaseFrame)c).getValidPulledStatements());
        });
        this.getCursorBefore().insertFramesAfter(contents);
        if (this.defaultCanvas != null) {
            this.getCursorBefore().insertBlockAfter(new BlankFrame(this.getEditor()));
            ArrayList<Frame> defaultContents = new ArrayList<Frame>((Collection<Frame>)this.defaultCanvas.getBlockContents());
            defaultContents.forEach(c -> this.defaultCanvas.removeBlock((Frame)c));
            this.getCursorBefore().insertFramesAfter(defaultContents);
        }
        this.editor.modifiedFrame(this);
    }

    public void pullUpInnerCaseContents(CaseFrame frame) {
        int index = this.casesCanvas.getBlockContents().indexOf((Object)frame);
        if (index < 0) {
            throw new IllegalStateException("CaseFrame should be in the casesCanvas");
        }
        if (index == 0) {
            Debug.message("pullUpInnerCaseContents @ SwitchFrame: Unimplemented case, waiting a design decision");
        } else {
            List<Frame> contents = frame.getValidPulledStatements();
            CaseFrame previous = (CaseFrame)this.casesCanvas.getBlockContents().get(index - 1);
            previous.getLastInternalCursor().insertBlockAfter(new BlankFrame(this.getEditor()));
            previous.getLastInternalCursor().insertFramesAfter(contents);
            this.casesCanvas.removeBlock(frame);
        }
        this.editor.modifiedFrame(this);
    }

    private void pullUpDefaultContents() {
        if (this.defaultCanvas == null) {
            throw new IllegalStateException("Default couldn't be null if this method is invoked.");
        }
        int casesCount = this.casesCanvas.blockCount();
        if (casesCount == 0) {
            Debug.message("pullUpDefaultContents @ SwitchFrame: Unimplemented case, waiting a design decision");
        } else {
            ArrayList<Frame> defaultContents = new ArrayList<Frame>((Collection<Frame>)this.defaultCanvas.getBlockContents());
            defaultContents.forEach(frame -> frame.setParentCanvas(null));
            defaultContents.forEach(c -> this.defaultCanvas.removeBlock((Frame)c));
            CaseFrame previous = (CaseFrame)this.casesCanvas.getBlockContents().get(casesCount - 1);
            previous.getLastInternalCursor().insertBlockAfter(new BlankFrame(this.getEditor()));
            previous.getLastInternalCursor().insertFramesAfter(defaultContents);
            this.removeDefault();
        }
        this.editor.modifiedFrame(this);
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(this, debug);
    }

    @Override
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return this.getCasesCanvas().showDebugBefore(null, debug);
    }

    @Override
    public void regenerateCode() {
        ArrayList<CodeElement> casesContents = new ArrayList<CodeElement>();
        this.casesCanvas.getBlocksSubtype(CodeFrame.class).forEach(f -> {
            f.regenerateCode();
            casesContents.add((CodeElement)f.getCode());
        });
        ArrayList<CodeElement> defaultContents = null;
        if (this.defaultCanvas != null) {
            defaultContents = new ArrayList<CodeElement>();
            for (CodeFrame f2 : this.defaultCanvas.getBlocksSubtype(CodeFrame.class)) {
                f2.regenerateCode();
                defaultContents.add((CodeElement)f2.getCode());
            }
        }
        this.element = new SwitchElement(this, (FilledExpressionSlotFragment)this.expression.getSlotElement(), casesContents, defaultContents, this.frameEnabledProperty.get());
    }

    @Override
    public SwitchElement getCode() {
        return this.element;
    }

    @Override
    public BreakFrame.BreakEncloser asBreakEncloser() {
        return BreakFrame.BreakEncloser.SWITCH;
    }

    public JavaCanvas getCasesCanvas() {
        return this.casesCanvas;
    }

    public JavaCanvas getDefaultCanvas() {
        return this.defaultCanvas;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions() {
        ArrayList<ExtensionDescription> result = new ArrayList<ExtensionDescription>(super.getAvailableExtensions());
        if (this.defaultCanvas == null) {
            result.add(new ExtensionDescription('d', "Add default", this::addDefault, true));
        }
        return result;
    }

    public DebuggableParentFrame getCasesDebug() {
        return new DebuggableParentFrame(){

            @Override
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)SwitchFrame.this.getParentCanvas()).showDebugBefore(SwitchFrame.this, debug);
            }

            @Override
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SwitchFrame.this.getCasesCanvas().showDebugBefore(null, debug);
            }
        };
    }

    public DebuggableParentFrame getDefaultDebug() {
        return new DebuggableParentFrame(){

            @Override
            public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
                return ((JavaCanvas)SwitchFrame.this.getParentCanvas()).showDebugBefore(SwitchFrame.this, debug);
            }

            @Override
            public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
                return SwitchFrame.this.getDefaultCanvas().showDebugBefore(null, debug);
            }
        };
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.expression.requestFocus();
        return true;
    }

    @Override
    public boolean acceptsType(FrameCanvas canvas, Class<? extends Frame> blockClass) {
        if (canvas == this.casesCanvas) {
            return blockClass.equals(CaseFrame.class);
        }
        if (canvas == this.defaultCanvas) {
            return this.getEditor().getDictionary().isValidStatment(blockClass);
        }
        return false;
    }

    @Override
    public List<ExtensionDescription> getAvailableInnerExtensions(FrameCanvas canvas, FrameCursor cursor) {
        ArrayList<ExtensionDescription> result = new ArrayList<ExtensionDescription>();
        if (this.defaultCanvas == null) {
            result.add(new ExtensionDescription('d', "Add default", this::addDefault, true));
        }
        if (canvas == this.casesCanvas) {
            result.add(new ExtensionDescription('\b', "Remove switch/cases, keep contents", () -> new PullUpContentsOperation(this.editor).activate(this.getFrame()), false, false));
        }
        if (this.defaultCanvas != null && canvas == this.defaultCanvas) {
            result.add(new ExtensionDescription('\b', "Remove default, keep contents", this::pullUpDefaultContents, false, false));
        }
        return result;
    }

    @Override
    public boolean isAlmostBlank() {
        return this.getEditableSlotsDirect().allMatch(EditableSlot::isAlmostBlank) && this.defaultCanvas == null && (this.casesCanvas.blockCount() == 0 || this.casesCanvas.blockCount() == 1 && ((Frame)this.casesCanvas.getBlockContents().get(0)).isAlmostBlank());
    }
}

