/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.OptionalExpressionSlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.ReturnElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.slots.OptionalExpressionSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;

public class ReturnFrame
extends SingleLineFrame
implements CodeFrame<ReturnElement>,
DebuggableFrame {
    private final OptionalExpressionSlot value;
    private ReturnElement element;
    private final SimpleStringProperty returnType = new SimpleStringProperty();
    private final SimpleBooleanProperty showingValue = new SimpleBooleanProperty(true);
    private final BooleanExpression notShowingValue = this.showingValue.not();

    private ReturnFrame(InteractionManager editor) {
        super(editor, "return", "return-");
        SlotLabel spacer = new SlotLabel(" ", new String[0]);
        spacer.setOpacity(0.0);
        spacer.setCursor(Cursor.TEXT);
        this.value = new OptionalExpressionSlot(editor, this, this, this.getHeaderRow(), "return-");
        this.value.setSimplePromptText("expression");
        this.value.bindTargetType((StringExpression)this.returnType);
        spacer.setOnMouseClicked((EventHandler<? super MouseEvent>)((EventHandler)e -> {
            this.showingValue.set(true);
            this.value.requestFocus();
            e.consume();
        }));
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new HeaderItem[]{this.headerCaptionLabel}), JavaFXUtil.listBool(this.notShowingValue, spacer), JavaFXUtil.listBool((BooleanExpression)this.showingValue, this.value), FXCollections.observableArrayList((Object[])new HeaderItem[]{this.previewSemi})}));
        this.value.onLostFocus(() -> {
            if ("void".equals(this.returnType.get()) && this.value.getText().isEmpty()) {
                this.showingValue.set(false);
            }
        });
    }

    public ReturnFrame(InteractionManager editor, ExpressionSlotFragment val, boolean enabled) {
        this(editor);
        if (val != null) {
            this.showingValue.set(true);
            this.value.setText(val);
        } else {
            this.showingValue.set(false);
        }
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public void regenerateCode() {
        this.element = new ReturnElement(this, this.showingValue.get() ? (OptionalExpressionSlotFragment)this.value.getSlotElement() : null, this.frameEnabledProperty.get());
    }

    @Override
    public ReturnElement getCode() {
        return this.element;
    }

    public static FrameFactory<ReturnFrame> getFactory() {
        return new FrameFactory<ReturnFrame>(){

            @Override
            public ReturnFrame createBlock(InteractionManager editor) {
                return new ReturnFrame(editor);
            }

            @Override
            public Class<ReturnFrame> getBlockClass() {
                return ReturnFrame.class;
            }
        };
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(this, debug);
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        Frame f;
        super.updateAppearance(parentCanvas);
        Frame frame = f = parentCanvas == null ? null : parentCanvas.getParent().getFrame();
        while (f != null) {
            if (f instanceof NormalMethodFrame) {
                NormalMethodFrame mf = (NormalMethodFrame)f;
                this.returnType.unbind();
                this.returnType.bind((ObservableValue)mf.returnTypeProperty());
                if (!"void".equals(this.returnType.get())) {
                    this.showingValue.set(true);
                }
                return;
            }
            f = f.getParentCanvas() == null ? null : f.getParentCanvas().getParent().getFrame();
        }
        this.returnType.unbind();
        this.returnType.set(null);
        this.showingValue.set(false);
    }

    public FXRunnable getRemoveFilledValueAction() {
        if (this.value.getText().equals("")) {
            this.showingValue.set(false);
            return null;
        }
        if (this.showingValue.get()) {
            return () -> this.showingValue.set(false);
        }
        return null;
    }

    public void showValue() {
        this.showingValue.set(true);
    }
}

