/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.debugger.gentype.Reflective;
import bluej.parser.AssistContent;
import bluej.stride.framedjava.ast.ASTUtility;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ConstructorElement;
import bluej.stride.framedjava.elements.MethodProtoElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.MethodFrameWithBody;
import bluej.stride.framedjava.slots.ExpressionCompletionCalculator;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.AbstractOperation;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.CompletionCalculator;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.FormalParameters;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.MethodNameDefTextSlot;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.SuggestionList;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.stride.slots.TypeTextSlot;
import bluej.stride.slots.WrappableSlotLabel;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import threadchecker.OnThread;
import threadchecker.Tag;

public class NormalMethodFrame
extends MethodFrameWithBody<NormalMethodElement> {
    private final SlotLabel staticLabel;
    private BooleanProperty staticModifier = new SimpleBooleanProperty(false);
    private final SlotLabel finalLabel;
    private BooleanProperty finalModifier = new SimpleBooleanProperty(false);
    private final WrappableSlotLabel overrideLabel = new WrappableSlotLabel(""){

        @Override
        public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
            if (oldView == Frame.View.NORMAL && newView == Frame.View.JAVA_PREVIEW) {
                this.fadeOut(animate, true);
            } else {
                this.fadeIn(animate);
            }
        }
    };
    private String curOverrideSource = null;
    private final TypeTextSlot returnType;
    private final TextSlot<NameDefSlotFragment> methodName;
    private NormalMethodElement element;

    private NormalMethodFrame(InteractionManager editor) {
        super(editor);
        this.setDocumentationPromptText("Describe your method here...");
        this.methodName = new MethodNameDefTextSlot(editor, this, this.getHeaderRow(), new MethodOverrideCompletionCalculator(), "method-name-");
        this.methodName.addValueListener(new SlotTraversalChars(() -> this.getHeaderRow().focusRight(this.methodName), SlotTraversalChars.METHOD_NAME.getChars()){

            @Override
            public void deletePressedAtEnd(HeaderItem slot) {
                NormalMethodFrame.this.paramsPane.deleteFirstParam();
            }
        });
        this.returnType = new TypeTextSlot(editor, this, this.getHeaderRow(), new TypeCompletionCalculator(editor), "method-return-type-");
        this.returnType.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.returnType.markReturnType();
        this.paramsPane = new FormalParameters(editor, this, this, this.getHeaderRow(), "method-param-");
        this.returnType.setPromptText("type");
        this.methodName.setPromptText("name");
        this.staticLabel = new SlotLabel("static ", new String[0]);
        this.finalLabel = new SlotLabel("final ", new String[0]);
        this.overrideLabel.addStyleClass("method-override-label");
        this.overrideLabel.setAlignment(HangingFlowPane.FlowAlignment.RIGHT);
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new HeaderItem[]{this.access}), JavaFXUtil.listBool((BooleanExpression)this.staticModifier, this.staticLabel), JavaFXUtil.listBool((BooleanExpression)this.finalModifier, this.finalLabel), FXCollections.observableArrayList((Object[])new HeaderItem[]{this.returnType}), FXCollections.observableArrayList((Object[])new HeaderItem[]{this.methodName}), this.paramsPane.getSlots(), this.throwsPane.getHeaderItems(), FXCollections.observableArrayList((Object[])new HeaderItem[]{this.overrideLabel})}));
        JavaFXUtil.addChangeListener(this.staticModifier, b -> editor.modifiedFrame(this));
        JavaFXUtil.addChangeListener(this.finalModifier, b -> editor.modifiedFrame(this));
    }

    public NormalMethodFrame(InteractionManager editor, AccessPermissionFragment access, boolean staticModifier, boolean finalModifier, String returnType, String name, String documentation, boolean enabled) {
        this(editor);
        this.access.setValue(access.getValue());
        access.registerSlot(this.access);
        this.staticModifier.set(staticModifier);
        this.finalModifier.set(finalModifier);
        this.setDocumentation(documentation);
        this.returnType.setText(returnType);
        this.methodName.setText(name);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.returnType.requestFocus();
        return true;
    }

    public static FrameFactory<NormalMethodFrame> getFactory() {
        return new FrameFactory<NormalMethodFrame>(){

            @Override
            public NormalMethodFrame createBlock(InteractionManager editor) {
                return new NormalMethodFrame(editor);
            }

            @Override
            public Class<NormalMethodFrame> getBlockClass() {
                return NormalMethodFrame.class;
            }
        };
    }

    @Override
    public void regenerateCode() {
        List<ParamFragment> params = this.generateParams();
        this.element = new NormalMethodElement(this, new AccessPermissionFragment(this, this.access), this.staticModifier.get(), this.finalModifier.get(), (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), params, this.throwsPane.getTypes(), this.getContents(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
    }

    @Override
    public NormalMethodElement getCode() {
        return this.element;
    }

    public String getName() {
        return this.methodName.getText();
    }

    @Override
    public List<FrameOperation> getContextOperations(InteractionManager editor) {
        ArrayList<FrameOperation> r = new ArrayList<FrameOperation>(super.getContextOperations(editor));
        r.add(new CustomFrameOperation(editor, "method->constructor", Arrays.asList("Change", "to constructor"), EditableSlot.MenuItemOrder.TRANSFORM, this, () -> {
            Frame parent = this.getParentCanvas().getParent().getFrame();
            if (parent instanceof ClassFrame) {
                FrameCanvas p = ((ClassFrame)parent).getConstructorsCanvas();
                FrameCursor c = p.getLastCursor();
                ConstructorElement el = new ConstructorElement(null, new AccessPermissionFragment(this, this.access), this.generateParams(), this.throwsPane.getTypes(), null, null, this.getContents(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
                c.insertBlockAfter(el.createFrame(this.getEditor()));
                this.getParentCanvas().removeBlock(this);
            }
        }));
        r.add(new CustomFrameOperation(editor, "concrete->abstract", Arrays.asList("Change", "to abstract"), EditableSlot.MenuItemOrder.TRANSFORM, this, () -> {
            FrameCursor c = this.getCursorBefore();
            MethodProtoElement el = new MethodProtoElement(null, (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), this.generateParams(), this.throwsPane.getTypes(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
            c.insertBlockAfter(el.createFrame(this.getEditor()));
            c.getParentCanvas().removeBlock(this);
        }));
        r.add(new CustomFrameOperation(editor, "addRemoveStatic", Arrays.asList("Toggle static"), EditableSlot.MenuItemOrder.TOGGLE_STATIC, this, () -> this.staticModifier.set(!this.staticModifier.get())));
        r.add(new CustomFrameOperation(editor, "addRemoveFinal", Arrays.asList("Toggle final"), EditableSlot.MenuItemOrder.TOGGLE_FINAL, this, () -> this.finalModifier.set(!this.finalModifier.get())));
        return r;
    }

    @Override
    protected List<ExtensionDescription> getAvailablePrefixes() {
        return Utility.concat(super.getAvailablePrefixes(), Arrays.asList(new ExtensionDescription('n', "Add/Remove final", () -> new ToggleFinalMethod(this.getEditor()).activate(this), false, false), new ExtensionDescription('s', "Add/Remove static", () -> new ToggleStaticMethod(this.getEditor()).activate(this), false, false)));
    }

    public StringExpression returnTypeProperty() {
        return this.returnType.textProperty();
    }

    @OnThread(value=Tag.Swing)
    public void updateOverrideDisplay(ClassElement topLevel) {
        if (this.element == null) {
            return;
        }
        List<String> qualParamTypes = this.element.getQualifiedParamTypes(topLevel);
        Reflective overriddenFrom = topLevel.findSuperMethod(this.element.getName(), qualParamTypes);
        if (overriddenFrom != null) {
            String name = overriddenFrom.getSimpleName();
            if (name.indexOf(46) != -1) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            String nameFinal = name;
            if (this.curOverrideSource == null || !this.curOverrideSource.equals(nameFinal)) {
                this.curOverrideSource = nameFinal;
                Platform.runLater(() -> this.overrideLabel.setText("overrides method in " + nameFinal));
            }
        } else if (this.curOverrideSource != null) {
            this.curOverrideSource = null;
            Platform.runLater(() -> this.overrideLabel.setText(""));
        }
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return this.methodName;
    }

    @Override
    public void focusName() {
        this.methodName.requestFocus(Focus.LEFT);
    }

    @Override
    protected FrameContentRow makeHeader(String stylePrefix) {
        return new FrameContentRow(this, stylePrefix){

            @Override
            public void focusRight(HeaderItem src) {
                if (src == NormalMethodFrame.this.methodName) {
                    NormalMethodFrame.this.paramsPane.ensureAtLeastOneParameter();
                }
                super.focusRight(src);
            }

            @Override
            public boolean focusRightEndFromNext() {
                NormalMethodFrame.this.paramsPane.ensureAtLeastOneParameter();
                return super.focusRightEndFromNext();
            }

            @Override
            public void escape(HeaderItem src) {
                if (NormalMethodFrame.this.paramsPane.findFormal(src) != null) {
                    NormalMethodFrame.this.paramsPane.escape(src);
                } else {
                    super.escape(src);
                }
            }
        };
    }

    @Override
    public boolean tryRestoreTo(CodeElement codeElement) {
        if (codeElement instanceof NormalMethodElement) {
            NormalMethodElement nme = (NormalMethodElement)codeElement;
            this.staticModifier.set(nme.isStatic());
            this.finalModifier.set(nme.isFinal());
            this.returnType.setText(nme.getType());
            this.methodName.setText(nme.getName());
            this.restoreDetails(nme);
            return true;
        }
        return false;
    }

    public static class ToggleStaticMethod
    extends FrameOperation {
        private SimpleStringProperty name = new SimpleStringProperty("Toggle static");

        public ToggleStaticMethod(InteractionManager editor) {
            super(editor, "toggleStaticMethod", AbstractOperation.Combine.ALL, (KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[0]));
        }

        @Override
        protected void execute(List<Frame> frames) {
            frames.forEach(f -> ((NormalMethodFrame)f).staticModifier.set(!this.targetedAllStatic(frames)));
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return Arrays.asList(new AbstractOperation.ItemLabel((ObservableValue<String>)this.name, EditableSlot.MenuItemOrder.TOGGLE_STATIC));
        }

        @Override
        public void onMenuShowing(CustomMenuItem item) {
            super.onMenuShowing(item);
            this.updateName();
        }

        private void updateName() {
            this.name.set(this.targetedAllStatic(this.editor.getSelection().getSelected()) ? "Remove static" : "Make static");
        }

        private boolean targetedAllStatic(List<Frame> frames) {
            return frames.stream().allMatch(f -> ((NormalMethodFrame)f).staticModifier.get());
        }

        @Override
        public boolean onlyOnContextMenu() {
            return true;
        }
    }

    public static class ToggleFinalMethod
    extends FrameOperation {
        private SimpleStringProperty name = new SimpleStringProperty("Toggle final");

        public ToggleFinalMethod(InteractionManager editor) {
            super(editor, "toggleFinalMethod", AbstractOperation.Combine.ALL);
        }

        @Override
        protected void execute(List<Frame> frames) {
            frames.forEach(f -> ((NormalMethodFrame)f).finalModifier.set(!this.targetedAllFinal(frames)));
        }

        @Override
        public List<AbstractOperation.ItemLabel> getLabels() {
            return Arrays.asList(new AbstractOperation.ItemLabel((ObservableValue<String>)this.name, EditableSlot.MenuItemOrder.TOGGLE_FINAL));
        }

        @Override
        public void onMenuShowing(CustomMenuItem item) {
            super.onMenuShowing(item);
            this.updateName();
        }

        private void updateName() {
            this.name.set(this.targetedAllFinal(this.editor.getSelection().getSelected()) ? "Remove final" : "Make final");
        }

        private boolean targetedAllFinal(List<Frame> frames) {
            return frames.stream().allMatch(f -> ((NormalMethodFrame)f).finalModifier.get());
        }

        @Override
        public boolean onlyOnContextMenu() {
            return true;
        }
    }

    private class MethodOverrideCompletionCalculator
    implements CompletionCalculator {
        private List<AssistContentThreadSafe> inheritedMethods;
        private SuggestionList suggestionDisplay;

        private MethodOverrideCompletionCalculator() {
        }

        @Override
        public void withCalculatedSuggestionList(JavaFragment.PosInSourceDoc pos, CodeElement codeEl, SuggestionList.SuggestionListListener listener, String targetType, FXConsumer<SuggestionList> handler) {
            ClassFrame classFrame = (ClassFrame)ASTUtility.getTopLevelElement(codeEl).getFrame();
            classFrame.withInheritedItems(Collections.singleton(AssistContent.CompletionKind.METHOD), inheritedMethodsByDeclarer -> {
                this.inheritedMethods = inheritedMethodsByDeclarer.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                this.suggestionDisplay = new SuggestionList(NormalMethodFrame.this.getEditor(), Utility.mapList(this.inheritedMethods, ac -> new SuggestionList.SuggestionDetailsWithHTMLDoc(ac.getName(), ExpressionCompletionCalculator.getParamsCompletionDisplay(ac), ac.getType(), SuggestionList.SuggestionShown.COMMON, ac.getDocHTML())), null, SuggestionList.SuggestionShown.RARE, null, listener);
                handler.accept(this.suggestionDisplay);
            });
        }

        @Override
        public boolean execute(TextField field, int selected, int startOfCurWord) {
            if (selected == -1) {
                return false;
            }
            AssistContentThreadSafe a = this.inheritedMethods.get(selected);
            NormalMethodFrame.this.methodName.setText(a.getName());
            NormalMethodFrame.this.returnType.setText(a.getType());
            NormalMethodFrame.this.access.setValue(AccessPermission.fromAccess(a.getAccessPermission()));
            NormalMethodFrame.this.paramsPane.setParams(a.getParams(), AssistContent.ParamInfo::getUnqualifiedType, AssistContent.ParamInfo::getFormalName);
            return true;
        }
    }
}

