/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.AccessPermissionFragment;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.ParamFragment;
import bluej.stride.framedjava.ast.ThrowsTypeFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.MethodProtoElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.frames.ClassFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.generic.DocumentedSingleLineFrame;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.FormalParameters;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.MethodNameDefTextSlot;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.Throws;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.stride.slots.TypeTextSlot;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MethodProtoFrame
extends DocumentedSingleLineFrame
implements CodeFrame<MethodProtoElement> {
    private final SlotLabel abstractLabel = new SlotLabel("abstract", new String[0]);
    private final BooleanProperty parentIsClass = new SimpleBooleanProperty(false);
    private final TypeTextSlot returnType;
    private final MethodNameDefTextSlot methodName;
    private final FormalParameters paramsPane;
    private final Throws throwsPane;
    private MethodProtoElement element;

    public MethodProtoFrame(InteractionManager editor) {
        super(editor, "", "method-");
        this.methodName = new MethodNameDefTextSlot(editor, this, this.getHeaderRow(), null, "method-name-");
        this.methodName.setPromptText("name");
        this.methodName.addValueListener(SlotTraversalChars.METHOD_NAME);
        this.returnType = new TypeTextSlot(editor, this, this.getHeaderRow(), new TypeCompletionCalculator(editor), "method-return-type-");
        this.returnType.setPromptText("type");
        this.returnType.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.paramsPane = new FormalParameters(editor, this, this, this.getHeaderRow(), "method-param-");
        this.setDocumentationPromptText("Describe your method here...");
        this.throwsPane = new Throws(this, () -> {
            TypeTextSlot s = new TypeTextSlot(editor, this, this.getHeaderRow(), new TypeCompletionCalculator(editor, Throwable.class), "method-");
            s.setPromptText("thrown type");
            return s;
        }, () -> this.getCursorAfter().requestFocus());
        this.bindHeader();
    }

    public MethodProtoFrame(InteractionManager editor, TypeSlotFragment returnType, NameDefSlotFragment methodName, List<ParamFragment> params, List<ThrowsTypeFragment> throwsTypes, String documentation, boolean enabled) {
        this(editor);
        this.returnType.setText(returnType);
        this.methodName.setText(methodName);
        params.forEach(item -> this.paramsPane.addFormal(item.getParamType(), item.getParamName()));
        throwsTypes.forEach(t -> this.throwsPane.addTypeSlotAtEnd(t.getType()));
        this.setDocumentation(documentation);
        this.frameEnabledProperty.set(enabled);
    }

    private void bindHeader() {
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{JavaFXUtil.listBool((BooleanExpression)this.parentIsClass, this.abstractLabel), FXCollections.observableArrayList((Object[])new HeaderItem[]{this.returnType, this.methodName}), this.paramsPane.getSlots(), this.throwsPane.getHeaderItems(), FXCollections.observableArrayList((Object[])new HeaderItem[]{this.previewSemi})}));
    }

    public static FrameFactory<MethodProtoFrame> getFactory() {
        return new FrameFactory<MethodProtoFrame>(){

            @Override
            public MethodProtoFrame createBlock(InteractionManager editor) {
                return new MethodProtoFrame(editor);
            }

            @Override
            public Class<MethodProtoFrame> getBlockClass() {
                return MethodProtoFrame.class;
            }
        };
    }

    @Override
    public List<FrameOperation> getContextOperations(InteractionManager editor) {
        ArrayList<FrameOperation> r = new ArrayList<FrameOperation>(super.getContextOperations(editor));
        if (this.parentIsClass.get()) {
            r.add(new CustomFrameOperation(editor, "abstract->concrete", Arrays.asList("Change", "to Concrete"), EditableSlot.MenuItemOrder.TRANSFORM, this, () -> {
                FrameCursor c = this.getCursorBefore();
                NormalMethodElement el = new NormalMethodElement(null, new AccessPermissionFragment(AccessPermission.PUBLIC), false, false, (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), this.paramsPane.getSlotElement(), this.throwsPane.getTypes(), new ArrayList<CodeElement>(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
                c.insertBlockAfter(el.createFrame(this.getEditor()));
                c.getParentCanvas().removeBlock(this);
            }));
        }
        return r;
    }

    @Override
    public void regenerateCode() {
        this.element = new MethodProtoElement(this, (TypeSlotFragment)this.returnType.getSlotElement(), (NameDefSlotFragment)this.methodName.getSlotElement(), this.paramsPane.getSlotElement(), this.throwsPane.getTypes(), new JavadocUnit(this.getDocumentation()), this.frameEnabledProperty.get());
    }

    @Override
    public boolean focusWhenJustAdded() {
        this.returnType.requestFocus();
        return true;
    }

    @Override
    protected List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    @Override
    public MethodProtoElement getCode() {
        return this.element;
    }

    @Override
    public List<ExtensionDescription> getAvailableExtensions() {
        return Arrays.asList(new ExtensionDescription('t', "Add throws declaration", () -> this.throwsPane.addTypeSlotAtEnd("")));
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        this.parentIsClass.set(parentCanvas.getParent().getFrame() instanceof ClassFrame);
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return this.methodName;
    }
}

