/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.BlankFrame;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.CaseFrame;
import bluej.stride.framedjava.frames.CommentFrame;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.frames.ForeachFrame;
import bluej.stride.framedjava.frames.GreenfootFrameCategory;
import bluej.stride.framedjava.frames.IfFrame;
import bluej.stride.framedjava.frames.ImportFrame;
import bluej.stride.framedjava.frames.MethodProtoFrame;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.frames.ReturnFrame;
import bluej.stride.framedjava.frames.SwitchFrame;
import bluej.stride.framedjava.frames.ThrowFrame;
import bluej.stride.framedjava.frames.TryFrame;
import bluej.stride.framedjava.frames.VarFrame;
import bluej.stride.framedjava.frames.WhileFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameDictionary;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GreenfootFrameDictionary
extends FrameDictionary<GreenfootFrameCategory> {
    private static GreenfootFrameDictionary instance = new GreenfootFrameDictionary();
    private Map<String, Character> extensions = new HashMap<String, Character>();
    public static final char ABSTRACT_EXTENSION_CHAR = 'b';
    public static final char DEFAULT_EXTENSION_CHAR = 'd';
    public static final char EXTENDS_EXTENSION_CHAR = 'e';
    public static final char IMPLEMENTS_EXTENSION_CHAR = 'i';
    public static final char THIS_EXTENSION_CHAR = 't';
    public static final char SUPER_EXTENSION_CHAR = 'u';
    public static final char THROWS_EXTENSION_CHAR = 'o';
    public static final char VAR_CHAR = 'v';
    public static final char CONSTRUCTOR_CHAR = 'c';
    public static final char METHOD_CHAR = 'm';
    public static final char ABSTRACT_METHOD_CHAR = 'a';

    public static GreenfootFrameDictionary getDictionary() {
        return instance;
    }

    private GreenfootFrameDictionary() {
        super(Arrays.asList(new FrameDictionary.Entry<GreenfootFrameCategory>(' ', CallFrame.getFactory(), false, GreenfootFrameCategory.CALL, "Call method", "Calls a method"), new FrameDictionary.Entry<GreenfootFrameCategory>('\n', BlankFrame.getFactory(), false, GreenfootFrameCategory.BLANK, "Blank", "A blank line"), new FrameDictionary.Entry<GreenfootFrameCategory>('/', CommentFrame.getFactory(), false, GreenfootFrameCategory.COMMENT, "Comment", "A code comment"), new FrameDictionary.Entry<GreenfootFrameCategory>('=', AssignFrame.getFactory(), false, GreenfootFrameCategory.ASSIGNMENT, "Assignment", "Assignment"), new FrameDictionary.Entry<GreenfootFrameCategory>('a', MethodProtoFrame.getFactory(), false, GreenfootFrameCategory.ABSTRACT, "Abstract method", "An abstract method of a class"), new FrameDictionary.Entry<GreenfootFrameCategory>('b', BreakFrame.getFactory(), false, GreenfootFrameCategory.BREAK, "Break", "Breaks out of loop"), new FrameDictionary.Entry<GreenfootFrameCategory>('c', ConstructorFrame.getFactory(), false, GreenfootFrameCategory.CONSTRUCTOR, "Constructor", "A constructor of a class"), new FrameDictionary.Entry<GreenfootFrameCategory>('c', CaseFrame.getFactory(), false, GreenfootFrameCategory.CASE, "Case (Switch)", "Handles specific value"), new FrameDictionary.Entry<GreenfootFrameCategory>('f', ForeachFrame.getFactory(), true, GreenfootFrameCategory.LOOP, "For-each loop", "Loop over a collection"), new FrameDictionary.Entry<GreenfootFrameCategory>('i', IfFrame.getFactory(), true, GreenfootFrameCategory.CONDITIONAL, "If", "Conditional execution"), new FrameDictionary.Entry<GreenfootFrameCategory>('i', ImportFrame.getFactory(), false, GreenfootFrameCategory.IMPORT, "Import", "Import a class or package"), new FrameDictionary.Entry<GreenfootFrameCategory>('m', NormalMethodFrame.getFactory(), false, GreenfootFrameCategory.METHOD, "Method", "A method of a class"), new FrameDictionary.Entry<GreenfootFrameCategory>('r', ReturnFrame.getFactory(), false, GreenfootFrameCategory.RETURN, "Return", "Returns from method"), new FrameDictionary.Entry<GreenfootFrameCategory>('s', SwitchFrame.getFactory(), false, GreenfootFrameCategory.SWITCH, "Switch", "Chooses from several cases"), new FrameDictionary.Entry<GreenfootFrameCategory>('v', VarFrame.getFactory(), false, GreenfootFrameCategory.VAR, "Variable declaration", "Declares variable"), new FrameDictionary.Entry<GreenfootFrameCategory>('w', WhileFrame.getFactory(), true, GreenfootFrameCategory.LOOP, "While loop", "Pre-condition loop"), new FrameDictionary.Entry<GreenfootFrameCategory>('x', ThrowFrame.getFactory(), false, GreenfootFrameCategory.THROW, "Throw", "Throws an exception"), new FrameDictionary.Entry<GreenfootFrameCategory>('y', TryFrame.getFactory(), true, GreenfootFrameCategory.TRY, "Try/catch", "Try block")));
        this.extensions.put("catch", Character.valueOf('c'));
        this.extensions.put("else", Character.valueOf('e'));
        this.extensions.put("elseif", Character.valueOf('l'));
        this.extensions.put("finally", Character.valueOf('n'));
    }

    public GreenfootFrameCategory[] getCategories() {
        return GreenfootFrameCategory.values();
    }

    @Override
    public String[] getCategoryNames() {
        String[] names = new String[GreenfootFrameCategory.values().length];
        for (int i = 0; i < names.length; ++i) {
            String str = GreenfootFrameCategory.values()[i].toString();
            names[i] = str.substring(0, 1) + str.substring(1).toLowerCase();
        }
        return names;
    }

    @Override
    public boolean isValidStatment(Class<? extends Frame> blockClass) {
        return this.getAllBlocks().stream().filter(t -> ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.CONDITIONAL) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.VAR) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.BLANK) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.COMMENT) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.LOOP) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.ASSIGNMENT) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.CALL) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.BREAK) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.SWITCH) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.THROW) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.TRY) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.RETURN)).anyMatch(p -> p.getBlockClass().equals(blockClass));
    }

    @Override
    public boolean isValidField(Class<? extends Frame> blockClass) {
        return this.getAllBlocks().stream().filter(t -> ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.VAR) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.BLANK) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.COMMENT)).anyMatch(p -> p.getBlockClass().equals(blockClass));
    }

    @Override
    public boolean isValidConstructor(Class<? extends Frame> blockClass) {
        return this.getAllBlocks().stream().filter(t -> ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.CONSTRUCTOR) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.COMMENT)).anyMatch(p -> p.getBlockClass().equals(blockClass));
    }

    @Override
    public boolean isValidClassMethod(Class<? extends Frame> blockClass) {
        return this.getAllBlocks().stream().filter(t -> ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.ABSTRACT) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.METHOD) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.COMMENT)).anyMatch(p -> p.getBlockClass().equals(blockClass));
    }

    @Override
    public boolean isValidInterfaceMethod(Class<? extends Frame> blockClass) {
        return this.getAllBlocks().stream().filter(t -> ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.VAR) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.ABSTRACT) || ((GreenfootFrameCategory)((Object)((Object)t.getCategory()))).equals((Object)GreenfootFrameCategory.COMMENT)).anyMatch(p -> p.getBlockClass().equals(blockClass));
    }

    public char getExtensionChar(String tailCanvasCaption) {
        return this.extensions.get(tailCanvasCaption).charValue();
    }
}

