/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ForeachElement;
import bluej.stride.framedjava.frames.BreakFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.framedjava.slots.EachExpressionSlot;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleCanvasFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.operations.PullUpContentsOperation;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.stride.slots.TypeTextSlot;
import bluej.stride.slots.VariableNameDefTextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ForeachFrame
extends SingleCanvasFrame
implements CodeFrame<ForeachElement>,
DebuggableParentFrame {
    private final TypeTextSlot type;
    private final VariableNameDefTextSlot var;
    private final EachExpressionSlot collection;
    private ForeachElement element;
    private final SlotLabel inLabel;

    private ForeachFrame(final InteractionManager editor) {
        super(editor, "for each", "foreach-");
        this.type = new TypeTextSlot(editor, this, this.getHeaderRow(), new TypeCompletionCalculator(editor), "foreach-type-");
        this.type.setPromptText("item type");
        this.type.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.type.addValueListener(new SlotTraversalChars(new char[0]){

            @Override
            public void backSpacePressedAtStart(HeaderItem slot) {
                if (ForeachFrame.this.type.isAlmostBlank()) {
                    new PullUpContentsOperation(editor).activate(ForeachFrame.this.getFrame());
                }
            }
        });
        this.var = new VariableNameDefTextSlot(editor, this, this.getHeaderRow(), "foreach-var-");
        this.var.setPromptText("item name");
        this.var.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.collection = new EachExpressionSlot(editor, this, this, this.getHeaderRow(), this.type, this.var, "foreach-collection-");
        this.collection.setSimplePromptText("collection");
        this.inLabel = new SlotLabel(" in ", new String[0]);
        this.setHeaderRow(new SlotLabel("(", new String[0]), this.type, this.var, this.inLabel, this.collection, new SlotLabel(")", new String[0]));
        FXConsumer<String> updateTriple = s -> this.updateSidebarCurried("for each ").accept(this.type.getText() + " " + this.var.getText() + " : " + this.collection.getText());
        JavaFXUtil.addChangeListener(this.type.textProperty(), updateTriple);
        JavaFXUtil.addChangeListener(this.var.textProperty(), updateTriple);
        this.collection.onTextPropertyChange(updateTriple);
    }

    public ForeachFrame(InteractionManager editor, TypeSlotFragment type, NameDefSlotFragment var, ExpressionSlotFragment collection, boolean enabled) {
        this(editor);
        this.type.setText(type);
        this.var.setText(var);
        this.collection.setText(collection);
        this.frameEnabledProperty.set(enabled);
    }

    public ForeachFrame(InteractionManager editor, List<Frame> contents) {
        this(editor);
        this.getCanvas().getFirstCursor().insertFramesAfter(contents);
    }

    @Override
    public boolean acceptsType(FrameCanvas canvas, Class<? extends Frame> blockClass) {
        return this.getEditor().getDictionary().isValidStatment(blockClass);
    }

    @Override
    public List<FrameOperation> getContextOperations(InteractionManager editor) {
        List<FrameOperation> r = super.getContextOperations(editor);
        r.add(new PullUpContentsOperation(editor));
        return r;
    }

    public static FrameFactory<ForeachFrame> getFactory() {
        return new FrameFactory<ForeachFrame>(){

            @Override
            public ForeachFrame createBlock(InteractionManager editor) {
                return new ForeachFrame(editor);
            }

            @Override
            public ForeachFrame createBlock(InteractionManager editor, List<Frame> contents) {
                return new ForeachFrame(editor, contents);
            }

            @Override
            public Class<ForeachFrame> getBlockClass() {
                return ForeachFrame.class;
            }
        };
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    @Override
    public FrameCanvas createCanvas(InteractionManager editor, String stylePrefix) {
        return new JavaCanvas(editor, this, stylePrefix, false);
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(this, debug);
    }

    @Override
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return ((JavaCanvas)this.getCanvas()).showDebugBefore(null, debug);
    }

    @Override
    public void regenerateCode() {
        ArrayList<CodeElement> contents = new ArrayList<CodeElement>();
        for (CodeFrame f : this.canvas.getBlocksSubtype(CodeFrame.class)) {
            f.regenerateCode();
            contents.add((CodeElement)f.getCode());
        }
        this.element = new ForeachElement(this, (TypeSlotFragment)this.type.getSlotElement(), (NameDefSlotFragment)this.var.getSlotElement(), (FilledExpressionSlotFragment)this.collection.getSlotElement(), contents, this.frameEnabledProperty.get());
    }

    @Override
    public ForeachElement getCode() {
        return this.element;
    }

    @Override
    public List<ExtensionDescription> getAvailableInnerExtensions(FrameCanvas canvas, FrameCursor cursor) {
        return Utility.concat(super.getAvailableInnerExtensions(canvas, cursor), Arrays.asList(new ExtensionDescription('\b', "Remove loop, keep contents", () -> new PullUpContentsOperation(this.getEditor()).activate(this), false, false)));
    }

    @Override
    public List<String> getDeclaredVariablesWithin(FrameCanvas c) {
        if (c != this.getCanvas()) {
            throw new IllegalArgumentException("Canvas does not exist in this frame");
        }
        String name = this.var.getText();
        if (name.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(name);
    }

    @Override
    public BreakFrame.BreakEncloser asBreakEncloser() {
        return BreakFrame.BreakEncloser.FOREACH;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        super.setView(oldView, newView, animateProgress);
        String caption = newView == Frame.View.JAVA_PREVIEW ? "for" : "for each";
        this.headerCaptionLabel.setText(caption);
        this.inLabel.setText(newView == Frame.View.JAVA_PREVIEW ? (this.collection.isConstantRange() ? " = " : " : ") : " in ");
    }
}

