/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.frames.DebugVarInfo;
import bluej.stride.generic.FrameCursor;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.ScaleTransition;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DebugInfo {
    private final IdentityHashMap<FrameCursor, Display> displays = new IdentityHashMap();
    private Map<String, DebugVarInfo> prevState;
    private Map<String, DebugVarInfo> state;

    @OnThread(value=Tag.Any)
    public DebugInfo() {
    }

    @OnThread(value=Tag.Any)
    public void addVarState(Map<String, DebugVarInfo> state) {
        this.prevState = this.state;
        this.state = state;
    }

    public Display getInfoDisplay(FrameCursor f) {
        if (this.displays.containsKey(f)) {
            this.displays.get(f).addState(this.prevState, this.state);
            return this.displays.get(f);
        }
        Display d = new Display(this.prevState, this.state);
        this.displays.put(f, d);
        return d;
    }

    public void removeAllDisplays(List<Node> disps) {
        Iterator<Map.Entry<FrameCursor, Display>> it = this.displays.entrySet().iterator();
        while (it.hasNext()) {
            if (!disps.contains(it.next().getValue())) continue;
            it.remove();
        }
    }

    public class Display
    extends AnchorPane
    implements HighlightedBreakpoint {
        private final ArrayList<VBox> varDisplay = new ArrayList();
        private int curDisplay = -1;
        private Label curCounter;

        public Display(Map<String, DebugVarInfo> prevVars, Map<String, DebugVarInfo> vars) {
            HBox controls = new HBox();
            this.curCounter = new Label("1/1");
            AnchorPane.setTopAnchor((Node)controls, (Double)5.0);
            AnchorPane.setRightAnchor((Node)controls, (Double)5.0);
            this.getChildren().add((Object)controls);
            this.addState(prevVars, vars);
        }

        private VBox makeDisplay(Map<String, DebugVarInfo> prevVars, Map<String, DebugVarInfo> vars) {
            VBox disp = new VBox();
            for (Map.Entry<String, DebugVarInfo> var : vars.entrySet()) {
                DebugVarInfo prev = prevVars == null ? null : prevVars.get(var.getKey());
                HBox row = new HBox();
                Label k = new Label(var.getKey() + ": ");
                k.getStyleClass().add((Object)"debug-info-text");
                Node v = var.getValue().getDisplay(prev);
                v.getStyleClass().add((Object)"debug-info-text");
                row.getChildren().addAll((Object[])new Node[]{k, v});
                disp.getChildren().add((Object)row);
                row.getStyleClass().add((Object)"debug-info");
            }
            return disp;
        }

        public void addState(Map<String, DebugVarInfo> prevVars, Map<String, DebugVarInfo> vars) {
            VBox disp = this.makeDisplay(prevVars, vars);
            this.varDisplay.add(disp);
            if (this.curDisplay >= 0) {
                this.getChildren().remove((Object)this.varDisplay.get(this.curDisplay));
            }
            this.curDisplay = this.varDisplay.size() - 1;
            this.curCounter.setText(this.curDisplay + 1 + "/" + this.varDisplay.size());
            AnchorPane.setTopAnchor((Node)disp, (Double)2.0);
            AnchorPane.setLeftAnchor((Node)disp, (Double)2.0);
            this.getChildren().add((Object)disp);
            JavaFXUtil.addStyleClass((Styleable)this, "debug-info-highlight");
            this.pulse();
        }

        private void pulse() {
            ScaleTransition st = new ScaleTransition(Duration.millis((double)200.0), (Node)this);
            st.setByX(0.3);
            st.setByY(0.3);
            st.setAutoReverse(true);
            st.setCycleCount(2);
            st.play();
        }

        @Override
        public void removeHighlight() {
            JavaFXUtil.removeStyleClass((Styleable)this, "debug-info-highlight");
            JavaFXUtil.addStyleClass((Styleable)this, "debug-info");
        }
    }
}

