/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.editor.stride.BirdseyeManager;
import bluej.editor.stride.FrameEditorTab;
import bluej.parser.AssistContent;
import bluej.parser.entity.EntityResolver;
import bluej.stride.framedjava.ast.AccessPermission;
import bluej.stride.framedjava.ast.JavadocUnit;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.elements.ClassElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ImportElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.errors.CodeError;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.ConstructorFrame;
import bluej.stride.framedjava.frames.ImportFrame;
import bluej.stride.framedjava.frames.InheritedFieldFrame;
import bluej.stride.framedjava.frames.InheritedMethodFrame;
import bluej.stride.framedjava.frames.NormalMethodFrame;
import bluej.stride.framedjava.frames.TopLevelFrame;
import bluej.stride.generic.AssistContentThreadSafe;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.DocumentedMultiCanvasFrame;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameContentRow;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.operations.CustomFrameOperation;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.ClassNameDefTextSlot;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.Implements;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TriangleLabel;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.stride.slots.TypeTextSlot;
import bluej.utility.Utility;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.MultiListener;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.DeepListBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ClassFrame
extends DocumentedMultiCanvasFrame
implements TopLevelFrame<ClassElement> {
    private final SlotLabel abstractLabel = new SlotLabel("abstract", new String[0]);
    private final FrameContentRow importRow;
    private BooleanProperty abstractModifier = new SimpleBooleanProperty(false);
    private TextSlot<NameDefSlotFragment> paramClassName;
    private final InteractionManager editor;
    private final SimpleBooleanProperty showingExtends;
    private final TextSlot<TypeSlotFragment> extendsSlot;
    private final ObservableList<InheritedCanvas> extendsInheritedCanvases = FXCollections.observableArrayList();
    private final FrameCanvas importCanvas;
    private final Implements implementsSlot;
    private ClassElement element;
    private final EntityResolver projectResolver;
    private final FrameCanvas fieldsCanvas;
    private final FrameCanvas constructorsCanvas;
    private final FrameCanvas methodsCanvas;
    private final SlotLabel importsLabel = ClassFrame.makeLabel("Imports");
    private final SlotLabel fieldsLabel = ClassFrame.makeLabel("Fields");
    private final SlotLabel constructorsLabel = ClassFrame.makeLabel("Constructors");
    private final SlotLabel methodsLabel = ClassFrame.makeLabel("Methods");
    private final FrameContentRow fieldsLabelRow;
    private final FrameContentRow constructorsLabelRow;
    private final FrameContentRow methodsLabelRow;
    private final TriangleLabel inheritedLabel;
    private final FrameContentItem endSpacer;
    private final TriangleLabel importTriangleLabel;
    private Map<String, List<AssistContentThreadSafe>> curMembersByClass = Collections.emptyMap();
    private final ObservableList<String> boundImports = FXCollections.observableArrayList();

    private static SlotLabel makeLabel(String content) {
        SlotLabel l = new SlotLabel(content, new String[0]);
        JavaFXUtil.addStyleClass(l, "class-section-label");
        return l;
    }

    public ClassFrame(InteractionManager editor, boolean abstractModifierParam, NameDefSlotFragment className, List<ImportElement> imports, TypeSlotFragment extendsName, List<TypeSlotFragment> implementsList, EntityResolver projectResolver, JavadocUnit documentation, boolean enabled) {
        super(editor, "class", "class-");
        this.editor = editor;
        this.projectResolver = projectResolver;
        this.abstractModifier.set(abstractModifierParam);
        this.endSpacer = new FrameContentItem(){
            private Rectangle r = new Rectangle(1.0, 200.0, (Paint)Color.TRANSPARENT);

            @Override
            public Stream<HeaderItem> getHeaderItemsDeep() {
                return Stream.empty();
            }

            @Override
            public Stream<HeaderItem> getHeaderItemsDirect() {
                return Stream.empty();
            }

            @Override
            public Bounds getSceneBounds() {
                return this.r.localToScene(this.r.getBoundsInLocal());
            }

            @Override
            public Optional<FrameCanvas> getCanvas() {
                return Optional.empty();
            }

            @Override
            public boolean focusLeftEndFromPrev() {
                return false;
            }

            @Override
            public boolean focusRightEndFromNext() {
                return false;
            }

            @Override
            public boolean focusTopEndFromPrev() {
                return false;
            }

            @Override
            public boolean focusBottomEndFromNext() {
                return false;
            }

            @Override
            public void setView(Frame.View oldView, Frame.View newView, SharedTransition animation) {
            }

            @Override
            public Node getNode() {
                return this.r;
            }
        };
        this.setDocumentation(documentation.toString());
        this.paramClassName = new ClassNameDefTextSlot(editor, this, this.getHeaderRow(), "class-name-");
        this.paramClassName.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.paramClassName.setPromptText("class name");
        this.paramClassName.setText(className);
        this.documentationPromptTextProperty().bind((ObservableValue)new SimpleStringProperty("Write a description of your ").concat((Object)this.paramClassName.textProperty()).concat((Object)" class here..."));
        this.fieldsCanvas = new FrameCanvas(editor, this, "class-fields-");
        this.showingExtends = new SimpleBooleanProperty(extendsName != null);
        SlotLabel extendsLabel = new SlotLabel("extends", new String[0]);
        JavaFXUtil.addStyleClass(extendsLabel, "class-extends-caption");
        this.extendsSlot = new TypeTextSlot(editor, this, this.getHeaderRow(), new TypeCompletionCalculator(editor, InteractionManager.Kind.CLASS_NON_FINAL), "class-extends-");
        this.extendsSlot.addValueListener(new SlotTraversalChars(new char[0]){

            @Override
            public void backSpacePressedAtStart(HeaderItem slot) {
                ClassFrame.this.removeExtends();
            }
        });
        this.extendsSlot.addValueListener(SlotTraversalChars.IDENTIFIER);
        this.extendsSlot.setPromptText("parent class");
        if (extendsName != null) {
            this.extendsSlot.setText(extendsName);
        }
        this.implementsSlot = new Implements(this, () -> {
            TypeTextSlot s = new TypeTextSlot(editor, this, this.getHeaderRow(), new TypeCompletionCalculator(editor, InteractionManager.Kind.INTERFACE), "class-");
            s.setPromptText("interface type");
            return s;
        }, () -> this.fieldsCanvas.getFirstCursor().requestFocus());
        implementsList.forEach(t -> this.implementsSlot.addTypeSlotAtEnd(t.getContent()));
        this.inheritedLabel = new TriangleLabel(editor, t -> this.extendsInheritedCanvases.forEach(c -> c.grow((SharedTransition)t)), t -> this.extendsInheritedCanvases.forEach(c -> c.shrink((SharedTransition)t)), new SimpleBooleanProperty(false));
        this.inheritedLabel.setDisable(true);
        this.extendsInheritedCanvases.addListener(c -> this.inheritedLabel.setDisable(this.extendsInheritedCanvases.isEmpty()));
        JavaFXUtil.addChangeListener(this.inheritedLabel.expandedProperty(), b -> editor.updateErrorOverviewBar());
        this.getHeaderRow().bindContentsConcat((ObservableList<ObservableList<HeaderItem>>)FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new HeaderItem[]{this.headerCaptionLabel}), JavaFXUtil.listBool((BooleanExpression)this.abstractModifier, this.abstractLabel), FXCollections.observableArrayList((Object[])new HeaderItem[]{this.paramClassName}), JavaFXUtil.listBool((BooleanExpression)this.showingExtends, extendsLabel, this.extendsSlot, this.inheritedLabel), this.implementsSlot.getHeaderItems()}));
        this.importCanvas = this.createImportsCanvas(imports);
        this.importCanvas.getShowingProperty().set(false);
        this.importTriangleLabel = new TriangleLabel(editor, t -> this.importCanvas.growUsing(t.getProgress()), t -> this.importCanvas.shrinkUsing(t.getOppositeProgress()), this.importCanvas.getShowingProperty());
        JavaFXUtil.addChangeListener(this.importTriangleLabel.expandedProperty(), b -> editor.updateErrorOverviewBar());
        this.importRow = new FrameContentRow((Frame)this, this.importsLabel, this.importTriangleLabel);
        this.fieldsLabelRow = new FrameContentRow((Frame)this, this.fieldsLabel);
        this.addCanvas(this.fieldsLabelRow, this.fieldsCanvas);
        this.constructorsCanvas = new FrameCanvas(editor, this, "class-");
        this.constructorsLabelRow = new FrameContentRow((Frame)this, this.constructorsLabel);
        this.addCanvas(this.constructorsLabelRow, this.constructorsCanvas);
        this.methodsCanvas = new FrameCanvas(editor, this, "class-");
        this.methodsLabelRow = new FrameContentRow((Frame)this, this.methodsLabel);
        this.addCanvas(this.methodsLabelRow, this.methodsCanvas);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public void focusOnBody(TopLevelFrame.BodyFocus on) {
        FrameCursor c;
        if (on == TopLevelFrame.BodyFocus.TOP) {
            c = this.fieldsCanvas.getFirstCursor();
        } else if (on == TopLevelFrame.BodyFocus.BOTTOM) {
            c = this.methodsCanvas.getLastCursor();
        } else {
            Optional<CodeError> error = this.getCurrentErrors().findFirst();
            if (error.isPresent()) {
                error.get().jumpTo(this.editor);
                return;
            }
            NormalMethodFrame act = this.getMethods().stream().filter(f -> f.getName().equals("act") && f.getParamsPane().isEmpty()).findFirst().orElse(null);
            c = act != null ? act.getFirstInternalCursor() : this.methodsCanvas.getFirstCursor();
        }
        c.requestFocus();
        this.editor.scrollTo((Node)c.getNode(), -100.0);
    }

    @Override
    public boolean canDrag() {
        return false;
    }

    @Override
    public void bindMinHeight(DoubleBinding prop) {
        this.getRegion().minHeightProperty().bind((ObservableValue)prop);
    }

    @Override
    public synchronized void regenerateCode() {
        List<CodeElement> fields = this.getMembers(this.fieldsCanvas);
        List<CodeElement> constructors = this.getMembers(this.constructorsCanvas);
        List<CodeElement> methods = this.getMembers(this.methodsCanvas);
        List<ImportElement> imports = Utility.mapList(this.getMembers(this.importCanvas), e -> (ImportElement)e);
        this.element = new ClassElement(this, this.projectResolver, this.abstractModifier.get(), (NameDefSlotFragment)this.paramClassName.getSlotElement(), this.showingExtends.get() ? (TypeSlotFragment)this.extendsSlot.getSlotElement() : null, this.implementsSlot.getTypes(), fields, constructors, methods, new JavadocUnit(this.getDocumentation()), imports, this.frameEnabledProperty.get());
    }

    private List<CodeElement> getMembers(FrameCanvas frameCanvas) {
        ArrayList<CodeElement> members = new ArrayList<CodeElement>();
        for (CodeFrame c : frameCanvas.getBlocksSubtype(CodeFrame.class)) {
            c.regenerateCode();
            members.add((CodeElement)c.getCode());
        }
        return members;
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public synchronized @OnThread(value=Tag.Any, ignoreParent=true) ClassElement getCode() {
        return this.element;
    }

    @Override
    public List<FrameOperation> getContextOperations(InteractionManager editor) {
        return Arrays.asList(new CustomFrameOperation(editor, "addRemoveAbstract", Arrays.asList("Toggle abstract"), EditableSlot.MenuItemOrder.TOGGLE_ABSTRACT, this, () -> this.abstractModifier.set(!this.abstractModifier.get())));
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return new ArrayList<FrameOperation>();
    }

    @Override
    public List<ExtensionDescription> getAvailableInnerExtensions(FrameCanvas canvas, FrameCursor cursor) {
        ExtensionDescription abstractExtension = null;
        if (canvas.equals(this.fieldsCanvas)) {
            abstractExtension = new ExtensionDescription('b', "Toggle abstract", () -> this.abstractModifier.set(!this.abstractModifier.get()));
        }
        ExtensionDescription extendsExtension = null;
        if (!this.showingExtends.get()) {
            extendsExtension = new ExtensionDescription('e', "Add extends declaration", () -> {
                this.addExtends();
                this.extendsSlot.requestFocus();
            });
        }
        ExtensionDescription implementsExtension = new ExtensionDescription('i', "Add implements declaration", () -> this.implementsSlot.addTypeSlotAtEnd(""));
        return Utility.nonNulls(Arrays.asList(abstractExtension, extendsExtension, implementsExtension));
    }

    private void addExtends() {
        this.showingExtends.set(true);
        this.editor.modifiedFrame(this);
    }

    private void removeExtends() {
        this.showingExtends.set(false);
        this.extendsSlot.setText("");
        this.editor.modifiedFrame(this);
    }

    @Override
    public void saved() {
        if (this.extendsInheritedCanvases.isEmpty()) {
            this.updateInheritedItems();
        }
    }

    private FrameCanvas createImportsCanvas(List<ImportElement> imports) {
        final FrameCanvas importCanvas = new FrameCanvas(this.editor, new CanvasParent(){

            @Override
            public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
                return ClassFrame.this.importCanvas.findClosestCursor(sceneX, sceneY, exclude, isDrag, canDescend);
            }

            @Override
            public boolean acceptsType(FrameCanvas canvasBase, Class<? extends Frame> frameClass) {
                return Arrays.asList(ImportFrame.class).contains(frameClass);
            }

            @Override
            public List<ExtensionDescription> getAvailableInnerExtensions(FrameCanvas canvas, FrameCursor cursor) {
                return Collections.emptyList();
            }

            @Override
            public Frame getFrame() {
                return ClassFrame.this;
            }

            @Override
            public InteractionManager getEditor() {
                return ClassFrame.this.editor;
            }
        }, "class-import-");
        importCanvas.setAnimateLeftMarginScale(true);
        ArrayList<ImportElement> importsRev = new ArrayList<ImportElement>(imports);
        Collections.reverse(importsRev);
        importsRev.forEach(item -> importCanvas.insertBlockBefore(item.createFrame(this.editor), importCanvas.getFirstCursor()));
        importCanvas.shrinkUsing((DoubleExpression)new ReadOnlyDoubleWrapper(0.0));
        new DeepListBinding<String>(this.boundImports){
            private final ChangeListener<String> listener;
            private final MultiListener<ObservableStringValue> stringListener;
            {
                super(dest);
                this.listener = (a, b, c) -> this.update();
                this.stringListener = new MultiListener<ObservableStringValue>(v -> {
                    v.addListener(this.listener);
                    return () -> v.removeListener(this.listener);
                });
            }

            @Override
            protected Stream<ObservableList<?>> getListenTargets() {
                return Stream.of(importCanvas.getBlockContents());
            }

            @Override
            protected Stream<String> calculateValues() {
                return importCanvas.getBlockContents().stream().map(f -> (ImportFrame)f).map(ImportFrame::getImport);
            }

            @Override
            protected void update() {
                this.stringListener.listenOnlyTo(importCanvas.getBlockContents().stream().map(f -> (ImportFrame)f).map(ImportFrame::importProperty));
                super.update();
            }
        }.startListening();
        return importCanvas;
    }

    @Override
    public ObservableList<String> getImports() {
        return this.boundImports;
    }

    @Override
    public void addImport(String importSrc) {
        this.importCanvas.insertBlockAfter(new ImportFrame(this.editor, importSrc), this.importCanvas.getLastCursor());
    }

    @Override
    public void addDefaultConstructor() {
        this.constructorsCanvas.getFirstCursor().insertBlockAfter(ConstructorFrame.getFactory().createBlock(this.editor));
    }

    private Comparator<String> getSuperClassComparator() {
        return (a, b) -> {
            if (a == null || b == null) {
                throw new IllegalArgumentException("Null strings for super-class names");
            }
            if (a.equals(b)) {
                return 0;
            }
            if ("java.lang.Object".equals(a)) {
                return 1;
            }
            if ("java.lang.Object".equals(b)) {
                return -1;
            }
            if (this.extendsSlot.getText().equals(a)) {
                return -1;
            }
            if (this.extendsSlot.getText().equals(b)) {
                return 1;
            }
            return a.compareTo((String)b);
        };
    }

    private void updateInheritedItems() {
        this.withInheritedItems(new HashSet<AssistContent.CompletionKind>(Arrays.asList(AssistContent.CompletionKind.FIELD, AssistContent.CompletionKind.METHOD)), membersByClass -> {
            if (membersByClass.equals(this.curMembersByClass)) {
                return;
            }
            this.extendsInheritedCanvases.forEach(c -> this.removeCanvas(c.canvas));
            this.extendsInheritedCanvases.clear();
            List<String> classNames = membersByClass.keySet().stream().sorted(this.getSuperClassComparator()).collect(Collectors.toList());
            Collections.reverse(classNames);
            classNames.forEach(cls -> {
                InheritedCanvas section = new InheritedCanvas((String)cls, classNames.size() == 1);
                if (!this.inheritedLabel.expandedProperty().get()) {
                    section.canvas.shrinkUsing((DoubleExpression)new ReadOnlyDoubleWrapper(0.0));
                    if (section.optionalCollapse != null) {
                        section.optionalCollapse.setVisible(false);
                    }
                    if (section.precedingDividerLabel != null) {
                        section.precedingDividerLabel.shrinkInstantly();
                    }
                }
                this.extendsInheritedCanvases.add((Object)section);
                this.addCanvas(section.precedingDivider, section.canvas, 0);
                List items = (List)membersByClass.get(cls);
                List<AssistContentThreadSafe> methods = items.stream().filter(a -> a.getKind() == AssistContent.CompletionKind.METHOD).collect(Collectors.toList());
                List<AssistContentThreadSafe> fields = items.stream().filter(a -> a.getKind() == AssistContent.CompletionKind.FIELD).collect(Collectors.toList());
                Collections.reverse(fields);
                fields.forEach(field -> section.canvas.insertBlockBefore(new InheritedFieldFrame(this.editor, AccessPermission.fromAccess(field.getAccessPermission()), field.getType(), field.getName()), section.canvas.getFirstCursor()));
                Collections.reverse(methods);
                methods.forEach(method -> section.canvas.insertBlockBefore(new InheritedMethodFrame(this.editor, this, (String)cls, AccessPermission.fromAccess(method.getAccessPermission()), method.getType(), method.getName(), method.getParams()), section.canvas.getFirstCursor()));
            });
            this.extendsInheritedCanvases.forEach(s -> s.canvas.getCursors().forEach(c -> c.getNode().setFocusTraversable(false)));
            this.curMembersByClass = membersByClass;
        });
    }

    public void withInheritedItems(Set<AssistContent.CompletionKind> kinds, FXConsumer<Map<String, List<AssistContentThreadSafe>>> handler) {
        this.editor.withAccessibleMembers(this.element.getPosInsideClass(), kinds, true, allMembers -> {
            HashMap<String, List> methodsByClass = new HashMap<String, List>();
            for (AssistContentThreadSafe a : allMembers) {
                if (a.getDeclaringClass().equals(this.paramClassName.getText())) continue;
                if (methodsByClass.containsKey(a.getDeclaringClass())) {
                    ((List)methodsByClass.get(a.getDeclaringClass())).add(a);
                    continue;
                }
                ArrayList<AssistContentThreadSafe> l = new ArrayList<AssistContentThreadSafe>();
                l.add(a);
                methodsByClass.put(a.getDeclaringClass(), l);
            }
            methodsByClass.forEach((k, v) -> v.sort(Comparator.comparing(AssistContentThreadSafe::getName).thenComparing(ac -> Utility.mapList(ac.getParams(), AssistContent.ParamInfo::getUnqualifiedType), Utility.listComparator())));
            handler.accept(methodsByClass);
        });
    }

    @Override
    public BirdseyeManager prepareBirdsEyeView(SharedTransition animate) {
        final List<FrameCanvas> canvases = Arrays.asList(this.constructorsCanvas, this.methodsCanvas);
        int startingCanvas = 0;
        while (canvases.get(startingCanvas).blockCount() == 0) {
            ++startingCanvas;
        }
        Frame startingFrame = (Frame)canvases.get(startingCanvas).getBlockContents().get(0);
        Node focusOwner = canvases.get(0).getNode().getScene().getFocusOwner();
        block1: for (int i = 0; i < canvases.size(); ++i) {
            for (Frame f : canvases.get(i).getBlockContents()) {
                if (!this.nodeInside(focusOwner, (Parent)f.getNode())) continue;
                startingCanvas = i;
                startingFrame = f;
                break block1;
            }
        }
        final int finalStartingCanvas = startingCanvas;
        final Frame finalStartingFrame = startingFrame;
        return new BirdseyeManager(){
            private int canvasIndex;
            private Frame frame;
            {
                this.canvasIndex = finalStartingCanvas;
                this.frame = finalStartingFrame;
            }

            public Node getNodeForRectangle() {
                return this.frame.getNode();
            }

            private Frame getFrameAt(double sceneX, double sceneY) {
                for (FrameCanvas canvas : canvases) {
                    for (Frame f : canvas.getBlockContents()) {
                        Node n = f.getNode();
                        Point2D scene = n.localToScene(n.getBoundsInLocal().getMinX(), n.getBoundsInLocal().getMinY());
                        if (!(scene.getX() <= sceneX) || !(sceneX < scene.getX() + n.getBoundsInLocal().getWidth()) || !(scene.getY() <= sceneY) || !(sceneY < scene.getY() + n.getBoundsInLocal().getHeight())) continue;
                        return f;
                    }
                }
                return null;
            }

            public boolean canClick(double sceneX, double sceneY) {
                return this.getFrameAt(sceneX, sceneY) != null;
            }

            public FrameCursor getClickedTarget(double sceneX, double sceneY) {
                Frame f = this.getFrameAt(sceneX, sceneY);
                if (f != null) {
                    return f.getFirstInternalCursor();
                }
                return null;
            }

            public FrameCursor getCursorForCurrent() {
                return this.frame.getFirstInternalCursor();
            }

            public void up() {
                Frame before = ((FrameCanvas)canvases.get(this.canvasIndex)).getFrameBefore(((FrameCanvas)canvases.get(this.canvasIndex)).getCursorBefore(this.frame));
                if (before == null) {
                    for (int prospective = this.canvasIndex - 1; prospective >= 0; --prospective) {
                        if (((FrameCanvas)canvases.get(prospective)).blockCount() <= 0) continue;
                        this.canvasIndex = prospective;
                        this.frame = ((FrameCanvas)canvases.get(this.canvasIndex)).getFrameBefore(((FrameCanvas)canvases.get(this.canvasIndex)).getLastCursor());
                        return;
                    }
                } else {
                    this.frame = before;
                }
            }

            public void down() {
                Frame after = ((FrameCanvas)canvases.get(this.canvasIndex)).getFrameAfter(((FrameCanvas)canvases.get(this.canvasIndex)).getCursorAfter(this.frame));
                if (after == null) {
                    for (int prospective = this.canvasIndex + 1; prospective < canvases.size(); ++prospective) {
                        if (((FrameCanvas)canvases.get(prospective)).blockCount() <= 0) continue;
                        this.canvasIndex = prospective;
                        this.frame = ((FrameCanvas)canvases.get(this.canvasIndex)).getFrameAfter(((FrameCanvas)canvases.get(this.canvasIndex)).getFirstCursor());
                        return;
                    }
                } else {
                    this.frame = after;
                }
            }
        };
    }

    private boolean nodeInside(Node target, Parent parent) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            if (node == target) {
                return true;
            }
            if (!(node instanceof Parent) || !this.nodeInside(target, (Parent)node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDoBirdseye() {
        return !this.constructorsCanvas.getBlockContents().isEmpty() || !this.methodsCanvas.getBlockContents().isEmpty();
    }

    @Override
    public List<NormalMethodFrame> getMethods() {
        return this.methodsCanvas.getBlocksSubtype(NormalMethodFrame.class);
    }

    @Override
    public List<ConstructorFrame> getConstructors() {
        return this.constructorsCanvas.getBlocksSubtype(ConstructorFrame.class);
    }

    @Override
    public void insertAtEnd(Frame frame) {
        this.methodsCanvas.getLastCursor().insertBlockAfter(frame);
    }

    public FrameCanvas getfieldsCanvas() {
        return this.fieldsCanvas;
    }

    public FrameCanvas getConstructorsCanvas() {
        return this.constructorsCanvas;
    }

    public FrameCanvas getMethodsCanvas() {
        return this.methodsCanvas;
    }

    @Override
    public ObservableStringValue nameProperty() {
        return this.paramClassName.textProperty();
    }

    public void findMethod(String methodName, List<AssistContent.ParamInfo> params, FXConsumer<NormalMethodFrame> callback) {
        ClassElement el = this.getCode();
        SwingUtilities.invokeLater(() -> {
            Optional<NormalMethodFrame> method = el.streamMethods().filter(e -> {
                if (!(e instanceof NormalMethodElement)) {
                    return false;
                }
                NormalMethodElement m = (NormalMethodElement)e;
                return m.equalDeclaration(methodName, params, el);
            }).map(e -> ((NormalMethodElement)e).getFrame()).findFirst();
            Platform.runLater(() -> callback.accept(method.orElse(null)));
        });
    }

    @Override
    public Stream<RecallableFocus> getFocusables() {
        return ClassFrame.getFocusablesInclContained(this);
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animateProgress) {
        boolean java;
        this.setViewNoOverride(oldView, newView, animateProgress);
        boolean bl = java = newView == Frame.View.JAVA_PREVIEW;
        if (oldView == Frame.View.JAVA_PREVIEW || newView == Frame.View.JAVA_PREVIEW) {
            this.fieldsCanvas.previewCurly(java, true, false, this.header.getLeftFirstItem(), null, animateProgress);
            this.methodsCanvas.previewCurly(java, false, true, this.header.getLeftFirstItem(), null, animateProgress);
        }
        this.getCanvases().forEach(canvas -> {
            canvas.setView(oldView, newView, animateProgress);
            canvas.getCursors().forEach(c -> c.setView(newView, animateProgress));
        });
        if (!this.extendsInheritedCanvases.isEmpty() && newView != Frame.View.NORMAL) {
            this.inheritedLabel.expandedProperty().set(false);
        }
        this.inheritedLabel.setVisible(newView == Frame.View.NORMAL);
        List<FrameContentRow> labelRows = Arrays.asList(this.importRow, this.fieldsLabelRow, this.constructorsLabelRow, this.methodsLabelRow);
        if (newView == Frame.View.NORMAL) {
            animateProgress.addOnStopped(() -> {
                this.importTriangleLabel.setVisible(true);
                this.importTriangleLabel.setManaged(true);
                labelRows.forEach(r -> r.setSnapToPixel(true));
            });
        } else {
            labelRows.forEach(r -> r.setSnapToPixel(false));
            this.importTriangleLabel.setVisible(false);
            this.importTriangleLabel.setManaged(false);
        }
        if (java) {
            this.importTriangleLabel.expandedProperty().set(true);
        } else if (newView == Frame.View.BIRDSEYE) {
            this.importTriangleLabel.expandedProperty().set(false);
        }
        List<SlotLabel> animateLabels = Arrays.asList(this.importsLabel, this.fieldsLabel, this.constructorsLabel, this.methodsLabel);
        if (java) {
            animateLabels.forEach(l -> l.shrinkVertically(animateProgress));
        } else if (oldView == Frame.View.JAVA_PREVIEW) {
            animateLabels.forEach(l -> l.growVertically(animateProgress));
        }
    }

    @Override
    public void compiled() {
        this.updateInheritedItems();
    }

    @Override
    public FrameCanvas getImportCanvas() {
        return this.importCanvas;
    }

    @Override
    public void ensureImportCanvasShowing() {
        this.importCanvas.getShowingProperty().set(true);
    }

    @Override
    public Stream<FrameCanvas> getPersistentCanvases() {
        return this.getCanvases().filter(canvas -> !this.extendsInheritedCanvases.contains(canvas));
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return this.paramClassName;
    }

    @Override
    public void focusName() {
        this.paramClassName.requestFocus(Focus.LEFT);
    }

    @Override
    public boolean acceptsType(FrameCanvas canvas, Class<? extends Frame> frameClass) {
        if (canvas == this.fieldsCanvas) {
            return this.editor.getDictionary().isValidField(frameClass);
        }
        if (canvas == this.methodsCanvas) {
            return this.editor.getDictionary().isValidClassMethod(frameClass);
        }
        if (canvas == this.constructorsCanvas) {
            return this.editor.getDictionary().isValidConstructor(frameClass);
        }
        return false;
    }

    @Override
    public boolean tryRedirectCursor(FrameCanvas canvas, char c) {
        if ((canvas == this.constructorsCanvas || canvas == this.methodsCanvas) && c == 'v') {
            return this.fieldsCanvas.getLastCursor().keyTyped((FrameEditorTab)this.editor, this.fieldsCanvas, c, true);
        }
        if ((canvas == this.fieldsCanvas || canvas == this.methodsCanvas) && c == 'c') {
            return this.constructorsCanvas.getLastCursor().keyTyped((FrameEditorTab)this.editor, this.constructorsCanvas, c, true);
        }
        if (!(canvas != this.constructorsCanvas && canvas != this.fieldsCanvas || c != 'm' && c != 'a')) {
            return this.methodsCanvas.getLastCursor().keyTyped((FrameEditorTab)this.editor, this.methodsCanvas, c, true);
        }
        return false;
    }

    @Override
    public CanvasParent.CanvasKind getChildKind(FrameCanvas c) {
        if (c == this.fieldsCanvas) {
            return CanvasParent.CanvasKind.FIELDS;
        }
        if (c == this.constructorsCanvas) {
            return CanvasParent.CanvasKind.CONSTRUCTORS;
        }
        if (c == this.methodsCanvas) {
            return CanvasParent.CanvasKind.METHODS;
        }
        return CanvasParent.CanvasKind.STATEMENTS;
    }

    @Override
    protected void modifyChildren(List<FrameContentItem> updatedChildren) {
        super.modifyChildren(updatedChildren);
        updatedChildren.add(0, this.importRow);
        updatedChildren.add(1, this.importCanvas);
        updatedChildren.add(this.endSpacer);
    }

    @Override
    public void restore(ClassElement target) {
        this.paramClassName.setText(target.getName());
        this.abstractModifier.set(target.isAbstract());
        this.restoreExtends(target);
        this.implementsSlot.setTypes(target.getImplements());
        this.importCanvas.restore(target.getImports(), this.editor);
        this.methodsCanvas.restore(target.getMethods(), this.editor);
        this.fieldsCanvas.restore(target.getFields(), this.editor);
        this.constructorsCanvas.restore(target.getConstructors(), this.editor);
    }

    private void restoreExtends(ClassElement target) {
        String targetExtends = target.getExtends();
        if (targetExtends != null) {
            if (!this.showingExtends.get()) {
                this.addExtends();
            }
            if (!this.extendsSlot.getText().equals(targetExtends)) {
                this.extendsSlot.setText(targetExtends);
            }
        } else if (this.showingExtends.get()) {
            this.removeExtends();
        }
    }

    private class InheritedCanvas {
        public final String superClassName;
        public final FrameCanvas canvas;
        public final FrameContentRow precedingDivider;
        public final SlotLabel precedingDividerLabel;
        public final TriangleLabel optionalCollapse;

        public InheritedCanvas(String superClassName, boolean single) {
            this.canvas = new FrameCanvas(ClassFrame.this.editor, new CanvasParent(){

                @Override
                public FrameCursor findCursor(double sceneX, double sceneY, FrameCursor prevCursor, FrameCursor nextCursor, List<Frame> exclude, boolean isDrag, boolean canDescend) {
                    return null;
                }

                @Override
                public boolean acceptsType(FrameCanvas canvasBase, Class<? extends Frame> frameClass) {
                    return Arrays.asList(InheritedMethodFrame.class, InheritedFieldFrame.class).contains(frameClass);
                }

                @Override
                public List<ExtensionDescription> getAvailableInnerExtensions(FrameCanvas canvas, FrameCursor cursor) {
                    return Collections.emptyList();
                }

                @Override
                public Frame getFrame() {
                    return ClassFrame.this;
                }

                @Override
                public InteractionManager getEditor() {
                    return ClassFrame.this.editor;
                }

                @Override
                public void modifiedCanvasContent() {
                }
            }, "class-inherited-"){

                @Override
                public FrameCursor findClosestCursor(double sceneX, double sceneY, List<Frame> exclude, boolean isDrag, boolean canDescend) {
                    return null;
                }

                @Override
                public FrameCursor getFirstCursor() {
                    return null;
                }

                @Override
                public FrameCursor getLastCursor() {
                    return null;
                }
            };
            this.superClassName = superClassName;
            if (single) {
                this.precedingDividerLabel = null;
                this.precedingDivider = null;
                this.optionalCollapse = null;
            } else if (superClassName.equals("java.lang.Object")) {
                this.precedingDividerLabel = new SlotLabel("Inherited from Object", "class-inherited-label");
                this.optionalCollapse = new TriangleLabel(ClassFrame.this.editor, t -> this.canvas.growUsing(t.getProgress()), t -> this.canvas.shrinkUsing(t.getOppositeProgress()), new SimpleBooleanProperty(false));
                this.precedingDivider = new FrameContentRow((Frame)ClassFrame.this, this.precedingDividerLabel, this.optionalCollapse);
            } else {
                this.precedingDividerLabel = new SlotLabel("Inherited from " + superClassName, "class-inherited-label");
                this.precedingDivider = new FrameContentRow((Frame)ClassFrame.this, this.precedingDividerLabel);
                this.optionalCollapse = null;
            }
        }

        public void grow(SharedTransition t) {
            if (this.optionalCollapse == null || this.optionalCollapse.expandedProperty().get()) {
                this.canvas.growUsing(t.getProgress());
            }
            this.precedingDividerLabel.growVertically(t);
            this.precedingDividerLabel.setLeftPadding(this.canvas.leftMargin().get());
            if (this.optionalCollapse != null) {
                this.optionalCollapse.setVisible(true);
            }
        }

        public void shrink(SharedTransition t) {
            this.canvas.shrinkUsing(t.getOppositeProgress());
            this.precedingDividerLabel.shrinkVertically(t);
            if (this.optionalCollapse != null) {
                this.optionalCollapse.setVisible(false);
            }
        }
    }
}

