/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.NameDefSlotFragment;
import bluej.stride.framedjava.ast.TextSlotFragment;
import bluej.stride.framedjava.ast.TypeSlotFragment;
import bluej.stride.framedjava.canvases.JavaCanvas;
import bluej.stride.framedjava.elements.CatchElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.DebuggableParentFrame;
import bluej.stride.framedjava.frames.GreenfootFrameUtil;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleCanvasFrame;
import bluej.stride.operations.FrameOperation;
import bluej.stride.slots.SlotLabel;
import bluej.stride.slots.SlotTraversalChars;
import bluej.stride.slots.TextSlot;
import bluej.stride.slots.TypeCompletionCalculator;
import bluej.stride.slots.TypeTextSlot;
import bluej.stride.slots.VariableNameDefTextSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.value.ChangeListener;

public class CatchFrame
extends SingleCanvasFrame
implements CodeFrame<CatchElement>,
DebuggableParentFrame {
    private final TextSlot<TypeSlotFragment> exceptionType;
    private final TextSlot<NameDefSlotFragment> exceptionName;
    private CatchElement element;

    private CatchFrame(InteractionManager editor) {
        super(editor, "catch", "catch-");
        this.exceptionType = this.initialiseTextSlot("Type", new TypeSlotFragment(""), new TypeTextSlot(editor, this, this, this.getHeaderRow(), new TypeCompletionCalculator(editor, Throwable.class), "catch-"));
        this.exceptionName = this.initialiseTextSlot("Name", new NameDefSlotFragment(""), new VariableNameDefTextSlot(editor, this, this, this.getHeaderRow(), "catch-"));
        this.setHeaderRow(new SlotLabel("(", new String[0]), this.exceptionType, this.exceptionName, new SlotLabel(")", new String[0]));
        ChangeListener changeListener = (a, b, newVal) -> this.updateSidebarCurried("catch ").accept(this.exceptionType.getText() + " " + this.exceptionName.getText());
        this.exceptionType.textProperty().addListener(changeListener);
        this.exceptionName.textProperty().addListener(changeListener);
    }

    public CatchFrame(InteractionManager editor, TypeSlotFragment exceptionTypeFragment, NameDefSlotFragment exceptionNameFragment, boolean enabled) {
        this(editor);
        this.exceptionType.setText(exceptionTypeFragment);
        this.exceptionName.setText(exceptionNameFragment);
        this.frameEnabledProperty.set(enabled);
    }

    private <F extends TextSlotFragment> TextSlot<F> initialiseTextSlot(String promptText, F value, TextSlot<F> textSlot) {
        textSlot.setPromptText("exception" + promptText);
        textSlot.setText(value);
        textSlot.addFocusListener(this);
        textSlot.addValueListener(SlotTraversalChars.IDENTIFIER);
        return textSlot;
    }

    public static FrameFactory<CatchFrame> getFactory() {
        return new FrameFactory<CatchFrame>(){

            @Override
            public CatchFrame createBlock(InteractionManager editor) {
                return new CatchFrame(editor);
            }

            @Override
            public Class<CatchFrame> getBlockClass() {
                return CatchFrame.class;
            }
        };
    }

    @Override
    public boolean acceptsType(FrameCanvas canvas, Class<? extends Frame> blockClass) {
        return this.getEditor().getDictionary().isValidStatment(blockClass);
    }

    @Override
    public List<FrameOperation> getCutCopyPasteOperations(InteractionManager editor) {
        return GreenfootFrameUtil.cutCopyPasteOperations(editor);
    }

    @Override
    public FrameCanvas createCanvas(InteractionManager editor, String stylePrefix) {
        return new JavaCanvas(editor, this, stylePrefix, false);
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return ((JavaCanvas)this.getParentCanvas()).showDebugBefore(this, debug);
    }

    @Override
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return ((JavaCanvas)this.getCanvas()).showDebugBefore(null, debug);
    }

    @Override
    public void regenerateCode() {
        ArrayList<CodeElement> contents = new ArrayList<CodeElement>();
        for (CodeFrame f : this.canvas.getBlocksSubtype(CodeFrame.class)) {
            f.regenerateCode();
            contents.add((CodeElement)f.getCode());
        }
        this.element = new CatchElement(this, (TypeSlotFragment)this.exceptionType.getSlotElement(), (NameDefSlotFragment)this.exceptionName.getSlotElement(), contents, this.frameEnabledProperty.get());
    }

    @Override
    public CatchElement getCode() {
        return this.element;
    }

    public Collection<? extends Frame> getValidPulledStatements() {
        this.canvas.getBlockContents().forEach(frame -> frame.setParentCanvas(null));
        return this.canvas.getBlockContents();
    }
}

