/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.errors.Correction;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.stride.framedjava.slots.ExpressionSlot;
import java.util.List;
import java.util.Set;

public class UndeclaredVariableInExpressionError
extends DirectSlotError {
    private final String varName;
    private final int startPosInSlot;
    private final int endPosInSlot;
    private List<? extends FixSuggestion> corrections;

    public UndeclaredVariableInExpressionError(StringSlotFragment slotFragment, String varName, int startPosInSlot, int endPosInSlot, ExpressionSlot slot, Set<String> possibleCorrections) {
        super(slotFragment);
        this.varName = varName;
        this.startPosInSlot = startPosInSlot;
        this.endPosInSlot = endPosInSlot;
        this.corrections = Correction.winnowAndCreateCorrections(varName, possibleCorrections.stream().map(Correction.SimpleCorrectionInfo::new), s -> slot.replace(startPosInSlot, endPosInSlot, this.isJavaPos(), (String)s));
    }

    @Override
    public int getStartPosition() {
        return this.startPosInSlot;
    }

    @Override
    public int getEndPosition() {
        return this.endPosInSlot;
    }

    @Override
    public String getMessage() {
        return "Undeclared variable: " + this.varName;
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }
}

