/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.stride.framedjava.errors.FixSuggestion;
import bluej.utility.Utility;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Correction
extends FixSuggestion {
    private final String correction;
    private final String display;
    private Consumer<String> replacer;
    private static final int MAX_EDIT_DISTANCE = 2;

    private Correction(String correction, Consumer<String> replacer, String display) {
        this.correction = correction;
        this.display = display;
        this.replacer = replacer;
    }

    @Override
    public String getDescription() {
        return "Correct to: " + this.display;
    }

    @Override
    public void execute() {
        this.replacer.accept(this.correction);
    }

    public static List<Correction> winnowAndCreateCorrections(String cur, Stream<CorrectionInfo> possibleCorrections, Consumer<String> replacer) {
        return possibleCorrections.map(n -> new StringAndDist((CorrectionInfo)n, Utility.editDistance(cur.toLowerCase(), n.getCorrection().toLowerCase()))).filter(sd -> sd.distance <= 2).sorted((a, b) -> Integer.compare(a.distance, b.distance)).limit(3L).map(sd -> new Correction(sd.value.getCorrection(), replacer, sd.value.getDisplay())).collect(Collectors.toList());
    }

    public static class SimpleCorrectionInfo
    implements CorrectionInfo {
        private String correction;

        public SimpleCorrectionInfo(String correction) {
            this.correction = correction;
        }

        @Override
        public String getCorrection() {
            return this.correction;
        }

        @Override
        public String getDisplay() {
            return this.correction;
        }
    }

    public static interface CorrectionInfo {
        public String getCorrection();

        public String getDisplay();
    }

    private static class StringAndDist {
        public final CorrectionInfo value;
        public final int distance;

        public StringAndDist(CorrectionInfo value, int distance) {
            this.value = value;
            this.distance = distance;
        }
    }
}

