/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaContainerDebugHandler;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.ast.SlotFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.framedjava.frames.WhileFrame;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;

public class WhileElement
extends ContainerCodeElement
implements JavaSingleLineDebugHandler,
JavaContainerDebugHandler {
    public static final String ELEMENT = "while";
    private final FilledExpressionSlotFragment condition;
    private final List<CodeElement> contents;
    private WhileFrame frame;

    public WhileElement(WhileFrame frame, FilledExpressionSlotFragment condition, List<CodeElement> contents, boolean enabled) {
        this.frame = frame;
        this.condition = condition;
        this.contents = contents;
        this.enable = enabled;
        contents.forEach(c -> c.setParent(this));
    }

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        return this.contents.subList(0, this.contents.indexOf(c));
    }

    @Override
    public JavaSource toJavaSource() {
        return JavaSource.createCompoundStatement(this.frame, this, this, Arrays.asList(WhileElement.f(this.frame, "while ("), this.condition, WhileElement.f(this.frame, ")")), CodeElement.toJavaCodes(this.contents));
    }

    @Override
    public Element toXML() {
        Element whileEl = new Element(ELEMENT);
        whileEl.addAttribute(new Attribute("condition", this.condition.getContent()));
        whileEl.addAttribute(new Attribute("condition-java", this.condition.getJavaCode()));
        this.addEnableAttribute(whileEl);
        for (CodeElement c : this.contents) {
            whileEl.appendChild((Node)c.toXML());
        }
        return whileEl;
    }

    public WhileElement(Element el) {
        this.condition = new FilledExpressionSlotFragment(el.getAttributeValue("condition"), el.getAttributeValue("condition-java"));
        this.contents = new ArrayList<CodeElement>();
        for (int i = 0; i < el.getChildElements().size(); ++i) {
            Element child = el.getChildElements().get(i);
            CodeElement member = Loader.loadElement(child);
            this.contents.add(member);
            member.setParent(this);
        }
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    @Override
    public Frame createFrame(InteractionManager editor) {
        this.frame = new WhileFrame(editor, this.condition, this.isEnable());
        for (CodeElement c : this.contents) {
            this.frame.getCanvas().insertBlockAfter(c.createFrame(editor), null);
        }
        return this.frame;
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public HighlightedBreakpoint showDebugAtEnd(DebugInfo debug) {
        return this.frame.showDebugAtEnd(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public Stream<CodeElement> streamContained() {
        return WhileElement.streamContained(this.contents);
    }

    @Override
    protected Stream<SlotFragment> getDirectSlotFragments() {
        return Stream.of(this.condition);
    }
}

