/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.elements;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.ast.JavaContainerDebugHandler;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.JavaSingleLineDebugHandler;
import bluej.stride.framedjava.ast.JavaSource;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.ContainerCodeElement;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SandwichCanvasesFrame;
import bluej.utility.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class SandwichCanvasesElement
extends ContainerCodeElement
implements JavaSingleLineDebugHandler {
    private SandwichCanvasesFrame frame;
    private final String frameCaption;
    private final String intermediateCanvasElement;
    private final String intermediateCanvasJavaCaption;
    private final String tailCanvasCaption;
    private List<CodeElement> firstCanvasContents;
    private List<List<CodeElement>> intermediateCanvasContents;
    private List<CodeElement> tailCanvasContents;

    protected SandwichCanvasesElement(String frameCaption, String intermediateCanvasElement, String intermediateCanvasJavaCaption, String tailCanvasCaption) {
        this.frameCaption = frameCaption;
        this.intermediateCanvasElement = intermediateCanvasElement;
        this.intermediateCanvasJavaCaption = intermediateCanvasJavaCaption;
        this.tailCanvasCaption = tailCanvasCaption;
    }

    protected SandwichCanvasesElement(SandwichCanvasesFrame frame, String frameCaption, List<CodeElement> firstCanvasContents, String intermediateCanvasElement, String intermediateCanvasJavaCaption, List<List<CodeElement>> intermediateCanvasContents, String tailCanvasCaption, List<CodeElement> tailCanvasContents, boolean enabled) {
        this(frameCaption, intermediateCanvasElement, intermediateCanvasJavaCaption, tailCanvasCaption);
        this.frame = frame;
        this.firstCanvasContents = firstCanvasContents;
        this.firstCanvasContents.forEach(c -> c.setParent(this));
        this.intermediateCanvasContents = intermediateCanvasContents;
        this.intermediateCanvasContents.forEach(cs -> cs.forEach(c -> c.setParent(this)));
        this.tailCanvasContents = tailCanvasContents;
        if (this.tailCanvasContents != null) {
            this.tailCanvasContents.forEach(c -> c.setParent(this));
        }
        this.enable = enabled;
    }

    public void loadElement(Element el) {
        this.loadMainAttributes(el);
        this.firstCanvasContents = new ArrayList<CodeElement>();
        Element firstStatementsEl = el.getChildElements(this.frameCaption + "Statements").get(0);
        for (int i = 0; i < firstStatementsEl.getChildElements().size(); ++i) {
            Element child = firstStatementsEl.getChildElements().get(i);
            CodeElement member = Loader.loadElement(child);
            this.firstCanvasContents.add(member);
            member.setParent(this);
        }
        this.intermediateCanvasContents = new ArrayList<List<CodeElement>>();
        Elements intermediateCanvasElements = el.getChildElements(this.intermediateCanvasElement);
        for (int i = 0; i < intermediateCanvasElements.size(); ++i) {
            Element intermediateEl = intermediateCanvasElements.get(i);
            this.loadIntermediateAttributes(intermediateEl);
            ArrayList<CodeElement> body = new ArrayList<CodeElement>();
            for (int j = 0; j < intermediateEl.getChildElements().size(); ++j) {
                CodeElement member = Loader.loadElement(intermediateEl.getChildElements().get(j));
                body.add(member);
                member.setParent(this);
            }
            this.intermediateCanvasContents.add(body);
        }
        if (el.getChildElements(this.tailCanvasCaption).size() == 1) {
            this.tailCanvasContents = new ArrayList<CodeElement>();
            Element tailCanvasEl = el.getChildElements(this.tailCanvasCaption).get(0);
            for (int i = 0; i < tailCanvasEl.getChildElements().size(); ++i) {
                Element child = tailCanvasEl.getChildElements().get(i);
                CodeElement member = Loader.loadElement(child);
                this.tailCanvasContents.add(member);
                member.setParent(this);
            }
        } else if (el.getChildElements(this.tailCanvasCaption).size() == 0) {
            this.tailCanvasContents = null;
        } else {
            throw new IllegalArgumentException();
        }
        this.enable = new Boolean(el.getAttributeValue("enable"));
    }

    protected abstract void loadMainAttributes(Element var1);

    protected abstract void loadIntermediateAttributes(Element var1);

    @Override
    public JavaSource toJavaSource() {
        JavaContainerDebugHandler firstCanvasHandler = debug -> this.frame.getFirstCanvasDebug().showDebugAtEnd(debug);
        JavaSource src = JavaSource.createCompoundStatement(this.frame, this, firstCanvasHandler, this.getFirstHeaderFragment(), CodeElement.toJavaCodes(this.firstCanvasContents));
        for (int i = 0; i < this.intermediateCanvasContents.size(); ++i) {
            int iFinal = i;
            JavaContainerDebugHandler intermediateCanvasHandler = debug -> this.frame.getIntermediateCanvasDebug(iFinal).showDebugAtEnd(debug);
            src.appened(JavaSource.createCompoundStatement(this.frame, this, intermediateCanvasHandler, this.getIntermediateHeaderFragment(i), CodeElement.toJavaCodes(this.intermediateCanvasContents.get(i))));
        }
        if (this.tailCanvasContents != null) {
            JavaContainerDebugHandler tailCanvasHandler = debug -> this.frame.getTailCanvasDebug().showDebugAtEnd(debug);
            src.appened(JavaSource.createCompoundStatement(this.frame, this, tailCanvasHandler, Arrays.asList(SandwichCanvasesElement.f(this.frame, this.tailCanvasCaption)), CodeElement.toJavaCodes(this.tailCanvasContents)));
        }
        return src;
    }

    protected List<JavaFragment> getFirstHeaderFragment() {
        return new ArrayList<JavaFragment>(Arrays.asList(SandwichCanvasesElement.f(this.frame, this.frameCaption)));
    }

    protected List<JavaFragment> getIntermediateHeaderFragment(int index) {
        return new ArrayList<JavaFragment>(Arrays.asList(SandwichCanvasesElement.f(this.frame, this.intermediateCanvasJavaCaption)));
    }

    @Override
    public Element toXML() {
        Element mainEl = new Element(this.frameCaption);
        this.addMainAttributes(mainEl);
        this.addEnableAttribute(mainEl);
        Element firstCanvasStatementsEl = new Element(this.frameCaption + "Statements");
        this.firstCanvasContents.forEach(c -> firstCanvasStatementsEl.appendChild((Node)c.toXML()));
        mainEl.appendChild((Node)firstCanvasStatementsEl);
        for (int i = 0; i < this.intermediateCanvasContents.size(); ++i) {
            Element intermediateCanvasEl = new Element(this.intermediateCanvasElement);
            this.addIntermediateAttributes(intermediateCanvasEl, i);
            this.intermediateCanvasContents.get(i).forEach(f -> intermediateCanvasEl.appendChild((Node)f.toXML()));
            mainEl.appendChild((Node)intermediateCanvasEl);
        }
        if (this.tailCanvasContents != null) {
            Element tailCanvasEl = new Element(this.tailCanvasCaption);
            this.tailCanvasContents.forEach(c -> tailCanvasEl.appendChild((Node)c.toXML()));
            mainEl.appendChild((Node)tailCanvasEl);
        }
        return mainEl;
    }

    protected abstract void addMainAttributes(Element var1);

    protected abstract void addIntermediateAttributes(Element var1, int var2);

    @Override
    public Frame createFrame(InteractionManager editor) {
        Function<CodeElement, Frame> makeFrame = e -> e.createFrame(editor);
        this.frame = this.buildFrame(editor, Utility.mapList(this.firstCanvasContents, makeFrame), Utility.mapList(this.intermediateCanvasContents, cs -> Utility.mapList(cs, makeFrame)), this.tailCanvasContents == null ? null : Utility.mapList(this.tailCanvasContents, makeFrame), this.isEnable());
        return this.frame;
    }

    @OnThread(value=Tag.FX)
    protected abstract SandwichCanvasesFrame buildFrame(InteractionManager var1, List<Frame> var2, List<List<Frame>> var3, List<Frame> var4, boolean var5);

    @Override
    public List<CodeElement> childrenUpTo(CodeElement c) {
        if (this.firstCanvasContents.contains(c)) {
            return this.firstCanvasContents.subList(0, this.firstCanvasContents.indexOf(c));
        }
        if (this.intermediateCanvasContents != null) {
            for (List<CodeElement> intermediateCanvasContent : this.intermediateCanvasContents) {
                if (!intermediateCanvasContent.contains(c)) continue;
                return intermediateCanvasContent.subList(0, intermediateCanvasContent.indexOf(c));
            }
        }
        if (this.tailCanvasContents != null && this.tailCanvasContents.contains(c)) {
            return this.tailCanvasContents.subList(0, this.tailCanvasContents.indexOf(c));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public HighlightedBreakpoint showDebugBefore(DebugInfo debug) {
        return this.frame.showDebugBefore(debug);
    }

    @Override
    public void show(Frame.ShowReason reason) {
        this.frame.show(reason);
    }

    @Override
    public Stream<CodeElement> streamContained() {
        Stream intermediateCanvasStream = this.intermediateCanvasContents.stream().flatMap(c -> SandwichCanvasesElement.streamContained(c));
        return Utility.concat(SandwichCanvasesElement.streamContained(this.firstCanvasContents), intermediateCanvasStream, SandwichCanvasesElement.streamContained(this.tailCanvasContents));
    }
}

